<?php

namespace Modules\Attendance\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\Admin\Staff;
use Illuminate\Support\Facades\DB;

class DayOff extends Model
{
    protected $table = 'att_day_offs';

    protected $fillable = [
        'off_type_id',
        'reason',
        'off_date',
        'department_id',
        'role_name',
        'repeat_yearly',
        'added_by',
        'status',
    ];

    protected $casts = [
        'off_date' => 'date',
        'repeat_yearly' => 'boolean',
        'status' => 'boolean',
    ];

    public function offType(): BelongsTo
    {
        return $this->belongsTo(OffType::class, 'off_type_id');
    }

    public function getDepartmentAttribute()
    {
        if (!$this->department_id) return null;
        return DB::table('departments')->where('id', $this->department_id)->first();
    }

    public function addedBy(): BelongsTo
    {
        return $this->belongsTo(Staff::class, 'added_by');
    }
}
