<?php

namespace Modules\Attendance\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class RequestType extends Model
{
    protected $table = 'att_request_types';

    protected $fillable = [
        'name',
        'color',
        'requires_leave_type',
        'status',
    ];

    protected $casts = [
        'requires_leave_type' => 'boolean',
        'status' => 'boolean',
    ];

    public function leaveApplications(): HasMany
    {
        return $this->hasMany(LeaveApplication::class, 'request_type_id');
    }
}
