<style>
.extra-hours-container { max-width: 1200px; margin: 0 auto; padding: 20px; }
.extra-hours-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px; flex-wrap: wrap; gap: 16px; }
.extra-hours-title { font-size: 24px; font-weight: 700; color: var(--text-primary); margin: 0; display: flex; align-items: center; gap: 10px; }
.extra-hours-title svg { width: 28px; height: 28px; color: var(--primary); }
.btn-assign { 
    display: inline-flex; align-items: center; gap: 8px; 
    background: linear-gradient(135deg, var(--primary), var(--primary-hover)); color: #fff; 
    padding: 10px 20px; border-radius: 8px; text-decoration: none; 
    font-weight: 600; font-size: 14px; transition: all 0.2s; 
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
}
.btn-assign:hover { transform: translateY(-2px); box-shadow: 0 6px 16px rgba(59, 130, 246, 0.4); color: #fff; }
.btn-assign svg { width: 18px; height: 18px; }

.stats-row { display: grid; grid-template-columns: repeat(4, 1fr); gap: 16px; margin-bottom: 24px; }
.stat-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 10px; padding: 16px; text-align: center; }
.stat-value { font-size: 28px; font-weight: 700; }
.stat-value.assigned { color: #3b82f6; }
.stat-value.acknowledged { color: #f59e0b; }
.stat-value.completed { color: #10b981; }
.stat-value.total { color: var(--primary); }
.stat-label { font-size: 12px; color: var(--text-muted); margin-top: 4px; }

.filter-tabs { display: flex; gap: 8px; margin-bottom: 20px; flex-wrap: wrap; }
.filter-tab { 
    padding: 8px 16px; background: var(--card-bg); border: 1px solid var(--card-border); 
    border-radius: 8px; font-size: 13px; font-weight: 500; color: var(--text-primary); 
    cursor: pointer; transition: all 0.2s; text-decoration: none; 
}
.filter-tab:hover { border-color: var(--primary); color: var(--primary); }
.filter-tab.active { background: var(--primary); border-color: var(--primary); color: #fff; }

.table-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; }
.extra-table { width: 100%; border-collapse: collapse; }
.extra-table th { background: var(--hover-bg); padding: 12px 16px; text-align: left; font-size: 12px; font-weight: 600; color: var(--text-muted); text-transform: uppercase; }
.extra-table td { padding: 14px 16px; border-bottom: 1px solid var(--card-border); font-size: 14px; color: var(--text-primary); }
.extra-table tr:last-child td { border-bottom: none; }
.extra-table tr:hover td { background: var(--hover-bg); }

.staff-cell { display: flex; align-items: center; gap: 10px; }
.staff-avatar-sm { width: 32px; height: 32px; border-radius: 50%; background: linear-gradient(135deg, var(--primary), var(--primary-hover)); display: flex; align-items: center; justify-content: center; color: white; font-weight: 600; font-size: 12px; flex-shrink: 0; }
.staff-name { font-weight: 600; color: var(--text-primary); }

.hours-badge { display: inline-flex; align-items: center; padding: 4px 10px; background: rgba(59, 130, 246, 0.1); color: #3b82f6; border-radius: 6px; font-size: 13px; font-weight: 600; }
.type-badge { display: inline-flex; align-items: center; gap: 6px; padding: 4px 10px; background: var(--hover-bg); border-radius: 6px; font-size: 12px; font-weight: 500; }
.type-badge .dot { width: 8px; height: 8px; border-radius: 50%; }

.status-badge { padding: 4px 12px; border-radius: 20px; font-size: 12px; font-weight: 600; }
.status-assigned { background: rgba(59, 130, 246, 0.15); color: #3b82f6; }
.status-acknowledged { background: rgba(245, 158, 11, 0.15); color: #f59e0b; }
.status-completed { background: rgba(16, 185, 129, 0.15); color: #10b981; }
.status-cancelled { background: rgba(107, 114, 128, 0.15); color: #6b7280; }

.action-btns { display: flex; gap: 6px; }
.action-btn { padding: 6px 12px; border-radius: 6px; font-size: 12px; font-weight: 500; cursor: pointer; border: none; transition: all 0.2s; text-decoration: none; }
.action-btn.complete { background: #10b981; color: white; }
.action-btn.complete:hover { background: #059669; }
.action-btn.cancel { background: #ef4444; color: white; }
.action-btn.cancel:hover { background: #dc2626; }
.action-btn.view { background: var(--hover-bg); color: var(--text-primary); border: 1px solid var(--card-border); }
.action-btn.view:hover { border-color: var(--primary); color: var(--primary); }

.empty-row { text-align: center; padding: 40px !important; color: var(--text-muted); }

@media (max-width: 768px) {
    .stats-row { grid-template-columns: repeat(2, 1fr); }
    .extra-hours-header { flex-direction: column; align-items: flex-start; }
    .btn-assign { width: 100%; justify-content: center; }
}
</style>

<div class="extra-hours-container">
    <div class="extra-hours-header">
        <h1 class="extra-hours-title">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
            </svg>
            Extra Work Hours
        </h1>
        <a href="{{ route('admin.attendance.additional_hours.create') }}" class="btn-assign">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M12 4v16m8-8H4"/></svg>
            Assign Extra Work
        </a>
    </div>

    @if(session('success'))
        <div style="background: rgba(16, 185, 129, 0.1); border: 1px solid #10b981; color: #10b981; padding: 12px 16px; border-radius: 8px; margin-bottom: 20px;">
            {{ session('success') }}
        </div>
    @endif

    {{-- Stats --}}
    <div class="stats-row">
        <div class="stat-card">
            <div class="stat-value assigned">{{ $stats['assigned'] ?? 0 }}</div>
            <div class="stat-label">Assigned</div>
        </div>
        <div class="stat-card">
            <div class="stat-value acknowledged">{{ $stats['acknowledged'] ?? 0 }}</div>
            <div class="stat-label">Acknowledged</div>
        </div>
        <div class="stat-card">
            <div class="stat-value completed">{{ $stats['completed'] ?? 0 }}</div>
            <div class="stat-label">Completed</div>
        </div>
        <div class="stat-card">
            <div class="stat-value total">{{ $stats['total'] ?? 0 }}</div>
            <div class="stat-label">Total</div>
        </div>
    </div>

    {{-- Filter Tabs --}}
    <div class="filter-tabs">
        <a href="{{ route('admin.attendance.additional_hours.index') }}" class="filter-tab {{ ($currentStatus ?? 'all') == 'all' ? 'active' : '' }}">All</a>
        <a href="{{ route('admin.attendance.additional_hours.index', ['status' => 'assigned']) }}" class="filter-tab {{ ($currentStatus ?? '') == 'assigned' ? 'active' : '' }}">Assigned</a>
        <a href="{{ route('admin.attendance.additional_hours.index', ['status' => 'acknowledged']) }}" class="filter-tab {{ ($currentStatus ?? '') == 'acknowledged' ? 'active' : '' }}">Acknowledged</a>
        <a href="{{ route('admin.attendance.additional_hours.index', ['status' => 'completed']) }}" class="filter-tab {{ ($currentStatus ?? '') == 'completed' ? 'active' : '' }}">Completed</a>
    </div>

    {{-- Table --}}
    <div class="table-card">
        <table class="extra-table">
            <thead>
                <tr>
                    <th>Staff</th>
                    <th>Date</th>
                    <th>Hours</th>
                    <th>Type</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($additionalHours ?? [] as $item)
                <tr>
                    <td>
                        <div class="staff-cell">
                            <div class="staff-avatar-sm">{{ strtoupper(substr($item->staff->first_name ?? 'S', 0, 1)) }}</div>
                            <span class="staff-name">{{ $item->staff->first_name ?? '' }} {{ $item->staff->last_name ?? '' }}</span>
                        </div>
                    </td>
                    <td>{{ $item->work_date ? \Carbon\Carbon::parse($item->work_date)->format('d M Y') : '-' }}</td>
                    <td><span class="hours-badge">{{ $item->hours ?? 0 }} hrs</span></td>
                    <td>
                        @if($item->workType)
                        <span class="type-badge">
                            <span class="dot" style="background:{{ $item->workType->color ?? '#6b7280' }}"></span>
                            {{ $item->workType->name }}
                        </span>
                        @else
                        <span style="color:var(--text-muted);">-</span>
                        @endif
                    </td>
                    <td><span class="status-badge status-{{ $item->status }}">{{ ucfirst($item->status) }}</span></td>
                    <td>
                        <div class="action-btns">
                            @if($item->status == 'assigned' || $item->status == 'acknowledged')
                                <form action="{{ route('admin.attendance.additional_hours.complete', $item->id) }}" method="POST" style="display:inline;">
                                    @csrf
                                    <button type="submit" class="action-btn complete" title="Mark Complete">✓</button>
                                </form>
                                <form action="{{ route('admin.attendance.additional_hours.cancel', $item->id) }}" method="POST" style="display:inline;">
                                    @csrf
                                    <button type="submit" class="action-btn cancel" title="Cancel">✗</button>
                                </form>
                            @endif
                            <a href="{{ route('admin.attendance.additional_hours.edit', $item->id) }}" class="action-btn view">View</a>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="empty-row">No extra work assignments found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    {{-- Pagination --}}
    @if(isset($additionalHours) && $additionalHours->hasPages())
    <div style="margin-top: 20px;">
        {{ $additionalHours->links() }}
    </div>
    @endif
</div>
