<style>
    .edit-header {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 24px;
    }
    .edit-title {
        font-size: 22px;
        font-weight: 700;
        color: var(--text-primary);
        margin: 0;
    }
    .edit-subtitle {
        font-size: 13px;
        color: var(--text-secondary);
        margin: 4px 0 0;
    }
    
    .edit-card {
        background: var(--card-bg);
        border: 1px solid var(--card-border);
        border-radius: 12px;
        max-width: 600px;
    }
    .edit-card-header {
        padding: 16px 20px;
        border-bottom: 1px solid var(--card-border);
    }
    .edit-card-title {
        font-size: 16px;
        font-weight: 600;
        color: var(--text-primary);
        margin: 0;
    }
    .edit-card-body {
        padding: 24px;
    }
    
    .edit-form-group {
        margin-bottom: 20px;
    }
    .edit-form-label {
        display: block;
        font-size: 13px;
        font-weight: 600;
        color: var(--text-secondary);
        margin-bottom: 8px;
    }
    .edit-form-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 16px;
    }
    
    .edit-info-box {
        padding: 16px;
        background: var(--body-bg);
        border-radius: 10px;
        margin-bottom: 20px;
    }
    .edit-info-row {
        display: flex;
        justify-content: space-between;
        font-size: 14px;
        padding: 6px 0;
    }
    .edit-info-row:not(:last-child) {
        border-bottom: 1px solid var(--card-border);
    }
    .edit-info-label {
        color: var(--text-muted);
    }
    .edit-info-value {
        font-weight: 600;
        color: var(--text-primary);
    }
    .edit-info-value.success { color: var(--success); }
    
    .edit-actions {
        display: flex;
        gap: 12px;
        justify-content: flex-end;
        padding-top: 12px;
        border-top: 1px solid var(--card-border);
        margin-top: 8px;
    }
</style>

{{-- Header --}}
<div class="edit-header">
    <div>
        <h1 class="edit-title">{{ $pageTitle }}</h1>
        <p class="edit-subtitle">
            {{ $attendance->person_name }} — 
            {{ $attendance->attendance_date->format('l, d F Y') }}
        </p>
    </div>
    <a href="{{ route('admin.attendance.index', ['date' => $attendance->attendance_date->format('Y-m-d')]) }}" 
       class="btn btn-secondary">
        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="width:16px;height:16px;">
            <path d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
        </svg>
        Back
    </a>
</div>

<div class="edit-card">
    <div class="edit-card-header">
        <h3 class="edit-card-title">Edit Attendance Record</h3>
    </div>
    <div class="edit-card-body">
        <form action="{{ route('admin.attendance.update', $attendance->id) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="edit-form-group">
                <label class="edit-form-label">Staff / Admin</label>
                <input type="text" class="form-control" 
                       value="{{ $attendance->person_name }}" 
                       disabled style="background: var(--body-bg);">
            </div>

            <div class="edit-form-group">
                <label class="edit-form-label">Date</label>
                <input type="text" class="form-control" 
                       value="{{ $attendance->attendance_date->format('d F Y (l)') }}" 
                       disabled style="background: var(--body-bg);">
            </div>

            <div class="edit-form-row">
                <div class="edit-form-group">
                    <label class="edit-form-label">Check In Time</label>
                    <input type="time" name="check_in" class="form-control"
                           value="{{ $attendance->check_in ? \Carbon\Carbon::parse($attendance->check_in)->format('H:i') : '' }}">
                </div>

                <div class="edit-form-group">
                    <label class="edit-form-label">Check Out Time</label>
                    <input type="time" name="check_out" class="form-control"
                           value="{{ $attendance->check_out ? \Carbon\Carbon::parse($attendance->check_out)->format('H:i') : '' }}">
                </div>
            </div>

            <div class="edit-form-group">
                <label class="edit-form-label">Status</label>
                <select name="status" class="form-control" required>
                    <option value="present" {{ $attendance->status == 'present' ? 'selected' : '' }}>Present</option>
                    <option value="absent" {{ $attendance->status == 'absent' ? 'selected' : '' }}>Absent</option>
                    <option value="late" {{ $attendance->status == 'late' ? 'selected' : '' }}>Late</option>
                    <option value="half_day" {{ $attendance->status == 'half_day' ? 'selected' : '' }}>Half Day</option>
                    <option value="early_leave" {{ $attendance->status == 'early_leave' ? 'selected' : '' }}>Early Leave</option>
                    <option value="on_leave" {{ $attendance->status == 'on_leave' ? 'selected' : '' }}>On Leave</option>
                    <option value="holiday" {{ $attendance->status == 'holiday' ? 'selected' : '' }}>Holiday</option>
                    <option value="weekend" {{ $attendance->status == 'weekend' ? 'selected' : '' }}>Weekend</option>
                </select>
            </div>

            <div class="edit-form-group">
                <label class="edit-form-label">Remarks</label>
                <textarea name="remarks" class="form-control" rows="3" 
                          placeholder="Optional remarks or notes">{{ $attendance->remarks }}</textarea>
            </div>

            @if($attendance->worked_hours > 0)
                <div class="edit-info-box">
                    <div class="edit-info-row">
                        <span class="edit-info-label">Worked Hours</span>
                        <span class="edit-info-value">{{ number_format($attendance->worked_hours, 2) }} hours</span>
                    </div>
                    @if($attendance->overtime_hours > 0)
                        <div class="edit-info-row">
                            <span class="edit-info-label">Overtime</span>
                            <span class="edit-info-value success">+{{ number_format($attendance->overtime_hours, 2) }} hours</span>
                        </div>
                    @endif
                    @if($attendance->late_minutes > 0)
                        <div class="edit-info-row">
                            <span class="edit-info-label">Late By</span>
                            <span class="edit-info-value" style="color: var(--warning);">{{ $attendance->late_minutes }} minutes</span>
                        </div>
                    @endif
                </div>
            @endif

            <div class="edit-actions">
                <a href="{{ route('admin.attendance.index', ['date' => $attendance->attendance_date->format('Y-m-d')]) }}" 
                   class="btn btn-secondary">Cancel</a>
                <button type="submit" class="btn btn-primary">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="width:16px;height:16px;">
                        <path d="M5 13l4 4L19 7"/>
                    </svg>
                    Update Attendance
                </button>
            </div>
        </form>
    </div>
</div>
