<style>
    :root {
        --cal-present: #10b981;
        --cal-present-bg: #d1fae5;
        --cal-late: #f59e0b;
        --cal-late-bg: #fef3c7;
        --cal-absent: #ef4444;
        --cal-absent-bg: #fee2e2;
        --cal-leave: #3b82f6;
        --cal-leave-bg: #dbeafe;
        --cal-holiday: #8b5cf6;
        --cal-holiday-bg: #ede9fe;
        --cal-weekend: #6b7280;
        --cal-weekend-bg: #f3f4f6;
        --cal-no-shift: #9ca3af;
    }

    .my-att-page { padding: 20px; max-width: 1200px; margin: 0 auto; }
    
    /* Header */
    .my-att-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px; flex-wrap: wrap; gap: 16px; }
    .my-att-title { font-size: 24px; font-weight: 700; color: var(--text-primary); margin: 0; display: flex; align-items: center; gap: 10px; }
    .my-att-title-icon { width: 32px; height: 32px; background: linear-gradient(135deg, #3b82f6, #1d4ed8); border-radius: 8px; display: flex; align-items: center; justify-content: center; }
    .my-att-title-icon svg { width: 18px; height: 18px; color: #fff; }
    .my-att-nav { display: flex; align-items: center; gap: 8px; background: var(--card-bg); padding: 6px; border-radius: 12px; border: 1px solid var(--card-border); }
    .my-att-nav select { padding: 8px 12px; border: none; border-radius: 8px; font-size: 14px; font-weight: 500; background: transparent; color: var(--text-primary); cursor: pointer; }
    .my-att-nav select:hover { background: var(--hover-bg); }
    .my-att-nav-btn { width: 36px; height: 36px; border: none; border-radius: 8px; background: transparent; cursor: pointer; display: flex; align-items: center; justify-content: center; color: var(--text-muted); transition: all 0.2s; }
    .my-att-nav-btn:hover { background: var(--hover-bg); color: var(--text-primary); }

    /* Shift Info Card - Improved */
    .shift-card { background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 50%, #1e40af 100%); border-radius: 20px; padding: 24px; color: #fff; margin-bottom: 24px; position: relative; overflow: hidden; }
    .shift-card::before { content: ''; position: absolute; top: -50%; right: -20%; width: 300px; height: 300px; background: rgba(255,255,255,0.1); border-radius: 50%; }
    .shift-card::after { content: ''; position: absolute; bottom: -30%; left: -10%; width: 200px; height: 200px; background: rgba(255,255,255,0.05); border-radius: 50%; }
    .shift-card-content { position: relative; z-index: 1; }
    .shift-card-header { display: flex; align-items: center; gap: 12px; margin-bottom: 20px; }
    .shift-card-icon { width: 48px; height: 48px; background: rgba(255,255,255,0.2); border-radius: 12px; display: flex; align-items: center; justify-content: center; font-size: 24px; }
    .shift-card-title { font-size: 12px; font-weight: 500; opacity: 0.8; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 4px; }
    .shift-card-name { font-size: 24px; font-weight: 700; margin: 0; }
    .shift-card-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(140px, 1fr)); gap: 16px; }
    .shift-card-item { background: rgba(255,255,255,0.15); backdrop-filter: blur(10px); border-radius: 12px; padding: 16px; text-align: center; transition: transform 0.2s, background 0.2s; }
    .shift-card-item:hover { background: rgba(255,255,255,0.25); transform: translateY(-2px); }
    .shift-card-item-icon { font-size: 20px; margin-bottom: 8px; }
    .shift-card-item-label { font-size: 11px; opacity: 0.8; text-transform: uppercase; letter-spacing: 0.5px; margin-bottom: 4px; }
    .shift-card-item-value { font-size: 18px; font-weight: 700; }
    .shift-card-item.lunch { background: rgba(254, 240, 138, 0.2); border: 1px solid rgba(254, 240, 138, 0.3); }
    .shift-card-footer { margin-top: 16px; padding-top: 16px; border-top: 1px solid rgba(255,255,255,0.2); display: flex; align-items: center; gap: 8px; font-size: 13px; opacity: 0.9; }

    /* No Shift Card */
    .shift-card.no-shift { background: linear-gradient(135deg, #6b7280 0%, #4b5563 100%); }

    /* Stats Grid - Improved */
    .stats-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(150px, 1fr)); gap: 16px; margin-bottom: 24px; }
    .stat-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 16px; padding: 20px; position: relative; overflow: hidden; transition: all 0.3s; }
    .stat-card:hover { transform: translateY(-4px); box-shadow: 0 12px 24px rgba(0,0,0,0.1); }
    .stat-card-icon { width: 40px; height: 40px; border-radius: 10px; display: flex; align-items: center; justify-content: center; font-size: 18px; margin-bottom: 12px; }
    .stat-card-icon.present { background: var(--cal-present-bg); color: var(--cal-present); }
    .stat-card-icon.absent { background: var(--cal-absent-bg); color: var(--cal-absent); }
    .stat-card-icon.late { background: var(--cal-late-bg); color: var(--cal-late); }
    .stat-card-icon.leave { background: var(--cal-leave-bg); color: var(--cal-leave); }
    .stat-card-icon.holiday { background: var(--cal-holiday-bg); color: var(--cal-holiday); }
    .stat-card-icon.hours { background: #dbeafe; color: #3b82f6; }
    .stat-card-icon.overtime { background: #d1fae5; color: #10b981; }
    .stat-card-value { font-size: 32px; font-weight: 800; line-height: 1; margin-bottom: 4px; color: var(--text-primary); }
    .stat-card-label { font-size: 12px; font-weight: 600; color: var(--text-muted); text-transform: uppercase; letter-spacing: 0.5px; }
    .stat-card-progress { height: 4px; background: var(--hover-bg); border-radius: 2px; margin-top: 12px; overflow: hidden; }
    .stat-card-progress-bar { height: 100%; border-radius: 2px; transition: width 0.5s ease; }
    .stat-card-progress-bar.present { background: var(--cal-present); }
    .stat-card-progress-bar.absent { background: var(--cal-absent); }
    .stat-card-progress-bar.late { background: var(--cal-late); }
    .stat-card-progress-bar.leave { background: var(--cal-leave); }

    /* Attendance Ring */
    .att-ring-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 16px; padding: 20px; display: flex; align-items: center; gap: 20px; margin-bottom: 24px; }
    .att-ring { width: 100px; height: 100px; position: relative; }
    .att-ring svg { transform: rotate(-90deg); }
    .att-ring-bg { fill: none; stroke: var(--hover-bg); stroke-width: 8; }
    .att-ring-progress { fill: none; stroke: var(--cal-present); stroke-width: 8; stroke-linecap: round; transition: stroke-dashoffset 0.5s ease; }
    .att-ring-text { position: absolute; inset: 0; display: flex; flex-direction: column; align-items: center; justify-content: center; }
    .att-ring-percent { font-size: 24px; font-weight: 800; color: var(--text-primary); }
    .att-ring-label { font-size: 10px; color: var(--text-muted); text-transform: uppercase; }
    .att-ring-info h4 { font-size: 16px; font-weight: 600; color: var(--text-primary); margin: 0 0 4px; }
    .att-ring-info p { font-size: 13px; color: var(--text-muted); margin: 0; }

    /* Calendar Card - Improved */
    .cal-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 20px; overflow: hidden; box-shadow: 0 4px 24px rgba(0,0,0,0.06); }
    .cal-header { padding: 20px 24px; border-bottom: 1px solid var(--card-border); display: flex; justify-content: space-between; align-items: center; }
    .cal-title { font-size: 18px; font-weight: 700; color: var(--text-primary); display: flex; align-items: center; gap: 8px; }
    .cal-title-icon { color: var(--primary); }
    .cal-subtitle { font-size: 13px; color: var(--text-muted); background: var(--hover-bg); padding: 6px 12px; border-radius: 20px; }

    /* Calendar Grid */
    .cal-grid { display: grid; grid-template-columns: repeat(7, 1fr); }
    .cal-weekday { padding: 14px 8px; text-align: center; font-size: 12px; font-weight: 700; color: var(--text-muted); text-transform: uppercase; letter-spacing: 0.5px; background: var(--hover-bg); border-bottom: 1px solid var(--card-border); }
    .cal-weekday:nth-child(6), .cal-weekday:nth-child(7) { color: var(--cal-weekend); }
    
    .cal-day { min-height: 100px; padding: 10px; border-right: 1px solid var(--card-border); border-bottom: 1px solid var(--card-border); cursor: pointer; transition: all 0.2s; position: relative; background: var(--card-bg); }
    .cal-day:nth-child(7n) { border-right: none; }
    .cal-day:hover { background: var(--hover-bg); transform: scale(1.02); z-index: 2; box-shadow: 0 8px 24px rgba(0,0,0,0.1); }
    .cal-day.empty { background: var(--hover-bg); cursor: default; }
    .cal-day.empty:hover { transform: none; box-shadow: none; }
    .cal-day.today { background: linear-gradient(135deg, #eff6ff, #dbeafe); }
    .cal-day.today::before { content: ''; position: absolute; top: 0; left: 0; right: 0; height: 3px; background: var(--primary); }
    .cal-day.selected { background: #dbeafe; box-shadow: inset 0 0 0 2px var(--primary); }

    .cal-day-header { display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 8px; }
    .cal-day-num { font-size: 15px; font-weight: 700; color: var(--text-primary); width: 28px; height: 28px; display: flex; align-items: center; justify-content: center; border-radius: 8px; }
    .cal-day.today .cal-day-num { background: var(--primary); color: #fff; }
    .cal-today-badge { font-size: 9px; background: var(--primary); color: #fff; padding: 3px 8px; border-radius: 6px; font-weight: 600; text-transform: uppercase; letter-spacing: 0.5px; }

    .cal-day-status { display: inline-flex; align-items: center; gap: 4px; padding: 4px 10px; border-radius: 8px; font-size: 11px; font-weight: 700; text-transform: uppercase; letter-spacing: 0.3px; }
    .cal-day-status.present { background: var(--cal-present-bg); color: var(--cal-present); }
    .cal-day-status.late { background: var(--cal-late-bg); color: var(--cal-late); }
    .cal-day-status.absent { background: var(--cal-absent-bg); color: var(--cal-absent); }
    .cal-day-status.leave { background: var(--cal-leave-bg); color: var(--cal-leave); }
    .cal-day-status.holiday { background: var(--cal-holiday-bg); color: var(--cal-holiday); }
    .cal-day-status.weekend { background: var(--cal-weekend-bg); color: var(--cal-weekend); }
    .cal-day-status.half_day { background: #ffedd5; color: #ea580c; }
    .cal-day-status.early_leave { background: #fef3c7; color: #d97706; }
    .cal-day-status.no_shift { background: #e5e7eb; color: #6b7280; }

    .cal-day-hours { font-size: 14px; font-weight: 800; color: var(--text-primary); margin-top: 8px; display: flex; align-items: center; gap: 6px; }
    .cal-day-ot { font-size: 10px; font-weight: 600; color: var(--cal-present); background: var(--cal-present-bg); padding: 2px 6px; border-radius: 4px; }

    .cal-day-info { font-size: 10px; color: var(--text-muted); margin-top: 4px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }

    /* Legend - Improved */
    .cal-legend { padding: 20px 24px; border-top: 1px solid var(--card-border); display: flex; flex-wrap: wrap; gap: 20px; background: var(--hover-bg); }
    .cal-legend-item { display: flex; align-items: center; gap: 8px; font-size: 12px; font-weight: 500; color: var(--text-muted); }
    .cal-legend-dot { width: 14px; height: 14px; border-radius: 6px; }
    .cal-legend-dot.present { background: var(--cal-present); }
    .cal-legend-dot.late { background: var(--cal-late); }
    .cal-legend-dot.absent { background: var(--cal-absent); }
    .cal-legend-dot.leave { background: var(--cal-leave); }
    .cal-legend-dot.holiday { background: var(--cal-holiday); }
    .cal-legend-dot.weekend { background: var(--cal-weekend); }
    .cal-legend-dot.no_shift { background: var(--cal-no-shift); }

    /* Day Detail Panel - Improved */
    .day-detail { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 20px; margin-top: 24px; display: none; overflow: hidden; box-shadow: 0 4px 24px rgba(0,0,0,0.08); animation: slideUp 0.3s ease; }
    .day-detail.show { display: block; }
    @keyframes slideUp { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }
    
    .day-detail-header { padding: 20px 24px; border-bottom: 1px solid var(--card-border); display: flex; justify-content: space-between; align-items: center; background: var(--hover-bg); }
    .day-detail-title { font-size: 18px; font-weight: 700; color: var(--text-primary); display: flex; align-items: center; gap: 10px; }
    .day-detail-title-icon { width: 36px; height: 36px; background: var(--primary); color: #fff; border-radius: 10px; display: flex; align-items: center; justify-content: center; }
    .day-detail-close { width: 36px; height: 36px; border: none; background: var(--card-bg); border-radius: 10px; cursor: pointer; display: flex; align-items: center; justify-content: center; color: var(--text-muted); transition: all 0.2s; }
    .day-detail-close:hover { background: var(--cal-absent-bg); color: var(--cal-absent); }
    
    .day-detail-body { padding: 24px; }
    .day-detail-status { text-align: center; padding: 20px; background: var(--hover-bg); border-radius: 16px; margin-bottom: 24px; }
    .day-detail-status-icon { font-size: 48px; margin-bottom: 8px; }
    .day-detail-status-text { font-size: 18px; font-weight: 700; color: var(--text-primary); }
    
    .day-detail-timeline { display: flex; justify-content: center; align-items: center; gap: 20px; margin-bottom: 24px; }
    .day-detail-time { text-align: center; padding: 16px 24px; background: var(--card-bg); border: 2px solid var(--card-border); border-radius: 12px; min-width: 100px; }
    .day-detail-time-label { font-size: 11px; font-weight: 600; color: var(--text-muted); text-transform: uppercase; margin-bottom: 4px; }
    .day-detail-time-value { font-size: 20px; font-weight: 800; color: var(--text-primary); }
    .day-detail-time.in { border-color: var(--cal-present); }
    .day-detail-time.in .day-detail-time-value { color: var(--cal-present); }
    .day-detail-time.out { border-color: var(--cal-absent); }
    .day-detail-time.out .day-detail-time-value { color: var(--cal-absent); }
    .day-detail-arrow { color: var(--text-muted); font-size: 24px; }
    
    .day-detail-stats { display: grid; grid-template-columns: repeat(auto-fit, minmax(120px, 1fr)); gap: 16px; }
    .day-detail-stat { text-align: center; padding: 16px; background: var(--hover-bg); border-radius: 12px; }
    .day-detail-stat-icon { font-size: 20px; margin-bottom: 6px; }
    .day-detail-stat-value { font-size: 18px; font-weight: 700; color: var(--text-primary); }
    .day-detail-stat-label { font-size: 11px; color: var(--text-muted); text-transform: uppercase; margin-top: 2px; }

    /* Responsive */
    @media (max-width: 768px) {
        .my-att-page { padding: 16px; }
        .shift-card { padding: 20px; border-radius: 16px; }
        .shift-card-grid { grid-template-columns: repeat(2, 1fr); }
        .stats-grid { grid-template-columns: repeat(2, 1fr); gap: 12px; }
        .stat-card { padding: 16px; }
        .stat-card-value { font-size: 24px; }
        .cal-day { min-height: 80px; padding: 8px; }
        .cal-day-num { font-size: 13px; width: 24px; height: 24px; }
        .cal-day-status { font-size: 9px; padding: 3px 6px; }
        .cal-day-hours { font-size: 12px; }
        .att-ring-card { flex-direction: column; text-align: center; }
        .day-detail-timeline { flex-direction: column; gap: 12px; }
        .day-detail-arrow { transform: rotate(90deg); }
    }
</style>

<div class="my-att-page">
    {{-- Header --}}
    <div class="my-att-header">
        <h1 class="my-att-title">
            <span class="my-att-title-icon">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
            </span>
            My Attendance
        </h1>
        <div class="my-att-nav">
            <button class="my-att-nav-btn" onclick="navigateMonth(-1)" title="Previous Month">
                <svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M15 19l-7-7 7-7"/></svg>
            </button>
            <select id="monthFilter" onchange="applyFilter()">
                @foreach(['January','February','March','April','May','June','July','August','September','October','November','December'] as $i => $m)
                    <option value="{{ $i + 1 }}" {{ $month == ($i + 1) ? 'selected' : '' }}>{{ $m }}</option>
                @endforeach
            </select>
            <select id="yearFilter" onchange="applyFilter()">
                @for($y = now()->year; $y >= now()->year - 3; $y--)
                    <option value="{{ $y }}" {{ $year == $y ? 'selected' : '' }}>{{ $y }}</option>
                @endfor
            </select>
            <button class="my-att-nav-btn" onclick="navigateMonth(1)" title="Next Month">
                <svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 5l7 7-7 7"/></svg>
            </button>
        </div>
    </div>

    {{-- Shift Info Card --}}
    @if($shiftType)
    <div class="shift-card">
        <div class="shift-card-content">
            <div class="shift-card-header">
                <div class="shift-card-icon">☀️</div>
                <div>
                    <div class="shift-card-title">Your Assigned Shift</div>
                    <h2 class="shift-card-name">{{ $shiftType->name }}</h2>
                </div>
            </div>
            <div class="shift-card-grid">
                <div class="shift-card-item">
                    <div class="shift-card-item-icon">🕐</div>
                    <div class="shift-card-item-label">Check In</div>
                    <div class="shift-card-item-value">{{ \Carbon\Carbon::parse($shiftType->start_time)->format('h:i A') }}</div>
                </div>
                <div class="shift-card-item">
                    <div class="shift-card-item-icon">🕕</div>
                    <div class="shift-card-item-label">Check Out</div>
                    <div class="shift-card-item-value">{{ \Carbon\Carbon::parse($shiftType->end_time)->format('h:i A') }}</div>
                </div>
                <div class="shift-card-item lunch">
                    <div class="shift-card-item-icon">🍽️</div>
                    <div class="shift-card-item-label">Lunch Break</div>
                    <div class="shift-card-item-value">
                        @if($shiftType->lunch_start_time && $shiftType->lunch_end_time)
                            {{ \Carbon\Carbon::parse($shiftType->lunch_start_time)->format('h:i') }} - {{ \Carbon\Carbon::parse($shiftType->lunch_end_time)->format('h:i') }}
                        @else
                            01:00 - 02:00
                        @endif
                    </div>
                </div>
                <div class="shift-card-item">
                    <div class="shift-card-item-icon">⏱️</div>
                    <div class="shift-card-item-label">Working Hours</div>
                    <div class="shift-card-item-value">{{ $shiftType->working_hours ?? 8 }} hrs</div>
                </div>
            </div>
            @php
                $daysOff = $shiftType->days_off ?? ['saturday', 'sunday'];
                if (is_string($daysOff)) $daysOff = json_decode($daysOff, true) ?? ['saturday', 'sunday'];
            @endphp
            <div class="shift-card-footer">
                <span>📅</span>
                <span>Week Off: {{ collect($daysOff)->map(fn($d) => ucfirst($d))->join(', ') }}</span>
            </div>
        </div>
    </div>
    @else
    <div class="shift-card no-shift">
        <div class="shift-card-content">
            <div class="shift-card-header">
                <div class="shift-card-icon">⚠️</div>
                <div>
                    <div class="shift-card-title">Shift Status</div>
                    <h2 class="shift-card-name">No Shift Assigned</h2>
                </div>
            </div>
            <div class="shift-card-footer">
                <span>ℹ️</span>
                <span>Please contact your administrator to get a shift assigned</span>
            </div>
        </div>
    </div>
    @endif

    {{-- Attendance Ring + Stats --}}
    @php
        $totalWorkingDays = $stats['working_days'] > 0 ? $stats['working_days'] : 1;
        $attendancePercent = $stats['present'] > 0 ? round(($stats['present'] / $totalWorkingDays) * 100) : 0;
        $circumference = 2 * 3.14159 * 42;
        $offset = $circumference - ($attendancePercent / 100) * $circumference;
    @endphp
    <div class="att-ring-card">
        <div class="att-ring">
            <svg width="100" height="100" viewBox="0 0 100 100">
                <circle class="att-ring-bg" cx="50" cy="50" r="42"/>
                <circle class="att-ring-progress" cx="50" cy="50" r="42" 
                    stroke-dasharray="{{ $circumference }}" 
                    stroke-dashoffset="{{ $offset }}"/>
            </svg>
            <div class="att-ring-text">
                <span class="att-ring-percent">{{ $attendancePercent }}%</span>
                <span class="att-ring-label">Rate</span>
            </div>
        </div>
        <div class="att-ring-info">
            <h4>Attendance Rate for {{ \Carbon\Carbon::create($year, $month, 1)->format('F Y') }}</h4>
            <p>{{ $stats['present'] }} present out of {{ $stats['working_days'] }} working days</p>
        </div>
    </div>

    {{-- Stats Grid --}}
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-card-icon present">✓</div>
            <div class="stat-card-value">{{ $stats['present'] }}</div>
            <div class="stat-card-label">Present</div>
            <div class="stat-card-progress"><div class="stat-card-progress-bar present" style="width: {{ $stats['working_days'] > 0 ? ($stats['present'] / $stats['working_days']) * 100 : 0 }}%"></div></div>
        </div>
        <div class="stat-card">
            <div class="stat-card-icon absent">✗</div>
            <div class="stat-card-value">{{ $stats['absent'] }}</div>
            <div class="stat-card-label">Absent</div>
            <div class="stat-card-progress"><div class="stat-card-progress-bar absent" style="width: {{ $stats['working_days'] > 0 ? ($stats['absent'] / $stats['working_days']) * 100 : 0 }}%"></div></div>
        </div>
        <div class="stat-card">
            <div class="stat-card-icon late">⏰</div>
            <div class="stat-card-value">{{ $stats['late'] }}</div>
            <div class="stat-card-label">Late</div>
            <div class="stat-card-progress"><div class="stat-card-progress-bar late" style="width: {{ $stats['working_days'] > 0 ? ($stats['late'] / $stats['working_days']) * 100 : 0 }}%"></div></div>
        </div>
        <div class="stat-card">
            <div class="stat-card-icon leave">📋</div>
            <div class="stat-card-value">{{ $stats['leave'] }}</div>
            <div class="stat-card-label">On Leave</div>
            <div class="stat-card-progress"><div class="stat-card-progress-bar leave" style="width: {{ $stats['working_days'] > 0 ? ($stats['leave'] / $stats['working_days']) * 100 : 0 }}%"></div></div>
        </div>
        <div class="stat-card">
            <div class="stat-card-icon holiday">🎉</div>
            <div class="stat-card-value">{{ $stats['holiday'] }}</div>
            <div class="stat-card-label">Holidays</div>
        </div>
        <div class="stat-card">
            <div class="stat-card-icon hours">⏱️</div>
            <div class="stat-card-value">{{ number_format($stats['total_hours'], 1) }}</div>
            <div class="stat-card-label">Total Hours</div>
        </div>
        <div class="stat-card">
            <div class="stat-card-icon overtime">🌟</div>
            <div class="stat-card-value">{{ number_format($stats['overtime_hours'], 1) }}</div>
            <div class="stat-card-label">Overtime</div>
        </div>
    </div>

    {{-- Calendar --}}
    <div class="cal-card">
        <div class="cal-header">
            <span class="cal-title">
                <svg class="cal-title-icon" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                {{ \Carbon\Carbon::create($year, $month, 1)->format('F Y') }}
            </span>
            <span class="cal-subtitle">{{ $stats['working_days'] }} working days</span>
        </div>
        
        <div class="cal-grid">
            <div class="cal-weekday">Mon</div>
            <div class="cal-weekday">Tue</div>
            <div class="cal-weekday">Wed</div>
            <div class="cal-weekday">Thu</div>
            <div class="cal-weekday">Fri</div>
            <div class="cal-weekday">Sat</div>
            <div class="cal-weekday">Sun</div>
            
            @for($i = 1; $i < $firstDayOfWeek; $i++)
                <div class="cal-day empty"></div>
            @endfor
            
            @foreach($calendarData as $day => $data)
                @php
                    $statusClass = $data['status'];
                    $statusLabel = match($data['status']) {
                        'present' => '✓ Present',
                        'late' => '⏰ Late',
                        'early_leave' => '↩ Early',
                        'half_day' => '½ Half',
                        'absent' => '✗ Absent',
                        'leave' => '📋 ' . ($data['leave']?->leaveType?->name ?? 'Leave'),
                        'holiday' => '🎉 Holiday',
                        'weekend' => '🔒 Off',
                        'no_shift' => '⚠ No Shift',
                        default => ''
                    };
                    $extraInfo = '';
                    if ($data['holiday']) $extraInfo = $data['holiday']->name ?? '';
                    elseif ($data['leave']) $extraInfo = $data['leave']->leaveType?->name ?? '';
                @endphp
                <div class="cal-day {{ $data['isToday'] ? 'today' : '' }}" 
                     onclick="showDayDetail({{ $day }})"
                     data-day="{{ $day }}"
                     data-status="{{ $data['status'] }}"
                     data-hours="{{ $data['hours'] }}"
                     data-checkin="{{ $data['attendance']?->check_in ? \Carbon\Carbon::parse($data['attendance']->check_in)->format('h:i A') : '-' }}"
                     data-checkout="{{ $data['attendance']?->check_out ? \Carbon\Carbon::parse($data['attendance']->check_out)->format('h:i A') : '-' }}"
                     data-overtime="{{ $data['attendance']?->overtime_hours ?? 0 }}"
                     data-late="{{ $data['attendance']?->late_minutes ?? 0 }}"
                     data-info="{{ $extraInfo }}">
                    
                    <div class="cal-day-header">
                        <span class="cal-day-num">{{ $day }}</span>
                        @if($data['isToday'])
                            <span class="cal-today-badge">Today</span>
                        @endif
                    </div>
                    
                    @if($data['status'] != 'none' && !$data['isFuture'])
                        <span class="cal-day-status {{ $statusClass }}">{{ $statusLabel }}</span>
                        
                        @if($data['hours'] > 0)
                            <div class="cal-day-hours">
                                {{ number_format($data['hours'], 1) }}h
                                @if(($data['attendance']?->overtime_hours ?? 0) > 0)
                                    <span class="cal-day-ot">+{{ number_format($data['attendance']->overtime_hours, 1) }}</span>
                                @endif
                            </div>
                        @endif
                        
                        @if($extraInfo)
                            <div class="cal-day-info">{{ $extraInfo }}</div>
                        @endif
                    @endif
                </div>
            @endforeach
        </div>
        
        <div class="cal-legend">
            <div class="cal-legend-item"><span class="cal-legend-dot present"></span> Present</div>
            <div class="cal-legend-item"><span class="cal-legend-dot late"></span> Late</div>
            <div class="cal-legend-item"><span class="cal-legend-dot absent"></span> Absent</div>
            <div class="cal-legend-item"><span class="cal-legend-dot leave"></span> On Leave</div>
            <div class="cal-legend-item"><span class="cal-legend-dot holiday"></span> Holiday</div>
            <div class="cal-legend-item"><span class="cal-legend-dot weekend"></span> Weekend</div>
            <div class="cal-legend-item"><span class="cal-legend-dot no_shift"></span> No Shift</div>
        </div>
    </div>

    {{-- Day Detail Panel --}}
    <div class="day-detail" id="dayDetailPanel">
        <div class="day-detail-header">
            <span class="day-detail-title">
                <span class="day-detail-title-icon">📅</span>
                <span id="dayDetailTitle">January 1, 2026</span>
            </span>
            <button class="day-detail-close" onclick="closeDayDetail()">
                <svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M6 18L18 6M6 6l12 12"/></svg>
            </button>
        </div>
        <div class="day-detail-body">
            <div class="day-detail-status">
                <div class="day-detail-status-icon" id="dayDetailStatusIcon">✓</div>
                <div class="day-detail-status-text" id="dayDetailStatusText">Present</div>
            </div>
            
            <div class="day-detail-timeline">
                <div class="day-detail-time in">
                    <div class="day-detail-time-label">Check In</div>
                    <div class="day-detail-time-value" id="dayDetailCheckIn">-</div>
                </div>
                <div class="day-detail-arrow">→</div>
                <div class="day-detail-time out">
                    <div class="day-detail-time-label">Check Out</div>
                    <div class="day-detail-time-value" id="dayDetailCheckOut">-</div>
                </div>
            </div>
            
            <div class="day-detail-stats">
                <div class="day-detail-stat">
                    <div class="day-detail-stat-icon">⏱️</div>
                    <div class="day-detail-stat-value" id="dayDetailHours">-</div>
                    <div class="day-detail-stat-label">Hours Worked</div>
                </div>
                <div class="day-detail-stat">
                    <div class="day-detail-stat-icon">🌟</div>
                    <div class="day-detail-stat-value" id="dayDetailOvertime">-</div>
                    <div class="day-detail-stat-label">Overtime</div>
                </div>
                <div class="day-detail-stat">
                    <div class="day-detail-stat-icon">⏰</div>
                    <div class="day-detail-stat-value" id="dayDetailLate">-</div>
                    <div class="day-detail-stat-label">Late By</div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
const monthNames = ['January','February','March','April','May','June','July','August','September','October','November','December'];
const currentMonth = {{ $month }};
const currentYear = {{ $year }};

function applyFilter() {
    const month = document.getElementById('monthFilter').value;
    const year = document.getElementById('yearFilter').value;
    window.location = '{{ route("admin.attendance.my") }}?month=' + month + '&year=' + year;
}

function navigateMonth(dir) {
    let m = parseInt(document.getElementById('monthFilter').value);
    let y = parseInt(document.getElementById('yearFilter').value);
    m += dir;
    if (m > 12) { m = 1; y++; }
    if (m < 1) { m = 12; y--; }
    window.location = '{{ route("admin.attendance.my") }}?month=' + m + '&year=' + y;
}

function showDayDetail(day) {
    const dayEl = document.querySelector('.cal-day[data-day="' + day + '"]');
    if (!dayEl || dayEl.classList.contains('empty')) return;
    
    document.querySelectorAll('.cal-day.selected').forEach(el => el.classList.remove('selected'));
    dayEl.classList.add('selected');
    
    const status = dayEl.dataset.status;
    const hours = parseFloat(dayEl.dataset.hours) || 0;
    const checkin = dayEl.dataset.checkin;
    const checkout = dayEl.dataset.checkout;
    const overtime = parseFloat(dayEl.dataset.overtime) || 0;
    const late = parseInt(dayEl.dataset.late) || 0;
    
    const statusConfig = {
        'present': { icon: '✅', text: 'Present', color: 'var(--cal-present)' },
        'late': { icon: '⏰', text: 'Late', color: 'var(--cal-late)' },
        'early_leave': { icon: '↩️', text: 'Early Leave', color: 'var(--cal-late)' },
        'half_day': { icon: '½', text: 'Half Day', color: '#ea580c' },
        'absent': { icon: '❌', text: 'Absent', color: 'var(--cal-absent)' },
        'leave': { icon: '📋', text: 'On Leave', color: 'var(--cal-leave)' },
        'holiday': { icon: '🎉', text: 'Holiday', color: 'var(--cal-holiday)' },
        'weekend': { icon: '🔒', text: 'Weekend Off', color: 'var(--cal-weekend)' },
        'no_shift': { icon: '⚠️', text: 'No Shift Assigned', color: 'var(--cal-no-shift)' },
        'none': { icon: '—', text: '-', color: 'var(--text-muted)' }
    };
    
    const config = statusConfig[status] || statusConfig['none'];
    
    document.getElementById('dayDetailTitle').textContent = monthNames[currentMonth - 1] + ' ' + day + ', ' + currentYear;
    document.getElementById('dayDetailStatusIcon').textContent = config.icon;
    document.getElementById('dayDetailStatusText').textContent = config.text;
    document.getElementById('dayDetailStatusText').style.color = config.color;
    document.getElementById('dayDetailCheckIn').textContent = checkin;
    document.getElementById('dayDetailCheckOut').textContent = checkout;
    document.getElementById('dayDetailHours').textContent = hours > 0 ? hours.toFixed(1) + 'h' : '-';
    document.getElementById('dayDetailOvertime').textContent = overtime > 0 ? overtime.toFixed(1) + 'h' : '-';
    document.getElementById('dayDetailLate').textContent = late > 0 ? late + 'm' : '-';
    
    document.getElementById('dayDetailPanel').classList.add('show');
    document.getElementById('dayDetailPanel').scrollIntoView({ behavior: 'smooth', block: 'nearest' });
}

function closeDayDetail() {
    document.getElementById('dayDetailPanel').classList.remove('show');
    document.querySelectorAll('.cal-day.selected').forEach(el => el.classList.remove('selected'));
}

document.addEventListener('DOMContentLoaded', function() {
    const today = new Date();
    if (today.getMonth() + 1 == currentMonth && today.getFullYear() == currentYear) {
        showDayDetail(today.getDate());
    }
});
</script>
