<style>
.leave-admin-container { max-width: 1200px; margin: 0 auto; padding: 20px; }
.leave-admin-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px; flex-wrap: wrap; gap: 16px; }
.leave-admin-title { font-size: 22px; font-weight: 700; color: var(--text-primary); margin: 0; display: flex; align-items: center; gap: 10px; }
.leave-admin-title svg { width: 26px; height: 26px; color: var(--primary); }

.stats-row { display: grid; grid-template-columns: repeat(4, 1fr); gap: 16px; margin-bottom: 24px; }
.stat-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 10px; padding: 16px; text-align: center; }
.stat-value { font-size: 28px; font-weight: 700; }
.stat-value.pending { color: #f59e0b; }
.stat-value.approved { color: #10b981; }
.stat-value.rejected { color: #ef4444; }
.stat-value.total { color: var(--primary); }
.stat-label { font-size: 12px; color: var(--text-muted); margin-top: 4px; }

.filter-row { display: flex; gap: 12px; margin-bottom: 20px; flex-wrap: wrap; align-items: center; }
.filter-select { padding: 8px 12px; border: 1px solid var(--card-border); border-radius: 8px; font-size: 13px; background: var(--card-bg); color: var(--text-primary); min-width: 150px; }
.filter-tab { padding: 8px 16px; background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 8px; font-size: 13px; font-weight: 500; color: var(--text-primary); cursor: pointer; transition: all 0.2s; text-decoration: none; }
.filter-tab:hover { border-color: var(--primary); }
.filter-tab.active { background: var(--primary); border-color: var(--primary); color: #fff; }

.leave-table-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; }
.leave-table { width: 100%; border-collapse: collapse; }
.leave-table th { background: var(--hover-bg); padding: 12px 16px; text-align: left; font-size: 12px; font-weight: 600; color: var(--text-muted); text-transform: uppercase; }
.leave-table td { padding: 14px 16px; border-bottom: 1px solid var(--card-border); font-size: 14px; color: var(--text-primary); }
.leave-table tr:last-child td { border-bottom: none; }
.leave-table tr:hover { background: var(--hover-bg); }

.staff-name { font-weight: 600; color: var(--text-primary); }
.leave-type-badge { display: inline-flex; align-items: center; gap: 6px; padding: 4px 10px; background: var(--hover-bg); border-radius: 6px; font-size: 12px; font-weight: 500; }
.leave-type-badge .dot { width: 8px; height: 8px; border-radius: 50%; }

.status-badge { padding: 4px 12px; border-radius: 20px; font-size: 12px; font-weight: 600; }
.status-new { background: rgba(245, 158, 11, 0.1); color: #f59e0b; }
.status-approved { background: rgba(16, 185, 129, 0.1); color: #10b981; }
.status-rejected { background: rgba(239, 68, 68, 0.1); color: #ef4444; }

.action-btns { display: flex; gap: 6px; }
.action-btn { padding: 6px 12px; border-radius: 6px; font-size: 12px; font-weight: 500; cursor: pointer; border: none; transition: all 0.2s; }
.action-btn.approve { background: #10b981; color: white; }
.action-btn.approve:hover { background: #059669; }
.action-btn.reject { background: #ef4444; color: white; }
.action-btn.reject:hover { background: #dc2626; }
.action-btn.view { background: var(--hover-bg); color: var(--text-primary); border: 1px solid var(--card-border); }
.action-btn.view:hover { border-color: var(--primary); }

.empty-row { text-align: center; padding: 40px !important; color: var(--text-muted); }

/* Reject Modal */
.modal-overlay { position: fixed; inset: 0; background: rgba(0,0,0,0.5); z-index: 9999; display: none; align-items: center; justify-content: center; }
.modal-content { background: var(--card-bg); border-radius: 12px; padding: 24px; max-width: 400px; width: 90%; }
.modal-title { font-size: 18px; font-weight: 600; color: var(--text-primary); margin-bottom: 16px; }
.modal-input { width: 100%; padding: 10px 12px; border: 1px solid var(--card-border); border-radius: 8px; font-size: 14px; margin-bottom: 16px; min-height: 80px; }
.modal-actions { display: flex; gap: 12px; justify-content: flex-end; }
.modal-btn { padding: 10px 20px; border-radius: 8px; font-size: 14px; font-weight: 500; cursor: pointer; border: none; }
.modal-btn.cancel { background: var(--hover-bg); color: var(--text-primary); }
.modal-btn.confirm { background: #ef4444; color: white; }

@media (max-width: 768px) {
    .stats-row { grid-template-columns: repeat(2, 1fr); }
    .leave-table-card { overflow-x: auto; }
}
</style>

<div class="leave-admin-container">
    <div class="leave-admin-header">
        <h1 class="leave-admin-title">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
            </svg>
            Leave Applications
        </h1>
    </div>

    @if(session('success'))
        <div style="background: rgba(16, 185, 129, 0.1); border: 1px solid #10b981; color: #10b981; padding: 12px 16px; border-radius: 8px; margin-bottom: 20px;">
            {{ session('success') }}
        </div>
    @endif

    {{-- Stats --}}
    <div class="stats-row">
        <div class="stat-card">
            <div class="stat-value pending">{{ $stats['new'] ?? 0 }}</div>
            <div class="stat-label">Pending</div>
        </div>
        <div class="stat-card">
            <div class="stat-value approved">{{ $stats['approved'] ?? 0 }}</div>
            <div class="stat-label">Approved</div>
        </div>
        <div class="stat-card">
            <div class="stat-value rejected">{{ $stats['rejected'] ?? 0 }}</div>
            <div class="stat-label">Rejected</div>
        </div>
        <div class="stat-card">
            <div class="stat-value total">{{ $stats['total'] ?? 0 }}</div>
            <div class="stat-label">Total</div>
        </div>
    </div>

    {{-- Filters --}}
    <div class="filter-row">
        <a href="{{ route('admin.attendance.leave.index') }}" class="filter-tab {{ $currentStatus == 'all' ? 'active' : '' }}">All</a>
        <a href="{{ route('admin.attendance.leave.index', ['status' => 'new']) }}" class="filter-tab {{ $currentStatus == 'new' ? 'active' : '' }}">Pending</a>
        <a href="{{ route('admin.attendance.leave.index', ['status' => 'approved']) }}" class="filter-tab {{ $currentStatus == 'approved' ? 'active' : '' }}">Approved</a>
        <a href="{{ route('admin.attendance.leave.index', ['status' => 'rejected']) }}" class="filter-tab {{ $currentStatus == 'rejected' ? 'active' : '' }}">Rejected</a>
    </div>

    {{-- Table --}}
    {{-- <div class="leave-table-card">
        <table class="leave-table">
            <thead>
                <tr>
                    <th>Staff</th>
                    <th>Leave Type</th>
                    <th>Duration</th>
                    <th>Days</th>
                    <th>Status</th>
                    <th>Applied</th>
                    <th>Handover To</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($applications ?? [] as $leave)
                <tr>
                    <td>
                        <span class="staff-name">{{ $leave->staff->first_name ?? '' }} {{ $leave->staff->last_name ?? '' }}</span>
                    </td>
                    <td>
                        <span class="leave-type-badge">
                            <span class="dot" style="background: {{ $leave->leaveType->color ?? '#3b82f6' }};"></span>
                            {{ $leave->leaveType->name ?? 'Leave' }}
                        </span>
                    </td>
                    <td>
                        {{ \Carbon\Carbon::parse($leave->from_date)->format('d M') }}
                        @if(\Carbon\Carbon::parse($leave->from_date)->format('Y-m-d') != \Carbon\Carbon::parse($leave->to_date)->format('Y-m-d'))
                        - {{ \Carbon\Carbon::parse($leave->to_date)->format('d M') }}
                        @endif
                    </td>
                    <td>{{ $leave->number_of_days }}</td>
                    <td>
                        <span class="status-badge status-{{ $leave->status }}">
                            @if($leave->status == 'new') Pending
                            @elseif($leave->status == 'approved') Approved
                            @elseif($leave->status == 'rejected') Rejected
                            @else {{ ucfirst($leave->status) }}
                            @endif
                        </span>
                    </td>
                    <td>{{ $leave->created_at->format('d M Y') }}</td>
                    <td>
                        <div class="action-btns">
                            @if($leave->status == 'new')
                                <form action="{{ route('admin.attendance.leave.approve', $leave->id) }}" method="POST" style="display:inline;">
                                    @csrf
                                    <button type="submit" class="action-btn approve" onclick="return confirm('Approve this leave application?')">✓ Approve</button>
                                </form>
                                <button type="button" class="action-btn reject" onclick="openRejectModal({{ $leave->id }})">✗ Reject</button>
                            @else
                                <a href="{{ route('admin.attendance.leave.edit', $leave->id) }}" class="action-btn view">View</a>
                            @endif
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="8" class="empty-row">
                        <svg width="48" height="48" fill="none" stroke="currentColor" stroke-width="1" viewBox="0 0 24 24" style="margin-bottom:12px;opacity:0.5;">
                            <path d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                        </svg>
                        <div>No leave applications found</div>
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div> 
 --}}



    {{-- Table --}}
<div class="leave-table-card">
    <table class="leave-table">
        <thead>
            <tr>
                <th>Staff</th>
                <th>Leave Type</th>
                <th>Duration</th>
                <th>Days</th>
                <th>Status</th>
                <th>Applied</th>
                <th>Notify</th>
                <th>Handover To</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse($applications ?? [] as $leave)
            <tr>
                <td>
                    <span class="staff-name">{{ $leave->staff->first_name ?? '' }} {{ $leave->staff->last_name ?? '' }}</span>
                </td>
                <td>
                    <span class="leave-type-badge">
                        <span class="dot" style="background: {{ $leave->leaveType->color ?? '#3b82f6' }};"></span>
                        {{ $leave->leaveType->name ?? 'Leave' }}
                    </span>
                </td>
                <td>
                    {{ \Carbon\Carbon::parse($leave->from_date)->format('d M') }}
                    @if(\Carbon\Carbon::parse($leave->from_date)->format('Y-m-d') != \Carbon\Carbon::parse($leave->to_date)->format('Y-m-d'))
                    - {{ \Carbon\Carbon::parse($leave->to_date)->format('d M') }}
                    @endif
                </td>
                <td>{{ $leave->number_of_days }}</td>
                <td>
                    <span class="status-badge status-{{ $leave->status }}">
                        @if($leave->status == 'new') Pending
                        @elseif($leave->status == 'approved') Approved
                        @elseif($leave->status == 'rejected') Rejected
                        @else {{ ucfirst($leave->status) }}
                        @endif
                    </span>
                </td>
                <td>{{ $leave->created_at->format('d M Y') }}</td>
<td>
    @if($leave->followers && $leave->followers->count() > 0)
        <span style="font-size: 13px; color: var(--text-primary);">
            {{ $leave->followers->map(fn($f) => $f->first_name . ' ' . $f->last_name)->implode(', ') }}
        </span>
    @else
        <span style="font-size: 12px; color: var(--text-muted);">—</span>
    @endif
</td>
<td>
    @if($leave->handovers && $leave->handovers->count() > 0)
        <span style="font-size: 13px; color: var(--text-primary);">
            {{ $leave->handovers->map(fn($h) => $h->first_name . ' ' . $h->last_name)->implode(', ') }}
        </span>
    @else
        <span style="font-size: 12px; color: var(--text-muted);">—</span>
    @endif
</td>
                <td>
                    <div class="action-btns">
                        @if($leave->status == 'new')
                            <form action="{{ route('admin.attendance.leave.approve', $leave->id) }}" method="POST" style="display:inline;">
                                @csrf
                                <button type="submit" class="action-btn approve" onclick="return confirm('Approve this leave application?')">✓ Approve</button>
                            </form>
                            <button type="button" class="action-btn reject" onclick="openRejectModal({{ $leave->id }})">✗ Reject</button>
                        @else
                            <a href="{{ route('admin.attendance.leave.edit', $leave->id) }}" class="action-btn view">View</a>
                        @endif
                    </div>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="9" class="empty-row">
                    <svg width="48" height="48" fill="none" stroke="currentColor" stroke-width="1" viewBox="0 0 24 24" style="margin-bottom:12px;opacity:0.5;">
                        <path d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                    </svg>
                    <div>No leave applications found</div>
                </td>
            </tr>
            @endforelse
        </tbody>
    </table>
</div>

    {{-- Pagination --}}
    @if(isset($applications) && $applications->hasPages())
    <div style="margin-top: 20px;">
        {{ $applications->links() }}
    </div>
    @endif
</div>

{{-- Reject Modal --}}
<div class="modal-overlay" id="rejectModal" onclick="if(event.target===this) closeRejectModal()">
    <div class="modal-content">
        <div class="modal-title">Reject Leave Application</div>
        <form id="rejectForm" method="POST">
            @csrf
            <textarea class="modal-input" name="reason" placeholder="Enter reason for rejection (optional)"></textarea>
            <div class="modal-actions">
                <button type="button" class="modal-btn cancel" onclick="closeRejectModal()">Cancel</button>
                <button type="submit" class="modal-btn confirm">Reject</button>
            </div>
        </form>
    </div>
</div>

<script>
function openRejectModal(id) {
    document.getElementById('rejectForm').action = '/admin/attendance/leave/' + id + '/reject';
    document.getElementById('rejectModal').style.display = 'flex';
}

function closeRejectModal() {
    document.getElementById('rejectModal').style.display = 'none';
}

document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') closeRejectModal();
});
</script>
