<div>
    {{-- Stats --}}
    <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 10px; margin-bottom: 16px;">
        <div style="background: var(--card-bg); border: 1px solid var(--border-color); border-radius: 8px; padding: 12px; text-align: center;">
            <div style="font-size: 24px; font-weight: 700; color: var(--primary-color);">{{ number_format($stats['total_hours'] ?? 0, 1) }}</div>
            <div style="font-size: 11px; color: var(--text-muted);">Total Hours</div>
        </div>
        <div style="background: var(--card-bg); border: 1px solid var(--border-color); border-radius: 8px; padding: 12px; text-align: center;">
            <div style="font-size: 24px; font-weight: 700; color: #f59e0b;">{{ $stats['assigned'] ?? 0 }}</div>
            <div style="font-size: 11px; color: var(--text-muted);">Pending</div>
        </div>
        <div style="background: var(--card-bg); border: 1px solid var(--border-color); border-radius: 8px; padding: 12px; text-align: center;">
            <div style="font-size: 24px; font-weight: 700; color: #10b981;">{{ $stats['completed'] ?? 0 }}</div>
            <div style="font-size: 11px; color: var(--text-muted);">Completed</div>
        </div>
    </div>

    {{-- Extra Hours List --}}
    <div style="font-size: 13px; font-weight: 600; color: var(--text-color); margin-bottom: 10px;">
        📋 This Month's Extra Hours
    </div>

    @forelse($extraHours as $item)
        <div style="background: var(--card-bg); border: 1px solid var(--border-color); border-radius: 8px; padding: 12px; margin-bottom: 10px; {{ $item['is_future'] ? 'border-left: 3px solid #f59e0b;' : '' }} {{ $item['is_today'] ? 'border-left: 3px solid #3b82f6;' : '' }}">
            <div style="display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 8px;">
                <div>
                    <div style="font-size: 14px; font-weight: 600; color: var(--text-color);">
                        📅 {{ $item['work_date'] }}
                        @if($item['is_today'])
                            <span style="font-size: 10px; background: #3b82f6; color: white; padding: 2px 6px; border-radius: 4px; margin-left: 4px;">TODAY</span>
                        @elseif($item['is_future'])
                            <span style="font-size: 10px; background: #f59e0b; color: white; padding: 2px 6px; border-radius: 4px; margin-left: 4px;">UPCOMING</span>
                        @endif
                    </div>
                    <div style="font-size: 11px; color: var(--text-muted);">{{ $item['day_name'] }}</div>
                </div>
                <div style="text-align: right;">
                    <span style="display: inline-block; padding: 3px 8px; border-radius: 4px; font-size: 11px; font-weight: 500; background: {{ $item['type_color'] }}20; color: {{ $item['type_color'] }};">
                        {{ $item['type_name'] }}
                    </span>
                </div>
            </div>

            <div style="display: flex; gap: 16px; margin-bottom: 8px;">
                <div>
                    <span style="color: var(--text-muted); font-size: 11px;">Hours:</span>
                    <span style="font-weight: 600; color: var(--text-color);">{{ $item['hours'] }}h</span>
                </div>
                @if($item['time_in'] && $item['time_out'])
                    <div>
                        <span style="color: var(--text-muted); font-size: 11px;">Time:</span>
                        <span style="font-size: 12px; color: var(--text-color);">{{ $item['time_in'] }} - {{ $item['time_out'] }}</span>
                    </div>
                @endif
            </div>

            @if($item['reason'])
                <div style="font-size: 12px; color: var(--text-muted); margin-bottom: 8px; padding: 6px 8px; background: var(--bg-color); border-radius: 4px;">
                    📝 {{ $item['reason'] }}
                </div>
            @endif

            <div style="display: flex; justify-content: space-between; align-items: center;">
                <div>
                    @if($item['status'] === 'assigned')
                        <span style="font-size: 11px; color: #f59e0b;">⏳ Awaiting acknowledgment</span>
                    @elseif($item['status'] === 'acknowledged')
                        <span style="font-size: 11px; color: #3b82f6;">✓ Acknowledged {{ $item['acknowledged_at'] }}</span>
                    @elseif($item['status'] === 'completed')
                        <span style="font-size: 11px; color: #10b981;">✓ Completed</span>
                    @elseif($item['status'] === 'cancelled')
                        <span style="font-size: 11px; color: #ef4444;">✗ Cancelled</span>
                    @endif
                </div>

                @if($item['status'] === 'assigned')
                    <button 
                        wire:click="acknowledge({{ $item['id'] }})"
                        wire:loading.attr="disabled"
                        style="padding: 6px 12px; background: #10b981; color: white; border: none; border-radius: 6px; font-size: 12px; font-weight: 500; cursor: pointer;"
                    >
                        <span wire:loading.remove wire:target="acknowledge({{ $item['id'] }})">✓ Acknowledge</span>
                        <span wire:loading wire:target="acknowledge({{ $item['id'] }})">...</span>
                    </button>
                @endif
            </div>
        </div>
    @empty
        <div style="text-align: center; padding: 30px; color: var(--text-muted);">
            <div style="font-size: 32px; margin-bottom: 8px;">📭</div>
            <div style="font-size: 13px;">No extra hours assigned this month</div>
        </div>
    @endforelse
</div>
