<style>
    .page-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px; flex-wrap: wrap; gap: 16px; }
    .page-header h1 { font-size: 24px; font-weight: 700; color: var(--text-primary); margin: 0; }
    .btn-back { display: inline-flex; align-items: center; gap: 6px; color: var(--text-muted); text-decoration: none; font-size: 14px; margin-bottom: 8px; }
    .btn-back:hover { color: var(--primary); }
    
    .form-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; max-width: 900px; }
    .form-card-header { padding: 16px 20px; border-bottom: 1px solid var(--card-border); background: var(--hover-bg); }
    .form-card-title { font-size: 16px; font-weight: 600; color: var(--text-primary); }
    .form-card-body { padding: 24px; }
    
    .form-section { margin-bottom: 28px; padding-bottom: 24px; border-bottom: 1px solid var(--card-border); }
    .form-section:last-child { margin-bottom: 0; padding-bottom: 0; border-bottom: none; }
    .form-section-title { font-size: 14px; font-weight: 700; color: var(--text-primary); margin-bottom: 16px; display: flex; align-items: center; gap: 10px; }
    .form-section-title .num { background: var(--primary); color: #fff; width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 12px; }
    
    .form-group { margin-bottom: 16px; }
    .form-label { display: block; font-size: 13px; font-weight: 600; color: var(--text-primary); margin-bottom: 6px; }
    .form-hint { font-size: 12px; color: var(--text-muted); margin-top: 4px; }
    .form-input, .form-select { width: 100%; padding: 10px 14px; border: 1px solid var(--input-border); border-radius: 8px; font-size: 14px; background: var(--input-bg); color: var(--text-primary); }
    .form-input:focus, .form-select:focus { outline: none; border-color: var(--primary); box-shadow: 0 0 0 3px rgba(59,130,246,0.1); }
    
    .form-row { display: grid; grid-template-columns: 1fr 1fr; gap: 16px; }
    @media (max-width: 600px) { .form-row { grid-template-columns: 1fr; } }
    
    /* Shift Preview */
    .shift-preview { background: linear-gradient(135deg, #3b82f6, #6366f1); border-radius: 10px; padding: 16px 20px; color: #fff; display: none; }
    .shift-preview.show { display: block; }
    .shift-preview-name { font-size: 18px; font-weight: 700; margin-bottom: 4px; }
    .shift-preview-time { font-size: 14px; opacity: 0.9; }
    .shift-preview-off { font-size: 12px; opacity: 0.8; margin-top: 8px; }
    
    /* Filter Options */
    .filter-card { background: var(--hover-bg); border: 1px solid var(--card-border); border-radius: 10px; padding: 16px; margin-bottom: 16px; }
    .filter-card-title { font-size: 13px; font-weight: 600; color: var(--text-primary); margin-bottom: 12px; }
    
    .checkbox-grid { display: flex; flex-wrap: wrap; gap: 8px; }
    .checkbox-item { display: inline-flex; align-items: center; gap: 8px; padding: 8px 14px; background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 8px; cursor: pointer; font-size: 13px; transition: all 0.15s; }
    .checkbox-item:hover { border-color: var(--primary); }
    .checkbox-item input { accent-color: var(--primary); width: 16px; height: 16px; }
    .checkbox-item.checked { background: rgba(59,130,246,0.1); border-color: var(--primary); }
    
    /* Staff Preview */
    .staff-preview { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 10px; padding: 16px; margin-top: 16px; }
    .staff-preview-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 12px; }
    .staff-preview-title { font-size: 13px; font-weight: 600; color: var(--text-primary); }
    .staff-preview-count { font-size: 24px; font-weight: 800; color: var(--primary); }
    .staff-preview-list { max-height: 200px; overflow-y: auto; font-size: 12px; color: var(--text-muted); }
    .staff-preview-item { padding: 6px 0; border-bottom: 1px solid var(--card-border); }
    .staff-preview-item:last-child { border-bottom: none; }
    
    /* Specific Staff Selection */
    .staff-select-area { display: none; }
    .staff-select-area.show { display: block; }
    .staff-search { margin-bottom: 12px; }
    .staff-search input { width: 100%; padding: 10px 14px; border: 1px solid var(--input-border); border-radius: 8px; font-size: 14px; }
    .staff-list { max-height: 300px; overflow-y: auto; border: 1px solid var(--card-border); border-radius: 8px; }
    .staff-list-header { padding: 10px 14px; background: var(--hover-bg); border-bottom: 1px solid var(--card-border); display: flex; justify-content: space-between; align-items: center; position: sticky; top: 0; z-index: 5; }
    .staff-list-header label { font-size: 13px; font-weight: 600; cursor: pointer; display: flex; align-items: center; gap: 8px; }
    .staff-count-badge { font-size: 12px; color: #fff; background: var(--primary); padding: 2px 10px; border-radius: 10px; }
    .staff-item { display: flex; align-items: center; gap: 10px; padding: 10px 14px; border-bottom: 1px solid var(--card-border); cursor: pointer; }
    .staff-item:last-child { border-bottom: none; }
    .staff-item:hover { background: var(--hover-bg); }
    .staff-item input { accent-color: var(--primary); width: 16px; height: 16px; }
    .staff-item-name { font-size: 13px; font-weight: 500; color: var(--text-primary); }
    .staff-item-meta { font-size: 11px; color: var(--text-muted); }
    
    .form-actions { display: flex; gap: 12px; padding-top: 20px; border-top: 1px solid var(--card-border); margin-top: 24px; }
    .btn { padding: 10px 24px; border-radius: 8px; font-weight: 600; font-size: 14px; cursor: pointer; border: none; display: inline-flex; align-items: center; gap: 8px; text-decoration: none; transition: all 0.2s; }
    .btn-primary { background: var(--primary); color: #fff; }
    .btn-primary:hover { background: var(--primary-hover); transform: translateY(-1px); }
    .btn-secondary { background: var(--card-bg); color: var(--text-primary); border: 1px solid var(--card-border); }
    
    .toggle-switch { display: flex; align-items: center; gap: 10px; padding: 12px 16px; background: var(--hover-bg); border-radius: 8px; cursor: pointer; }
    .toggle-switch input { width: 18px; height: 18px; accent-color: var(--primary); }
    .toggle-switch-label { font-size: 14px; font-weight: 500; color: var(--text-primary); }
</style>

<div style="padding: 20px;">
    <div class="page-header">
        <div>
            <a href="{{ route('admin.attendance.shifts.index') }}" class="btn-back">
                <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M19 12H5m7-7l-7 7 7 7"/></svg>
                Back to Shifts
            </a>
            <h1>{{ $pageTitle ?? 'Assign Shift' }}</h1>
        </div>
    </div>

    <div class="form-card">
        <div class="form-card-header">
            <div class="form-card-title">Create Shift Assignment</div>
        </div>
        <div class="form-card-body">
            <form action="{{ route('admin.attendance.shifts.store') }}" method="POST" id="shiftForm">
                @csrf
                
                {{-- Section 1: Shift Type --}}
                <div class="form-section">
                    <div class="form-section-title">
                        <span class="num">1</span> Select Shift Type
                    </div>
                    
                    <div class="form-group">
                        <select name="shift_type_id" id="shiftTypeSelect" class="form-select" required onchange="updateShiftPreview()">
                            <option value="">-- Choose a shift --</option>
                            @foreach($shiftTypes ?? [] as $st)
                            <option value="{{ $st->id }}" 
                                    data-name="{{ $st->name }}"
                                    data-start="{{ $st->start_time }}" 
                                    data-end="{{ $st->end_time }}"
                                    data-days-off="{{ json_encode($st->days_off ?? []) }}"
                                    data-color="{{ $st->color ?? '#3b82f6' }}">
                                {{ $st->name }} ({{ date('h:i A', strtotime($st->start_time)) }} - {{ date('h:i A', strtotime($st->end_time)) }})
                            </option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="shift-preview" id="shiftPreview">
                        <div class="shift-preview-name" id="previewName">General Shift</div>
                        <div class="shift-preview-time" id="previewTime">09:00 AM - 06:00 PM</div>
                        <div class="shift-preview-off" id="previewOff">Days Off: Saturday, Sunday</div>
                    </div>
                </div>

                {{-- Section 2: Date Range --}}
                <div class="form-section">
                    <div class="form-section-title">
                        <span class="num">2</span> Date Range
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label">From Date *</label>
                            <input type="date" name="from_date" class="form-input" value="{{ old('from_date', date('Y-m-d')) }}" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label">To Date</label>
                            <input type="date" name="to_date" class="form-input" value="{{ old('to_date') }}">
                            <div class="form-hint">Leave empty for permanent/ongoing assignment</div>
                        </div>
                    </div>
                </div>

                {{-- Section 3: Who to Assign --}}
                <div class="form-section">
                    <div class="form-section-title">
                        <span class="num">3</span> Who to Assign
                    </div>
                    
                    {{-- Department Filter --}}
                    <div class="filter-card">
                        <div class="filter-card-title">Filter by Department (optional)</div>
                        <div class="checkbox-grid" id="deptCheckboxes">
                            @foreach($departments ?? [] as $dept)
                            <label class="checkbox-item">
                                <input type="checkbox" name="departments[]" value="{{ $dept }}" onchange="updateStaffPreview()">
                                <span>{{ $dept }}</span>
                            </label>
                            @endforeach
                            @if(empty($departments))
                            <span style="color: var(--text-muted); font-size: 13px;">No departments found</span>
                            @endif
                        </div>
                        <div class="form-hint" style="margin-top: 8px;">Leave unchecked to include all departments</div>
                    </div>
                    
                    {{-- Role Filter --}}
                    <div class="filter-card">
                        <div class="filter-card-title">Filter by Role (optional)</div>
                        <div class="checkbox-grid" id="roleCheckboxes">
                            @foreach($roles ?? [] as $role)
                            <label class="checkbox-item">
                                <input type="checkbox" name="roles[]" value="{{ $role }}" onchange="updateStaffPreview()">
                                <span>{{ ucfirst($role) }}</span>
                            </label>
                            @endforeach
                        </div>
                        <div class="form-hint" style="margin-top: 8px;">Leave unchecked to include all roles</div>
                    </div>
                    
                    {{-- Specific Staff Toggle --}}
                    <label class="toggle-switch">
                        <input type="checkbox" id="specificStaffToggle" onchange="toggleSpecificStaff()">
                        <span class="toggle-switch-label">Select specific staff only (instead of all matching)</span>
                    </label>
                    
                    {{-- Specific Staff Selection --}}
                    <div class="staff-select-area" id="specificStaffArea">
                        <div class="staff-search">
                            <input type="text" id="staffSearch" placeholder="Search staff by name..." oninput="filterStaffList()">
                        </div>
                        <div class="staff-list">
                            <div class="staff-list-header">
                                <label>
                                    <input type="checkbox" id="selectAllStaff" onchange="toggleSelectAll()">
                                    Select All Visible
                                </label>
                                <span class="staff-count-badge" id="selectedCount">0 selected</span>
                            </div>
                            <div id="staffListBody">
                                @foreach($staffList ?? [] as $staff)
                                <label class="staff-item" 
                                       data-name="{{ strtolower($staff->first_name . ' ' . $staff->last_name) }}"
                                       data-dept="{{ $staff->department ?? '' }}"
                                       data-role="{{ $staff->admin?->roles?->first()?->name ?? '' }}">
                                    <input type="checkbox" name="staff_ids[]" value="{{ $staff->id }}" onchange="updateSelectedCount()">
                                    <div>
                                        <div class="staff-item-name">{{ $staff->first_name }} {{ $staff->last_name }}</div>
                                        <div class="staff-item-meta">{{ $staff->department ?? '-' }} • {{ $staff->admin?->roles?->first()?->name ?? '-' }}</div>
                                    </div>
                                </label>
                                @endforeach
                            </div>
                        </div>
                    </div>
                    
                    {{-- Staff Preview --}}
                    <div class="staff-preview" id="staffPreview">
                        <div class="staff-preview-header">
                            <span class="staff-preview-title">Staff to be assigned:</span>
                            <span class="staff-preview-count" id="previewCount">{{ count($staffList ?? []) }}</span>
                        </div>
                        <div class="staff-preview-list" id="previewList">
                            @foreach($staffList ?? [] as $staff)
                            <div class="staff-preview-item">{{ $staff->first_name }} {{ $staff->last_name }} ({{ $staff->department ?? '-' }})</div>
                            @endforeach
                        </div>
                    </div>
                </div>

                {{-- Hidden field for assignment type --}}
                <input type="hidden" name="assign_type" id="assignType" value="filter">

                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M5 13l4 4L19 7"/></svg>
                        Assign Shift
                    </button>
                    <a href="{{ route('admin.attendance.shifts.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Store all staff data for filtering
var allStaff = [
    @foreach($staffList ?? [] as $staff)
    {
        id: {{ $staff->id }},
        name: "{{ $staff->first_name }} {{ $staff->last_name }}",
        dept: "{{ $staff->department ?? '' }}",
        role: "{{ $staff->admin?->roles?->first()?->name ?? '' }}"
    },
    @endforeach
];

function updateShiftPreview() {
    var select = document.getElementById('shiftTypeSelect');
    var preview = document.getElementById('shiftPreview');
    var option = select.options[select.selectedIndex];
    
    if (select.value) {
        document.getElementById('previewName').textContent = option.dataset.name;
        document.getElementById('previewTime').textContent = formatTime(option.dataset.start) + ' - ' + formatTime(option.dataset.end);
        var daysOff = JSON.parse(option.dataset.daysOff || '[]');
        document.getElementById('previewOff').textContent = 'Days Off: ' + (daysOff.length > 0 ? daysOff.join(', ') : 'None');
        preview.classList.add('show');
    } else {
        preview.classList.remove('show');
    }
}

function formatTime(time) {
    if (!time) return '-';
    var parts = time.split(':');
    var hours = parseInt(parts[0]);
    var mins = parts[1];
    var ampm = hours >= 12 ? 'PM' : 'AM';
    hours = hours % 12 || 12;
    return hours + ':' + mins + ' ' + ampm;
}

function updateStaffPreview() {
    var selectedDepts = getCheckedValues('departments[]');
    var selectedRoles = getCheckedValues('roles[]');
    var isSpecific = document.getElementById('specificStaffToggle').checked;
    
    // Filter staff based on selections
    var filtered = allStaff.filter(function(staff) {
        var deptMatch = selectedDepts.length === 0 || selectedDepts.includes(staff.dept);
        var roleMatch = selectedRoles.length === 0 || selectedRoles.includes(staff.role);
        return deptMatch && roleMatch;
    });
    
    // Update preview count and list
    document.getElementById('previewCount').textContent = filtered.length;
    
    var listHtml = '';
    filtered.slice(0, 20).forEach(function(staff) {
        listHtml += '<div class="staff-preview-item">' + staff.name + ' (' + (staff.dept || '-') + ')</div>';
    });
    if (filtered.length > 20) {
        listHtml += '<div class="staff-preview-item" style="font-style:italic;">... and ' + (filtered.length - 20) + ' more</div>';
    }
    document.getElementById('previewList').innerHTML = listHtml;
    
    // Update checkbox styling
    document.querySelectorAll('.checkbox-item').forEach(function(item) {
        var cb = item.querySelector('input[type="checkbox"]');
        item.classList.toggle('checked', cb.checked);
    });
    
    // If specific staff mode, filter the staff list
    if (isSpecific) {
        filterStaffByDeptRole(selectedDepts, selectedRoles);
    }
}

function getCheckedValues(name) {
    var values = [];
    document.querySelectorAll('input[name="' + name + '"]:checked').forEach(function(cb) {
        values.push(cb.value);
    });
    return values;
}

function toggleSpecificStaff() {
    var isSpecific = document.getElementById('specificStaffToggle').checked;
    var area = document.getElementById('specificStaffArea');
    var preview = document.getElementById('staffPreview');
    
    if (isSpecific) {
        area.classList.add('show');
        preview.style.display = 'none';
        document.getElementById('assignType').value = 'specific';
        
        // Filter staff list based on current dept/role selection
        var selectedDepts = getCheckedValues('departments[]');
        var selectedRoles = getCheckedValues('roles[]');
        filterStaffByDeptRole(selectedDepts, selectedRoles);
    } else {
        area.classList.remove('show');
        preview.style.display = 'block';
        document.getElementById('assignType').value = 'filter';
        
        // Uncheck all specific staff
        document.querySelectorAll('input[name="staff_ids[]"]').forEach(function(cb) {
            cb.checked = false;
        });
        updateSelectedCount();
    }
}

function filterStaffByDeptRole(selectedDepts, selectedRoles) {
    document.querySelectorAll('#staffListBody .staff-item').forEach(function(item) {
        var dept = item.dataset.dept;
        var role = item.dataset.role;
        
        var deptMatch = selectedDepts.length === 0 || selectedDepts.includes(dept);
        var roleMatch = selectedRoles.length === 0 || selectedRoles.includes(role);
        
        item.style.display = (deptMatch && roleMatch) ? 'flex' : 'none';
    });
}

function filterStaffList() {
    var search = document.getElementById('staffSearch').value.toLowerCase();
    var selectedDepts = getCheckedValues('departments[]');
    var selectedRoles = getCheckedValues('roles[]');
    
    document.querySelectorAll('#staffListBody .staff-item').forEach(function(item) {
        var name = item.dataset.name;
        var dept = item.dataset.dept;
        var role = item.dataset.role;
        
        var nameMatch = name.includes(search);
        var deptMatch = selectedDepts.length === 0 || selectedDepts.includes(dept);
        var roleMatch = selectedRoles.length === 0 || selectedRoles.includes(role);
        
        item.style.display = (nameMatch && deptMatch && roleMatch) ? 'flex' : 'none';
    });
}

function toggleSelectAll() {
    var selectAll = document.getElementById('selectAllStaff').checked;
    document.querySelectorAll('#staffListBody .staff-item:not([style*="display: none"]) input[type="checkbox"]').forEach(function(cb) {
        cb.checked = selectAll;
    });
    updateSelectedCount();
}

function updateSelectedCount() {
    var count = document.querySelectorAll('input[name="staff_ids[]"]:checked').length;
    document.getElementById('selectedCount').textContent = count + ' selected';
}

// Initialize
document.addEventListener('DOMContentLoaded', function() {
    updateStaffPreview();
});
</script>
