<style>
    .page-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px; flex-wrap: wrap; gap: 16px; }
    .page-header h1 { font-size: 24px; font-weight: 700; color: var(--text-primary); margin: 0; display: flex; align-items: center; gap: 10px; }
    .page-header h1 svg { width: 28px; height: 28px; color: var(--primary); }
    .btn-back { display: inline-flex; align-items: center; gap: 6px; color: var(--text-muted); text-decoration: none; font-size: 14px; }
    .btn-back:hover { color: var(--primary); }
    
    .form-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; max-width: 700px; }
    .form-card-header { padding: 16px 20px; border-bottom: 1px solid var(--card-border); background: var(--hover-bg); }
    .form-card-title { font-size: 16px; font-weight: 600; color: var(--text-primary); }
    .form-card-body { padding: 24px; }
    
    .form-row { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 16px; }
    .form-group { margin-bottom: 20px; }
    .form-label { display: block; font-size: 14px; font-weight: 500; color: var(--text-primary); margin-bottom: 8px; }
    .form-input, .form-select { width: 100%; padding: 10px 14px; border: 1px solid var(--input-border); border-radius: 8px; font-size: 14px; background: var(--input-bg); color: var(--text-primary); transition: border-color 0.2s; }
    .form-input:focus, .form-select:focus { outline: none; border-color: var(--primary); box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1); }
    
    .days-wrap { display: flex; flex-wrap: wrap; gap: 8px; margin-top: 8px; }
    .day-btn { padding: 8px 14px; background: var(--card-bg); border: 2px solid var(--card-border); border-radius: 8px; cursor: pointer; font-size: 13px; font-weight: 500; color: var(--text-primary); transition: all 0.2s; }
    .day-btn:hover { border-color: var(--primary); }
    .day-btn.active { background: var(--primary); border-color: var(--primary); color: #fff; }
    .day-btn input { display: none; }
    
    .form-switch { display: flex; align-items: center; gap: 12px; }
    .switch { position: relative; width: 48px; height: 26px; }
    .switch input { opacity: 0; width: 0; height: 0; }
    .slider { position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background: var(--input-border); border-radius: 26px; transition: 0.3s; }
    .slider:before { position: absolute; content: ""; height: 20px; width: 20px; left: 3px; bottom: 3px; background: white; border-radius: 50%; transition: 0.3s; box-shadow: 0 2px 4px rgba(0,0,0,0.2); }
    input:checked + .slider { background: var(--primary); }
    input:checked + .slider:before { transform: translateX(22px); }
    
    .form-actions { display: flex; gap: 12px; padding-top: 20px; border-top: 1px solid var(--card-border); margin-top: 24px; }
    .btn { padding: 10px 24px; border-radius: 8px; font-weight: 600; font-size: 14px; cursor: pointer; transition: all 0.2s; border: none; display: inline-flex; align-items: center; gap: 8px; text-decoration: none; }
    .btn-primary { background: var(--primary); color: #fff; }
    .btn-primary:hover { background: var(--primary-hover); }
    .btn-secondary { background: var(--card-bg); color: var(--text-primary); border: 1px solid var(--card-border); }
    .btn-secondary:hover { background: var(--hover-bg); }
    
    @media (max-width: 600px) { .form-row { grid-template-columns: 1fr; } }
</style>

<div style="padding: 20px;">
    <div class="page-header">
        <div>
            <a href="{{ route('admin.attendance.shifts.index') }}" class="btn-back">
                <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M19 12H5m7-7l-7 7 7 7"/></svg>
                Back to Shifts
            </a>
            <h1>
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                </svg>
                {{ $pageTitle ?? 'Edit Shift' }}
            </h1>
        </div>
    </div>

    <div class="form-card">
        <div class="form-card-header">
            <div class="form-card-title">Shift Details</div>
        </div>
        <div class="form-card-body">
            <form action="{{ route('admin.attendance.shifts.update', $shift->id) }}" method="POST">
                @csrf
                @method('PUT')
                
                <div class="form-row">
                    <div class="form-group">
                        <label class="form-label">Department</label>
                        <select name="department" class="form-select">
                            <option value="">- All Departments -</option>
                            @foreach($departments as $dept)
                                <option value="{{ $dept }}" {{ $shift->department == $dept ? 'selected' : '' }}>{{ $dept }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Role</label>
                        <select name="role_name" class="form-select">
                            <option value="">- All Roles -</option>
                            @foreach($roles as $role)
                                <option value="{{ $role->name }}" {{ $shift->role_name == $role->name ? 'selected' : '' }}>{{ $role->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Staff</label>
                    <select name="staff_id" class="form-select">
                        <option value="">- All Staff -</option>
                        @foreach($staffList as $staff)
                            <option value="{{ $staff->id }}" {{ $shift->staff_id == $staff->id ? 'selected' : '' }}>
                                {{ $staff->first_name }} {{ $staff->last_name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Shift Type</label>
                    <select name="shift_type_id" class="form-select" required>
                        @foreach($shiftTypes as $type)
                            <option value="{{ $type->id }}" {{ $shift->shift_type_id == $type->id ? 'selected' : '' }}>
                                {{ $type->name }} ({{ $type->work_timing }})
                            </option>
                        @endforeach
                    </select>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label class="form-label">From Date</label>
                        <input type="date" name="from_date" class="form-input" value="{{ $shift->from_date->format('Y-m-d') }}" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">To Date</label>
                        <input type="date" name="to_date" class="form-input" value="{{ $shift->to_date ? $shift->to_date->format('Y-m-d') : '' }}">
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Repeat Type</label>
                    <select name="repeat_type" id="repeatType" class="form-select" onchange="toggleDays()">
                        <option value="weekly" {{ $shift->repeat_type == 'weekly' ? 'selected' : '' }}>Weekly</option>
                        <option value="specific" {{ $shift->repeat_type == 'specific' ? 'selected' : '' }}>Specific Period</option>
                    </select>
                </div>
                
                <div class="form-group" id="daysSection" style="{{ $shift->repeat_type == 'specific' ? 'display:none;' : '' }}">
                    <label class="form-label">Working Days</label>
                    <div class="days-wrap">
                        @php $selectedDays = $shift->repeat_days ?? []; @endphp
                        @foreach($weekdays as $day)
                            <label class="day-btn {{ in_array($day, $selectedDays) ? 'active' : '' }}" onclick="this.classList.toggle('active')">
                                <input type="checkbox" name="repeat_days[]" value="{{ $day }}" {{ in_array($day, $selectedDays) ? 'checked' : '' }}>
                                {{ $day }}
                            </label>
                        @endforeach
                    </div>
                </div>
                
                <div class="form-group">
                    <div class="form-switch">
                        <label class="switch">
                            <input type="checkbox" name="status" value="1" {{ $shift->status ? 'checked' : '' }}>
                            <span class="slider"></span>
                        </label>
                        <span>Active</span>
                    </div>
                </div>
                
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M5 13l4 4L19 7"/></svg>
                        Update Shift
                    </button>
                    <a href="{{ route('admin.attendance.shifts.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function toggleDays() {
    const repeatType = document.getElementById('repeatType').value;
    document.getElementById('daysSection').style.display = repeatType === 'weekly' ? '' : 'none';
}
</script>
