<?php

return [
    'name' => 'Expense',
    'per_page' => 15,
    
    // Expense number format: EXP{YYYY}{MM}{0000}
    'number_format' => 'EXP{YYYY}{MM}{0000}',
    'auto_generate_number' => true,
    
    // Workflow settings
    'require_approval' => true,
    'allow_self_approval' => false,
    'max_amount_without_approval' => 5000.00,
    'require_receipt' => true,
    'require_manager_selection' => true,
    
    // Payment settings
    'payment_reference_format' => 'PAY{YYYY}{MM}{0000}',
    'allow_partial_payments' => true,
    
    // Email notifications
    'email_notifications' => true,
    'notify_on_submission' => true,
    'notify_on_approval' => true,
    'notify_on_rejection' => true,
    'notify_on_payment' => true,
    
    // Travel expense settings
    'default_travel_rate_per_km' => 10.00,
    'lock_travel_rate_for_users' => true,
    
    // Currency
    'default_currency' => 'INR',
    'currency_symbol' => '₹',
    
    // Status options
    'statuses' => [
        'draft' => 'Draft',
        'submitted' => 'Submitted',
        'approved' => 'Approved',
        'rejected' => 'Rejected',
        'paid' => 'Paid',
    ],
    
    'payment_statuses' => [
        'unpaid' => 'Unpaid',
        'partially_paid' => 'Partially Paid',
        'paid' => 'Paid',
    ],
    
    'paid_by_options' => [
        'employee' => 'Employee',
        'company' => 'Company',
    ],
    
    // Attachment types
    'attachment_types' => [
        'receipt' => 'Receipt',
        'bill' => 'Bill',
        'start_image' => 'Start Image',
        'destination_image' => 'Destination Image',
        'returned_image' => 'Returned Image',
        'fuel_bill' => 'Fuel Bill',
        'other' => 'Other',
    ],
    
    // Allowed file types for attachments
    'allowed_file_types' => ['jpg', 'jpeg', 'png', 'gif', 'pdf', 'doc', 'docx'],
    'max_file_size' => 5120, // KB
];
