<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('expense_categories')) {
            return;
        }

        Schema::create('expense_categories', function (Blueprint $table) {
            $table->id();
            $table->string('name', 191);
            $table->text('description')->nullable();
            $table->decimal('unit_price', 10, 2)->nullable()->comment('Default unit price for travel categories');
            $table->boolean('is_travel_category')->default(false);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            
            $table->index('name');
            $table->index('is_active');
        });

        // Seed default categories
        DB::table('expense_categories')->insert([
            ['name' => 'Travel to Client Office', 'description' => 'Travel expenses for client visits', 'is_travel_category' => true, 'unit_price' => 10.00, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Local Travel', 'description' => 'Local travel expenses', 'is_travel_category' => true, 'unit_price' => 10.00, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Office Supplies', 'description' => 'Office supplies and stationery', 'is_travel_category' => false, 'unit_price' => null, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Training & Development', 'description' => 'Professional development expenses', 'is_travel_category' => false, 'unit_price' => null, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Meals & Entertainment', 'description' => 'Business meals and entertainment', 'is_travel_category' => false, 'unit_price' => null, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Communication', 'description' => 'Phone, internet, and communication expenses', 'is_travel_category' => false, 'unit_price' => null, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Equipment', 'description' => 'Equipment and hardware expenses', 'is_travel_category' => false, 'unit_price' => null, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Software & Subscriptions', 'description' => 'Software licenses and subscriptions', 'is_travel_category' => false, 'unit_price' => null, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Miscellaneous', 'description' => 'Other miscellaneous expenses', 'is_travel_category' => false, 'unit_price' => null, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
        ]);
    }

    public function down(): void
    {
        Schema::dropIfExists('expense_categories');
    }
};
