<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('expense_units')) {
            return;
        }

        Schema::create('expense_units', function (Blueprint $table) {
            $table->id();
            $table->string('name', 100);
            $table->string('symbol', 10);
            $table->enum('type', ['distance', 'weight', 'volume', 'quantity', 'time'])->default('quantity');
            $table->text('description')->nullable();
            $table->decimal('conversion_factor', 10, 4)->default(1.0000)->comment('Conversion to base unit');
            $table->boolean('is_active')->default(true);
            $table->unsignedBigInteger('created_by')->nullable();
            $table->timestamps();
            
            $table->unique('symbol');
            $table->index('type');
            $table->index('is_active');
        });

        // Seed default units
        DB::table('expense_units')->insert([
            ['name' => 'Kilometers', 'symbol' => 'km', 'type' => 'distance', 'description' => 'Distance in kilometers', 'conversion_factor' => 1.0000, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Miles', 'symbol' => 'mi', 'type' => 'distance', 'description' => 'Distance in miles', 'conversion_factor' => 1.6093, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Hours', 'symbol' => 'hr', 'type' => 'time', 'description' => 'Time in hours', 'conversion_factor' => 1.0000, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Days', 'symbol' => 'day', 'type' => 'time', 'description' => 'Time in days', 'conversion_factor' => 24.0000, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Pieces', 'symbol' => 'pcs', 'type' => 'quantity', 'description' => 'Number of pieces', 'conversion_factor' => 1.0000, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Items', 'symbol' => 'item', 'type' => 'quantity', 'description' => 'Individual items', 'conversion_factor' => 1.0000, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Liters', 'symbol' => 'L', 'type' => 'volume', 'description' => 'Volume in liters', 'conversion_factor' => 1.0000, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
        ]);
    }

    public function down(): void
    {
        Schema::dropIfExists('expense_units');
    }
};
