<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('expense_attachments')) {
            return;
        }

        Schema::create('expense_attachments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('expense_id');
            
            // File info
            $table->string('original_name', 255);
            $table->string('file_path', 500)->comment('Storage path');
            $table->string('file_type', 100);
            $table->unsignedInteger('file_size')->comment('Size in bytes');
            
            // Attachment type
            $table->enum('attachment_type', [
                'receipt', 'bill', 'start_image', 'destination_image', 
                'returned_image', 'fuel_bill', 'other'
            ])->default('receipt');
            $table->string('attachment_label', 255)->nullable();
            
            // Validation
            $table->boolean('is_required')->default(false);
            $table->enum('validation_status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->unsignedBigInteger('validated_by')->nullable();
            $table->timestamp('validated_at')->nullable();
            
            // Created by
            $table->unsignedBigInteger('created_by');
            $table->timestamps();
            
            // Indexes
            $table->index('expense_id');
            $table->index('attachment_type');
            
            // Foreign keys
            $table->foreign('expense_id')->references('id')->on('expenses')->onDelete('cascade');
            $table->foreign('validated_by')->references('id')->on('admins')->onDelete('set null');
            $table->foreign('created_by')->references('id')->on('admins')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('expense_attachments');
    }
};
