<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('expense_payments')) {
            return;
        }

        Schema::create('expense_payments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('expense_id');
            
            // Payment details
            $table->string('payment_reference', 50)->nullable()->comment('Auto-generated reference');
            $table->decimal('amount', 15, 2);
            $table->date('payment_date');
            $table->unsignedBigInteger('payment_method_id')->nullable();
            $table->string('transaction_id', 255)->nullable();
            $table->text('note')->nullable();
            
            // Bank details (for bank transfers)
            $table->text('bank_details')->nullable();
            
            // Receipt
            $table->string('receipt_file', 500)->nullable();
            
            // Status
            $table->enum('status', ['pending', 'completed', 'failed', 'cancelled'])->default('completed');
            
            // Processed by
            $table->unsignedBigInteger('created_by');
            $table->timestamps();
            
            // Indexes
            $table->index('expense_id');
            $table->index('payment_date');
            $table->index('status');
            
            // Foreign keys
            $table->foreign('expense_id')->references('id')->on('expenses')->onDelete('cascade');
            $table->foreign('created_by')->references('id')->on('admins')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('expense_payments');
    }
};
