<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('expense_activity_log')) {
            return;
        }

        Schema::create('expense_activity_log', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('expense_id');
            
            // Activity info
            $table->string('action', 50)->comment('created, updated, submitted, approved, rejected, paid, etc.');
            $table->text('description')->nullable();
            $table->json('old_values')->nullable();
            $table->json('new_values')->nullable();
            
            // Related manager if applicable
            $table->unsignedBigInteger('manager_id')->nullable();
            
            // Tracking info
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            
            // Created by
            $table->unsignedBigInteger('created_by');
            $table->timestamp('created_at')->useCurrent();
            
            // Indexes
            $table->index('expense_id');
            $table->index('action');
            $table->index('created_at');
            
            // Foreign keys
            $table->foreign('expense_id')->references('id')->on('expenses')->onDelete('cascade');
            $table->foreign('created_by')->references('id')->on('admins')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('expense_activity_log');
    }
};
