<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('expense_manager_assignments')) {
            return;
        }

        Schema::create('expense_manager_assignments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('employee_id');
            $table->unsignedBigInteger('manager_id');
            $table->string('department', 100)->nullable();
            $table->boolean('is_primary')->default(true)->comment('Primary reporting manager');
            $table->boolean('is_active')->default(true);
            $table->text('notes')->nullable();
            $table->unsignedBigInteger('assigned_by');
            $table->timestamps();
            
            // Indexes
            $table->index('employee_id');
            $table->index('manager_id');
            $table->index('is_active');
            
            // Foreign keys
            $table->foreign('employee_id')->references('id')->on('admins')->onDelete('cascade');
            $table->foreign('manager_id')->references('id')->on('admins')->onDelete('cascade');
            $table->foreign('assigned_by')->references('id')->on('admins')->onDelete('cascade');
            
            // Unique constraint - one primary manager per employee
            $table->unique(['employee_id', 'is_primary'], 'unique_primary_manager');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('expense_manager_assignments');
    }
};
