<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        // Only create if table doesn't exist (safe for projects that already have it)
        if (Schema::hasTable('payment_methods')) {
            return;
        }

        Schema::create('payment_methods', function (Blueprint $table) { 
            $table->id();
            $table->string('name', 100);
            $table->string('slug', 50)->nullable();
            $table->string('description', 255)->nullable();
            $table->string('icon', 50)->nullable();
            $table->tinyInteger('is_active')->default(1);
            $table->tinyInteger('is_default')->default(0);
            $table->tinyInteger('show_on_invoice')->default(1);
            $table->integer('sort_order')->default(0);
            $table->timestamps();
            
            $table->index('is_active');
            $table->index('slug');
        });

        // Seed default payment methods
        DB::table('payment_methods')->insert([
            ['name' => 'Cash', 'slug' => 'cash', 'description' => 'Cash payment', 'is_active' => 1, 'is_default' => 1, 'show_on_invoice' => 1, 'sort_order' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Bank Transfer', 'slug' => 'bank-transfer', 'description' => 'Bank account transfer', 'is_active' => 1, 'is_default' => 0, 'show_on_invoice' => 1, 'sort_order' => 2, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'UPI', 'slug' => 'upi', 'description' => 'UPI payment', 'is_active' => 1, 'is_default' => 0, 'show_on_invoice' => 1, 'sort_order' => 3, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Credit Card', 'slug' => 'credit-card', 'description' => 'Credit card payment', 'is_active' => 1, 'is_default' => 0, 'show_on_invoice' => 1, 'sort_order' => 4, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Debit Card', 'slug' => 'debit-card', 'description' => 'Debit card payment', 'is_active' => 1, 'is_default' => 0, 'show_on_invoice' => 1, 'sort_order' => 5, 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Cheque', 'slug' => 'cheque', 'description' => 'Cheque payment', 'is_active' => 1, 'is_default' => 0, 'show_on_invoice' => 1, 'sort_order' => 6, 'created_at' => now(), 'updated_at' => now()],
        ]);
    }

    public function down(): void
    {
        // Don't drop - might be used by other modules
        // Schema::dropIfExists('payment_methods');
    }
};
