<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Add project_id to expenses table
        if (Schema::hasTable('expenses') && !Schema::hasColumn('expenses', 'project_id')) {
            Schema::table('expenses', function (Blueprint $table) {
                $table->unsignedBigInteger('project_id')->nullable()->after('category_id');
                $table->index('project_id');
                
                // Add foreign key if projects table exists
                if (Schema::hasTable('projects')) {
                    $table->foreign('project_id')->references('id')->on('projects')->onDelete('set null');
                }
            });
        }

        // Add is_project_category to expense_categories table
        if (Schema::hasTable('expense_categories') && !Schema::hasColumn('expense_categories', 'is_project_category')) {
            Schema::table('expense_categories', function (Blueprint $table) {
                $table->boolean('is_project_category')->default(false)->after('is_travel_category');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('expenses') && Schema::hasColumn('expenses', 'project_id')) {
            Schema::table('expenses', function (Blueprint $table) {
                $table->dropForeign(['project_id']);
                $table->dropColumn('project_id');
            });
        }

        if (Schema::hasTable('expense_categories') && Schema::hasColumn('expense_categories', 'is_project_category')) {
            Schema::table('expense_categories', function (Blueprint $table) {
                $table->dropColumn('is_project_category');
            });
        }
    }
};
