<?php

namespace Modules\Expense\Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use Spatie\Permission\PermissionRegistrar;

class ExpensePermissionSeeder extends Seeder
{
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[PermissionRegistrar::class]->forgetCachedPermissions();

        // Create permissions
        $permissions = [
            'expense.view' => 'View expenses',
            'expense.create' => 'Create expenses',
            'expense.edit' => 'Edit expenses',
            'expense.delete' => 'Delete expenses',
            'expense.approve' => 'Approve/Reject expenses',
            'expense.pay' => 'Process expense payments',
        ];

        foreach ($permissions as $name => $description) {
            Permission::firstOrCreate(
                ['name' => $name, 'guard_name' => 'admin'],
                ['description' => $description]
            );
        }

        // Assign to super-admin role
        $superAdmin = Role::where('name', 'super-admin')->where('guard_name', 'admin')->first();
        if ($superAdmin) {
            $superAdmin->givePermissionTo(array_keys($permissions));
        }

        // Create expense-manager role if doesn't exist
        $managerRole = Role::firstOrCreate(
            ['name' => 'expense-manager', 'guard_name' => 'admin'],
            ['description' => 'Expense Manager - Can approve and pay expenses']
        );
        $managerRole->givePermissionTo(['expense.view', 'expense.create', 'expense.edit', 'expense.approve', 'expense.pay']);

        // Create expense-user role if doesn't exist
        $userRole = Role::firstOrCreate(
            ['name' => 'expense-user', 'guard_name' => 'admin'],
            ['description' => 'Expense User - Can create and view own expenses']
        );
        $userRole->givePermissionTo(['expense.view', 'expense.create', 'expense.edit']);

        $this->command->info('Expense permissions seeded successfully!');
    }
}
