<?php

namespace Modules\Expense\Models;

use Illuminate\Database\Eloquent\Model;

class Currency extends Model
{
    protected $fillable = [
        'name',
        'code',
        'symbol',
        'symbol_native',
        'decimal_digits',
        'decimal_separator',
        'thousand_separator',
        'symbol_position',
        'space_between',
        'exchange_rate',
        'is_default',
        'is_active',
    ];

    protected $casts = [
        'decimal_digits' => 'integer',
        'exchange_rate' => 'float',
        'is_default' => 'boolean',
        'is_active' => 'boolean',
    ];

    /**
     * Get the default currency
     */
    public static function getDefault()
    {
        return static::where('is_default', 1)
            ->where('is_active', 1)
            ->first();
    }

    /**
     * Get active currencies
     */
    public static function getActive()
    {
        return static::where('is_active', 1)->get();
    }

    /**
     * Format an amount with this currency
     */
    public function format($amount)
    {
        $formatted = number_format(
            (float) $amount,
            $this->decimal_digits ?? 2,
            $this->decimal_separator ?? '.',
            $this->thousand_separator ?? ','
        );

        $space = $this->space_between ? ' ' : '';

        if ($this->symbol_position === 'before') {
            return $this->symbol . $space . $formatted;
        } else {
            return $formatted . $space . $this->symbol;
        }
    }

    /**
     * Format an amount without currency symbol
     */
    public function formatWithoutSymbol($amount)
    {
        return number_format(
            (float) $amount,
            $this->decimal_digits ?? 2,
            $this->decimal_separator ?? '.',
            $this->thousand_separator ?? ','
        );
    }
}
