# Expense Management Module

A comprehensive expense management module for Laravel with approval workflow, payments, and attachments.

## Features

- **Expense Management**: Create, edit, view, and delete expenses
- **Category Management**: Organize expenses by categories with travel support
- **Approval Workflow**: Draft → Submitted → Approved/Rejected → Paid
- **Payment Processing**: Full and partial payments with multiple payment methods
- **Attachments**: Upload receipts, bills, and travel images
- **Activity Logging**: Track all expense activities
- **Manager Assignment**: Assign managers for expense approval
- **Email Notifications**: Notify on submission, approval, rejection, and payment
- **Role-Based Access**: Permissions for view, create, edit, delete, approve, pay

## Installation

1. Copy the `Expense` folder to `Modules/Expense`

2. Register the module in `config/app.php` or run:
   ```bash
   php artisan module:enable Expense
   ```

3. Run migrations:
   ```bash
   php artisan migrate
   ```

4. Seed permissions:
   ```bash
   php artisan db:seed --class=Modules\\Expense\\Database\\Seeders\\ExpensePermissionSeeder
   ```

5. Add menu to your admin sidebar by including:
   ```blade
   @include('expense::menu')
   ```

## Routes

- `GET /admin/expense` - Expense listing
- `GET /admin/expense/create` - Create expense form
- `POST /admin/expense` - Store expense
- `GET /admin/expense/{id}` - View expense
- `GET /admin/expense/{id}/edit` - Edit expense form
- `PUT /admin/expense/{id}` - Update expense
- `DELETE /admin/expense/{id}` - Delete expense
- `POST /admin/expense/{id}/submit` - Submit for approval
- `POST /admin/expense/{id}/approve` - Approve expense
- `POST /admin/expense/{id}/reject` - Reject expense
- `GET /admin/expense/approval` - Approval dashboard
- `GET /admin/expense/payment/{id}` - Payment form
- `POST /admin/expense/payment/{id}` - Process payment
- `GET /admin/expense/my` - My expenses
- `GET /admin/expense/categories` - Category management

## Permissions

- `expense.view` - View expenses
- `expense.create` - Create expenses
- `expense.edit` - Edit expenses
- `expense.delete` - Delete expenses
- `expense.approve` - Approve/reject expenses
- `expense.pay` - Process payments

## Configuration

Edit `Config/config.php` to customize:

- Expense number format
- Approval workflow settings
- Travel rate per km
- Email notifications
- Currency settings
- Attachment types and limits

## Database Tables

- `expenses` - Main expense records
- `expense_categories` - Expense categories
- `expense_units` - Units of measurement
- `expense_attachments` - File attachments
- `expense_payments` - Payment records
- `expense_activity_log` - Activity tracking
- `expense_manager_assignments` - Employee-manager relationships
- `payment_methods` - Payment methods

## Requirements

- Laravel 10+
- PHP 8.1+
- nwidart/laravel-modules
- spatie/laravel-permission

## License

MIT
