<style>
    .dashboard-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px; flex-wrap: wrap; gap: 16px; }
    .dashboard-header h1 { font-size: 24px; font-weight: 700; color: var(--text-primary); margin: 0; display: flex; align-items: center; gap: 10px; }
    .dashboard-header h1 svg { width: 28px; height: 28px; color: var(--success); }
    
    .summary-cards { display: grid; grid-template-columns: repeat(auto-fit, minmax(180px, 1fr)); gap: 16px; margin-bottom: 24px; }
    .summary-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; padding: 20px; }
    .summary-card-value { font-size: 28px; font-weight: 700; color: var(--text-primary); }
    .summary-card-label { font-size: 13px; color: var(--text-muted); margin-top: 4px; }
    .summary-card.warning { border-left: 4px solid #f59e0b; }
    .summary-card.success { border-left: 4px solid var(--success); }
    .summary-card.primary { border-left: 4px solid var(--primary); }
    
    .section-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 24px; }
    @media (max-width: 1024px) { .section-grid { grid-template-columns: 1fr; } }
    
    .section-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; }
    .section-header { padding: 16px 20px; border-bottom: 1px solid var(--card-border); display: flex; justify-content: space-between; align-items: center; }
    .section-title { font-size: 16px; font-weight: 600; color: var(--text-primary); display: flex; align-items: center; gap: 8px; }
    .section-title svg { width: 20px; height: 20px; }
    .section-badge { background: var(--primary); color: #fff; font-size: 12px; padding: 2px 8px; border-radius: 10px; }
    .section-body { padding: 16px 20px; max-height: 500px; overflow-y: auto; }
    
    .expense-item { background: var(--body-bg); border-radius: 10px; padding: 16px; margin-bottom: 12px; }
    .expense-item:last-child { margin-bottom: 0; }
    .expense-item-header { display: flex; justify-content: space-between; align-items: start; margin-bottom: 12px; }
    .expense-item-title { font-size: 14px; font-weight: 600; color: var(--text-primary); }
    .expense-item-number { font-size: 12px; color: var(--text-muted); }
    .expense-item-amount { font-size: 18px; font-weight: 700; color: var(--primary); }
    .expense-item-meta { display: flex; gap: 16px; font-size: 12px; color: var(--text-muted); margin-bottom: 12px; }
    .expense-item-meta span { display: flex; align-items: center; gap: 4px; }
    .expense-item-meta svg { width: 14px; height: 14px; }
    .expense-item-actions { display: flex; gap: 8px; }
    .btn-sm { padding: 8px 12px; font-size: 12px; font-weight: 600; border-radius: 6px; border: none; cursor: pointer; display: inline-flex; align-items: center; gap: 4px; text-decoration: none; }
    .btn-sm svg { width: 14px; height: 14px; }
    .btn-approve { background: var(--success); color: #fff; }
    .btn-reject { background: var(--danger); color: #fff; }
    .btn-pay { background: #8b5cf6; color: #fff; }
    .btn-view { background: var(--card-bg); border: 1px solid var(--card-border); color: var(--text-primary); }
    
    .urgent-badge { background: rgba(239, 68, 68, 0.1); color: #ef4444; font-size: 11px; padding: 2px 6px; border-radius: 4px; margin-left: 8px; }
    
    .empty-state { text-align: center; padding: 40px 20px; color: var(--text-muted); }
    .empty-state svg { width: 48px; height: 48px; margin-bottom: 12px; opacity: 0.5; }
    
    .quick-pay-form { margin-top: 12px; padding-top: 12px; border-top: 1px solid var(--card-border); display: none; }
    .quick-pay-form.show { display: block; }
    .quick-pay-row { display: flex; gap: 8px; margin-bottom: 8px; }
    .quick-pay-row input, .quick-pay-row select { flex: 1; padding: 8px; font-size: 13px; border: 1px solid var(--input-border); border-radius: 6px; background: var(--input-bg); color: var(--input-text); }
</style>

<div style="padding: 20px;">
    <div class="dashboard-header">
        <h1>
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"></path></svg>
            Expense Approval Dashboard
        </h1>
        <a href="{{ route('admin.expense.index') }}" style="color: var(--primary); text-decoration: none; font-size: 14px;">
            ← Back to Expenses
        </a>
    </div>

    <!-- Summary Cards -->
    <div class="summary-cards">
        <div class="summary-card warning">
            <div class="summary-card-value">{{ $summary['pending_count'] }}</div>
            <div class="summary-card-label">Pending Approval</div>
        </div>
        <div class="summary-card primary">
            <div class="summary-card-value">{{ $currency ? $currency->symbol : '₹' }}{{ number_format($summary['pending_amount'], $currency ? $currency->decimal_digits : 2) }}</div>
            <div class="summary-card-label">Pending Amount</div>
        </div>
        <div class="summary-card success">
            <div class="summary-card-value">{{ $summary['approved_count'] }}</div>
            <div class="summary-card-label">Ready for Payment</div>
        </div>
        <div class="summary-card">
            <div class="summary-card-value">{{ $currency ? $currency->symbol : '₹' }}{{ number_format($summary['approved_unpaid'], $currency ? $currency->decimal_digits : 2) }}</div>
            <div class="summary-card-label">Unpaid Amount</div>
        </div>
    </div>

    <div class="section-grid">
        <!-- Pending Approval -->
        <div class="section-card">
            <div class="section-header">
                <div class="section-title">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="color: #f59e0b;"><path d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                    Pending Approval
                    <span class="section-badge">{{ $pendingExpenses->count() }}</span>
                </div>
            </div>
            <div class="section-body">
                @forelse($pendingExpenses as $expense)
                <div class="expense-item">
                    <div class="expense-item-header">
                        <div>
                            <div class="expense-item-title">
                                {{ Str::limit($expense->title, 40) }}
                                @if($expense->is_urgent)
                                <span class="urgent-badge">Urgent</span>
                                @endif
                            </div>
                            <div class="expense-item-number">#{{ $expense->expense_number }}</div>
                        </div>
                        <div class="expense-item-amount">{{ $currency ? $currency->symbol : '₹' }}{{ number_format($expense->amount, $currency ? $currency->decimal_digits : 2) }}</div>
                    </div>
                    <div class="expense-item-meta">
                        <span>
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg>
                            {{ $expense->employee?->name ?? 'N/A' }}
                        </span>
                        <span>
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path></svg>
                            {{ $expense->category?->name ?? 'N/A' }}
                        </span>
                        <span>
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                            {{ $expense->expense_date?->format('d M') }}
                        </span>
                    </div>
                    <div class="expense-item-actions">
                        <form action="{{ route('admin.expense.approve', $expense->id) }}" method="POST" style="display:inline">
                            @csrf
                            <button type="submit" class="btn-sm btn-approve" onclick="return confirm('Approve this expense?')">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M5 13l4 4L19 7"></path></svg>
                                Approve
                            </button>
                        </form>
                        <button type="button" class="btn-sm btn-reject" onclick="toggleRejectForm({{ $expense->id }})">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M6 18L18 6M6 6l12 12"></path></svg>
                            Reject
                        </button>
                        <a href="{{ route('admin.expense.show', $expense->id) }}" class="btn-sm btn-view">View</a>
                    </div>
                    <div id="reject-form-{{ $expense->id }}" class="quick-pay-form">
                        <form action="{{ route('admin.expense.reject', $expense->id) }}" method="POST">
                            @csrf
                            <div class="quick-pay-row">
                                <input type="text" name="rejection_reason" placeholder="Reason for rejection..." required>
                                <button type="submit" class="btn-sm btn-reject">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
                @empty
                <div class="empty-state">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                    <p>No pending approvals</p>
                </div>
                @endforelse
            </div>
        </div>

        <!-- Ready for Payment -->
        <div class="section-card">
            <div class="section-header">
                <div class="section-title">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="color: #10b981;"><path d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                    Ready for Payment
                    <span class="section-badge">{{ $approvedExpenses->count() }}</span>
                </div>
            </div>
            <div class="section-body">
                @forelse($approvedExpenses as $expense)
                <div class="expense-item">
                    <div class="expense-item-header">
                        <div>
                            <div class="expense-item-title">{{ Str::limit($expense->title, 40) }}</div>
                            <div class="expense-item-number">#{{ $expense->expense_number }}</div>
                        </div>
                        <div class="expense-item-amount">{{ $currency ? $currency->symbol : '₹' }}{{ number_format($expense->remaining_balance, $currency ? $currency->decimal_digits : 2) }}</div>
                    </div>
                    <div class="expense-item-meta">
                        <span>
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg>
                            {{ $expense->employee?->name ?? 'N/A' }}
                        </span>
                        <span>Total: {{ $currency ? $currency->symbol : '₹' }}{{ number_format($expense->amount, $currency ? $currency->decimal_digits : 2) }}</span>
                        @if($expense->total_paid > 0)
                        <span style="color: var(--success);">Paid: {{ $currency ? $currency->symbol : '₹' }}{{ number_format($expense->total_paid, $currency ? $currency->decimal_digits : 2) }}</span>
                        @endif
                    </div>
                    <div class="expense-item-actions">
                        <button type="button" class="btn-sm btn-pay" onclick="togglePayForm({{ $expense->id }})">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                            Quick Pay
                        </button>
                        <a href="{{ route('admin.expense.payment.form', $expense->id) }}" class="btn-sm btn-view">Full Form</a>
                        <a href="{{ route('admin.expense.show', $expense->id) }}" class="btn-sm btn-view">View</a>
                    </div>
                    <div id="pay-form-{{ $expense->id }}" class="quick-pay-form">
                        <form id="quick-pay-{{ $expense->id }}">
                            <input type="hidden" name="expense_id" value="{{ $expense->id }}">
                            <div class="quick-pay-row">
                                <input type="number" name="amount" value="{{ $expense->remaining_balance }}" step="0.01" max="{{ $expense->remaining_balance }}" placeholder="Amount" required>
                                <select name="payment_method_id" required>
                                    <option value="">Method</option>
                                    @foreach($paymentMethods as $method)
                                    <option value="{{ $method->id }}">{{ $method->name }}</option>
                                    @endforeach
                                </select>
                                <button type="submit" class="btn-sm btn-pay">Pay</button>
                            </div>
                        </form>
                    </div>
                </div>
                @empty
                <div class="empty-state">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                    <p>No expenses ready for payment</p>
                </div>
                @endforelse
            </div>
        </div>
    </div>
</div>

<script>
function toggleRejectForm(id) {
    document.getElementById('reject-form-' + id).classList.toggle('show');
}

function togglePayForm(id) {
    document.getElementById('pay-form-' + id).classList.toggle('show');
}

document.querySelectorAll('[id^="quick-pay-"]').forEach(function(form) {
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        var formData = new FormData(this);
        var data = {};
        formData.forEach((value, key) => data[key] = value);
        
        fetch('{{ route("admin.expense.payment.quick") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify(data)
        })
        .then(response => response.json())
        .then(result => {
            if (result.success) {
                alert(result.message);
                location.reload();
            } else {
                alert(result.message || 'Payment failed');
            }
        })
        .catch(error => {
            alert('Error processing payment');
            console.error(error);
        });
    });
});
</script>
