<div style="max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="display: flex; align-items: center; gap: 16px; margin-bottom: 24px;">
        <a href="{{ route('admin.expense.categories.index') }}" style="width: 40px; height: 40px; display: flex; align-items: center; justify-content: center; background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 10px; color: var(--text-secondary); text-decoration: none;">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="width:20px;height:20px"><path d="M15 19l-7-7 7-7"></path></svg>
        </a>
        <h1 style="font-size: 24px; font-weight: 700; margin: 0;">{{ isset($category) ? 'Edit Category' : 'Add Category' }}</h1>
    </div>

    <div style="background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden;">
        <form action="{{ isset($category) ? route('admin.expense.categories.update', $category->id) : route('admin.expense.categories.store') }}" method="POST">
            @csrf
            @if(isset($category)) @method('PUT') @endif
            
            <div style="padding: 24px;">
                <div style="margin-bottom: 20px;">
                    <label style="display: block; font-size: 14px; font-weight: 600; margin-bottom: 8px;">Name *</label>
                    <input type="text" name="name" value="{{ old('name', $category->name ?? '') }}" style="width: 100%; padding: 12px 16px; font-size: 14px; background: var(--input-bg); border: 1px solid var(--input-border); border-radius: 10px; color: var(--input-text);" required>
                    @error('name')<div style="color: var(--danger); font-size: 12px; margin-top: 4px;">{{ $message }}</div>@enderror
                </div>

                <div style="margin-bottom: 20px;">
                    <label style="display: block; font-size: 14px; font-weight: 600; margin-bottom: 8px;">Description</label>
                    <textarea name="description" rows="3" style="width: 100%; padding: 12px 16px; font-size: 14px; background: var(--input-bg); border: 1px solid var(--input-border); border-radius: 10px; color: var(--input-text);">{{ old('description', $category->description ?? '') }}</textarea>
                </div>

                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 16px; margin-bottom: 20px;">
                    <div>
                        <label style="display: block; font-size: 14px; font-weight: 600; margin-bottom: 8px;">Unit Price (for travel)</label>
                        <input type="number" name="unit_price" value="{{ old('unit_price', $category->unit_price ?? '') }}" step="0.01" min="0" style="width: 100%; padding: 12px 16px; font-size: 14px; background: var(--input-bg); border: 1px solid var(--input-border); border-radius: 10px; color: var(--input-text);" placeholder="₹ per km">
                    </div>
                    <div style="display: flex; flex-direction: column; justify-content: center;">
                        <label style="display: flex; align-items: center; gap: 12px; cursor: pointer;">
                            <input type="checkbox" name="is_travel_category" value="1" {{ old('is_travel_category', $category->is_travel_category ?? false) ? 'checked' : '' }} style="width: 20px; height: 20px;">
                            <span style="font-size: 14px; font-weight: 600;">Travel Category</span>
                        </label>
                    </div>
                </div>

                <div>
                    <label style="display: flex; align-items: center; gap: 12px; cursor: pointer;">
                        <input type="checkbox" name="is_active" value="1" {{ old('is_active', $category->is_active ?? true) ? 'checked' : '' }} style="width: 20px; height: 20px;">
                        <span style="font-size: 14px; font-weight: 600;">Active</span>
                    </label>
                </div>
            </div>

            <div style="display: flex; gap: 12px; padding: 20px 24px; background: var(--body-bg); border-top: 1px solid var(--card-border);">
                <button type="submit" style="display: inline-flex; align-items: center; gap: 8px; padding: 12px 24px; background: var(--primary); color: #fff; border: none; border-radius: 10px; font-size: 14px; font-weight: 600; cursor: pointer;">
                    {{ isset($category) ? 'Update' : 'Create' }} Category
                </button>
                <a href="{{ route('admin.expense.categories.index') }}" style="display: inline-flex; align-items: center; padding: 12px 24px; background: var(--card-bg); color: var(--text-secondary); border: 1px solid var(--card-border); border-radius: 10px; font-size: 14px; font-weight: 600; text-decoration: none;">Cancel</a>
            </div>
        </form>
    </div>
</div>
