<div style="padding: 20px;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px;">
        <h1 style="font-size: 24px; font-weight: 700; margin: 0;">Expense Categories</h1>
        <a href="{{ route('admin.expense.categories.create') }}" style="display: inline-flex; align-items: center; gap: 8px; background: var(--primary); color: #fff; padding: 10px 20px; border-radius: 8px; text-decoration: none; font-weight: 600;">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="width:18px;height:18px"><path d="M12 4v16m8-8H4"></path></svg>
            Add Category
        </a>
    </div>

    <div style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 16px; margin-bottom: 24px;">
        <div style="background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; padding: 20px;">
            <div style="font-size: 24px; font-weight: 700;">{{ $stats['total'] }}</div>
            <div style="font-size: 13px; color: var(--text-muted);">Total</div>
        </div>
        <div style="background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; padding: 20px;">
            <div style="font-size: 24px; font-weight: 700; color: var(--success);">{{ $stats['active'] }}</div>
            <div style="font-size: 13px; color: var(--text-muted);">Active</div>
        </div>
        <div style="background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; padding: 20px;">
            <div style="font-size: 24px; font-weight: 700; color: var(--primary);">{{ $stats['travel'] }}</div>
            <div style="font-size: 13px; color: var(--text-muted);">Travel</div>
        </div>
        <div style="background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; padding: 20px;">
            <div style="font-size: 24px; font-weight: 700; color: var(--danger);">{{ $stats['inactive'] }}</div>
            <div style="font-size: 13px; color: var(--text-muted);">Inactive</div>
        </div>
    </div>

    <div style="background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden;">
        <table id="categoryTable" class="dt-table dt-search dt-perpage" data-route="{{ route('admin.expense.categories.data') }}">
            <thead>
                <tr>
                    <th class="dt-sort" data-col="id">ID</th>
                    <th class="dt-sort" data-col="name">Name</th>
                    <th data-col="description">Description</th>
                    <th data-col="unit_price" data-render="currency">Unit Price</th>
                    <th data-col="is_travel_category" data-render="travel">Travel</th>
                    <th data-col="is_active" data-render="toggle">Status</th>
                    <th data-render="actions">Actions</th>
                </tr>
            </thead>
            <tbody></tbody>
        </table>
    </div>
</div>

@include('core::datatable')
<script>
window.dtRenders = window.dtRenders || {};
window.dtRenders.currency = function(v) { return v ? '₹' + parseFloat(v).toFixed(2) : '-'; };
window.dtRenders.travel = function(v) { return v ? '<span style="color:var(--primary)">✓ Travel</span>' : '-'; };
</script>
