<style>
    /* ========== PROFESSIONAL EXPENSE FORM ========== */
    .expense-form-page { 
        max-width: 1000px; 
        margin: 0 auto; 
        padding: 24px;
    }
    
    /* Header Section */
    .expense-header {
        display: flex;
        align-items: center;
        gap: 20px;
        margin-bottom: 32px;
        background: linear-gradient(135deg, var(--primary), #6366f1);
        padding: 24px 32px;
        border-radius: 20px;
        position: relative;
        overflow: hidden;
    }
    .expense-header::before {
        content: '';
        position: absolute;
        top: -50%;
        right: -20%;
        width: 300px;
        height: 300px;
        background: rgba(255,255,255,0.1);
        border-radius: 50%;
    }
    .expense-header::after {
        content: '';
        position: absolute;
        bottom: -30%;
        left: 10%;
        width: 200px;
        height: 200px;
        background: rgba(255,255,255,0.05);
        border-radius: 50%;
    }
    .btn-back-exp { 
        width: 48px; 
        height: 48px; 
        display: flex; 
        align-items: center; 
        justify-content: center; 
        background: rgba(255,255,255,0.2); 
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255,255,255,0.3); 
        border-radius: 14px; 
        color: #fff; 
        text-decoration: none;
        transition: all 0.3s;
        z-index: 1;
    }
    .btn-back-exp:hover { 
        background: rgba(255,255,255,0.3); 
        transform: translateX(-4px);
    }
    .btn-back-exp svg { width: 22px; height: 22px; }
    .expense-header-content { z-index: 1; }
    .expense-header h1 { 
        font-size: 28px; 
        font-weight: 800; 
        color: #fff; 
        margin: 0 0 6px 0;
        text-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    .expense-header p {
        color: rgba(255,255,255,0.9);
        font-size: 14px;
        margin: 0;
    }
    .expense-header-icon {
        margin-left: auto;
        z-index: 1;
        background: rgba(255,255,255,0.2);
        border-radius: 20px;
        padding: 16px;
        backdrop-filter: blur(10px);
    }
    .expense-header-icon svg {
        width: 48px;
        height: 48px;
        color: #fff;
    }

    /* Form Cards */
    .exp-form-card { 
        background: var(--card-bg); 
        border: 1px solid var(--card-border); 
        border-radius: 20px; 
        overflow: hidden; 
        margin-bottom: 24px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.05);
        transition: all 0.3s;
    }
    .exp-form-card:hover {
        box-shadow: 0 8px 30px rgba(0,0,0,0.08);
    }
    .exp-form-card-header { 
        padding: 20px 28px; 
        border-bottom: 1px solid var(--card-border); 
        background: linear-gradient(to right, var(--body-bg), transparent);
        display: flex;
        align-items: center;
        gap: 14px;
    }
    .exp-card-icon {
        width: 44px;
        height: 44px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .exp-card-icon svg { width: 22px; height: 22px; color: #fff; }
    .exp-card-icon.blue { background: linear-gradient(135deg, #3b82f6, #2563eb); }
    .exp-card-icon.purple { background: linear-gradient(135deg, #8b5cf6, #7c3aed); }
    .exp-card-icon.green { background: linear-gradient(135deg, #10b981, #059669); }
    .exp-card-icon.orange { background: linear-gradient(135deg, #f59e0b, #d97706); }
    .exp-card-icon.pink { background: linear-gradient(135deg, #ec4899, #db2777); }
    .exp-form-card-title { 
        font-size: 17px; 
        font-weight: 700; 
        color: var(--text-primary); 
        margin: 0;
    }
    .exp-form-card-subtitle {
        font-size: 13px;
        color: var(--text-muted);
        margin: 4px 0 0 0;
    }
    .exp-form-card-body { padding: 28px; }

    /* Form Elements */
    .exp-form-group { margin-bottom: 24px; }
    .exp-form-label { 
        display: flex;
        align-items: center;
        gap: 8px;
        font-size: 14px; 
        font-weight: 600; 
        color: var(--text-primary); 
        margin-bottom: 10px; 
    }
    .exp-form-label svg {
        width: 16px;
        height: 16px;
        color: var(--primary);
    }
    .exp-form-label .required { color: #ef4444; font-weight: 700; }
    .exp-form-input, .exp-form-select, .exp-form-textarea { 
        width: 100%; 
        padding: 14px 18px; 
        font-size: 14px; 
        background: var(--input-bg); 
        border: 2px solid var(--input-border); 
        border-radius: 12px; 
        color: var(--input-text);
        transition: all 0.3s;
    }
    .exp-form-input:focus, .exp-form-select:focus, .exp-form-textarea:focus { 
        outline: none; 
        border-color: var(--primary); 
        box-shadow: 0 0 0 4px rgba(59, 130, 246, 0.15);
        background: var(--card-bg);
    }
    .exp-form-textarea { min-height: 120px; resize: vertical; }
    .exp-form-hint { 
        display: flex;
        align-items: center;
        gap: 6px;
        font-size: 12px; 
        color: var(--text-muted); 
        margin-top: 8px; 
    }
    .exp-form-hint svg { width: 14px; height: 14px; }
    .exp-form-error { 
        display: flex;
        align-items: center;
        gap: 6px;
        font-size: 12px; 
        color: #ef4444; 
        margin-top: 8px;
        background: rgba(239, 68, 68, 0.1);
        padding: 8px 12px;
        border-radius: 8px;
    }

    /* Grid Layouts */
    .exp-row { display: grid; gap: 20px; }
    .exp-row-2 { grid-template-columns: repeat(2, 1fr); }
    .exp-row-3 { grid-template-columns: repeat(3, 1fr); }
    .exp-row-4 { grid-template-columns: repeat(4, 1fr); }
    @media (max-width: 768px) {
        .exp-row-2, .exp-row-3, .exp-row-4 { grid-template-columns: 1fr; }
    }

    /* Input Group */
    .exp-input-group { display: flex; }
    .exp-input-addon { 
        padding: 14px 18px; 
        background: linear-gradient(to right, var(--body-bg), var(--card-bg)); 
        border: 2px solid var(--input-border); 
        border-right: none; 
        border-radius: 12px 0 0 12px; 
        color: var(--primary);
        font-weight: 700;
        font-size: 15px;
    }
    .exp-input-group .exp-form-input { border-radius: 0 12px 12px 0; }

    /* Amount Display Card */
    .exp-amount-card { 
        background: linear-gradient(135deg, #1e293b, #334155);
        border-radius: 16px; 
        padding: 24px;
        color: #fff;
        margin-top: 20px;
    }
    [data-theme="dark"] .exp-amount-card {
        background: linear-gradient(135deg, #0f172a, #1e293b);
        border: 1px solid rgba(255,255,255,0.1);
    }
    .exp-amount-row { 
        display: flex; 
        justify-content: space-between; 
        align-items: center;
        padding: 12px 0; 
        border-bottom: 1px solid rgba(255,255,255,0.1);
        width: 100%;
    }
    .exp-amount-row:last-child { 
        border-bottom: none; 
        padding-top: 16px;
        margin-top: 8px;
        border-top: 2px dashed rgba(255,255,255,0.2);
    }
    .exp-amount-label { 
        color: rgba(255,255,255,0.7); 
        font-size: 14px;
        flex: 1;
    }
    .exp-amount-value { 
        color: #fff; 
        font-weight: 600; 
        font-size: 15px;
        text-align: right;
        min-width: 120px;
    }
    .exp-amount-row:last-child .exp-amount-label { font-size: 16px; font-weight: 600; color: #fff; }
    .exp-amount-row:last-child .exp-amount-value { font-size: 24px; font-weight: 800; color: #10b981; }

    /* File Upload */
    .exp-file-upload { 
        display: block;
        border: 2px dashed var(--primary); 
        border-radius: 16px; 
        padding: 40px; 
        text-align: center; 
        cursor: pointer; 
        transition: all 0.3s;
        background: linear-gradient(135deg, rgba(59, 130, 246, 0.05), rgba(99, 102, 241, 0.05));
    }
    .exp-file-upload:hover { 
        border-color: #6366f1;
        background: linear-gradient(135deg, rgba(59, 130, 246, 0.1), rgba(99, 102, 241, 0.1));
        transform: translateY(-2px);
    }
    .exp-file-upload-icon {
        width: 72px;
        height: 72px;
        background: linear-gradient(135deg, var(--primary), #6366f1);
        border-radius: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 16px;
    }
    .exp-file-upload-icon svg { width: 36px; height: 36px; color: #fff; }
    .exp-file-upload-text { font-size: 16px; font-weight: 600; color: var(--text-primary); margin-bottom: 6px; }
    .exp-file-upload-hint { font-size: 13px; color: var(--text-muted); }
    .exp-file-list { margin-top: 20px; }
    .exp-file-item { 
        display: flex; 
        align-items: center; 
        gap: 14px; 
        padding: 14px 18px; 
        background: var(--body-bg); 
        border: 1px solid var(--card-border);
        border-radius: 12px; 
        margin-bottom: 10px;
        transition: all 0.3s;
    }
    .exp-file-item:hover {
        border-color: var(--primary);
        box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    }
    .exp-file-icon { 
        width: 44px; 
        height: 44px; 
        background: linear-gradient(135deg, #8b5cf6, #7c3aed);
        border-radius: 10px; 
        display: flex; 
        align-items: center; 
        justify-content: center;
    }
    .exp-file-icon svg { width: 22px; height: 22px; color: #fff; }
    .exp-file-info { flex: 1; }
    .exp-file-name { font-size: 14px; font-weight: 600; color: var(--text-primary); }
    .exp-file-size { font-size: 12px; color: var(--text-muted); margin-top: 2px; }

    /* Travel Notice */
    .exp-notice { 
        display: none;
        align-items: center;
        gap: 14px;
        padding: 16px 20px;
        border-radius: 12px;
        margin-bottom: 20px;
    }
    .exp-notice.show { display: flex; }
    .exp-notice-icon {
        width: 40px;
        height: 40px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }
    .exp-notice-icon svg { width: 20px; height: 20px; color: #fff; }
    .exp-notice p { margin: 0; font-size: 14px; font-weight: 500; }
    .exp-notice.travel {
        background: linear-gradient(135deg, rgba(59, 130, 246, 0.1), rgba(99, 102, 241, 0.1));
        border: 1px solid rgba(59, 130, 246, 0.2);
    }
    .exp-notice.travel .exp-notice-icon { background: linear-gradient(135deg, #3b82f6, #6366f1); }
    .exp-notice.travel p { color: #3b82f6; }

    /* Action Buttons */
    .exp-form-actions { 
        display: flex; 
        gap: 14px; 
        padding: 24px 28px; 
        background: linear-gradient(to right, var(--body-bg), transparent);
        border-top: 1px solid var(--card-border); 
    }
    .exp-btn-submit { 
        display: inline-flex; 
        align-items: center; 
        gap: 10px; 
        padding: 14px 32px; 
        background: linear-gradient(135deg, var(--primary), #6366f1);
        color: #fff; 
        border: none; 
        border-radius: 12px; 
        font-size: 15px; 
        font-weight: 700; 
        cursor: pointer;
        transition: all 0.3s;
        box-shadow: 0 4px 15px rgba(59, 130, 246, 0.3);
    }
    .exp-btn-submit:hover { 
        transform: translateY(-2px); 
        box-shadow: 0 8px 25px rgba(59, 130, 246, 0.4);
    }
    .exp-btn-submit svg { width: 20px; height: 20px; }
    .exp-btn-cancel { 
        display: inline-flex; 
        align-items: center;
        gap: 8px;
        padding: 14px 28px; 
        background: var(--card-bg); 
        color: var(--text-secondary); 
        border: 2px solid var(--card-border); 
        border-radius: 12px; 
        font-size: 15px; 
        font-weight: 600; 
        text-decoration: none;
        transition: all 0.3s;
    }
    .exp-btn-cancel:hover { 
        background: var(--body-bg); 
        color: var(--text-primary);
        border-color: var(--text-muted);
    }

    /* Error Alert */
    .exp-alert-errors { 
        background: linear-gradient(135deg, rgba(239, 68, 68, 0.1), rgba(220, 38, 38, 0.1));
        border: 1px solid rgba(239, 68, 68, 0.3); 
        border-radius: 16px; 
        padding: 20px 24px; 
        margin-bottom: 24px;
        display: flex;
        gap: 16px;
    }
    .exp-alert-icon {
        width: 48px;
        height: 48px;
        background: linear-gradient(135deg, #ef4444, #dc2626);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }
    .exp-alert-icon svg { width: 24px; height: 24px; color: #fff; }
    .exp-alert-content { flex: 1; }
    .exp-alert-title { font-size: 15px; font-weight: 700; color: #ef4444; margin-bottom: 10px; }
    .exp-alert-errors ul { margin: 0; padding-left: 20px; }
    .exp-alert-errors li { font-size: 13px; color: #dc2626; margin-bottom: 4px; }

    @media (max-width: 640px) {
        .expense-header { padding: 20px; flex-direction: column; text-align: center; }
        .expense-header-icon { margin: 16px auto 0; }
        .exp-form-actions { flex-direction: column; }
        .exp-btn-submit, .exp-btn-cancel { width: 100%; justify-content: center; }
    }
</style>

<div class="expense-form-page">
    <div class="expense-header">
        <a href="{{ route('admin.expense.my.index') }}" class="btn-back-exp">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M15 19l-7-7 7-7"></path></svg>
        </a>
        <div class="expense-header-content">
            <h1>{{ isset($expense) ? 'Edit Expense' : 'Create New Expense' }}</h1>
            <p>{{ isset($expense) ? 'Update expense details and submit for approval' : 'Fill in the details below to create a new expense claim' }}</p>
        </div>
        <div class="expense-header-icon">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 14l6-6m-5.5.5h.01m4.99 5h.01M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16l3.5-2 3.5 2 3.5-2 3.5 2z"></path></svg>
        </div>
    </div>

    @if($errors->any())
        <div class="exp-alert-errors">
            <div class="exp-alert-icon">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path></svg>
            </div>
            <div class="exp-alert-content">
                <div class="exp-alert-title">Please fix the following errors:</div>
                <ul>@foreach($errors->all() as $error)<li>{{ $error }}</li>@endforeach</ul>
            </div>
        </div>
    @endif

    <form action="{{ isset($expense) ? route('admin.expense.update', $expense->id) : route('admin.expense.store') }}" method="POST" enctype="multipart/form-data" id="expense-form">
        @csrf
        @if(isset($expense)) @method('PUT') @endif

        <div class="exp-form-card">
            <div class="exp-form-card-header">
                <div class="exp-card-icon blue">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                </div>
                <div>
                    <h2 class="exp-form-card-title">Expense Details</h2>
                    <p class="exp-form-card-subtitle">Basic information about your expense</p>
                </div>
            </div>
            <div class="exp-form-card-body">
                <div class="exp-row exp-row-2">
                    <div class="exp-form-group">
                        <label class="exp-form-label">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A2 2 0 013 12V7a4 4 0 014-4z"></path></svg>
                            Title <span class="required">*</span>
                        </label>
                        <input type="text" name="title" value="{{ old('title', $expense->title ?? '') }}" class="exp-form-input" placeholder="Enter expense title..." required>
                        @error('title')<div class="exp-form-error">{{ $message }}</div>@enderror
                    </div>
                    <div class="exp-form-group">
                        <label class="exp-form-label">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                            Expense Date <span class="required">*</span>
                        </label>
                        <input type="date" name="expense_date" value="{{ old('expense_date', isset($expense) ? $expense->expense_date->format('Y-m-d') : date('Y-m-d')) }}" class="exp-form-input" required>
                    </div>
                </div>

                <div class="exp-row exp-row-2">
                    <div class="exp-form-group">
                        <label class="exp-form-label">Category <span class="required">*</span></label>
                        <select name="category_id" id="category_id" class="exp-form-select" required>
                            <option value="">Select Category</option>
                            @foreach($categories as $category)
                                <option value="{{ $category->id }}" 
                                    data-travel="{{ $category->is_travel_category ? '1' : '0' }}"
                                    data-unit-price="{{ $category->unit_price }}"
                                    {{ old('category_id', $expense->category_id ?? '') == $category->id ? 'selected' : '' }}>
                                    {{ $category->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="exp-form-group">
                        <label class="exp-form-label">Unit</label>
                        <select name="unit_id" id="unit_id" class="exp-form-select">
                            <option value="">Select Unit</option>
                            @foreach($units as $unit)
                                <option value="{{ $unit->id }}" data-symbol="{{ $unit->symbol }}" data-type="{{ $unit->type }}" {{ old('unit_id', $expense->unit_id ?? '') == $unit->id ? 'selected' : '' }}>
                                    {{ $unit->name }} ({{ $unit->symbol }})
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <!-- Optional Project Selection for tracking -->
                <div class="exp-form-group">
                    <label class="exp-form-label">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path></svg>
                        Project <span style="font-weight: 400; color: var(--text-muted);">(Optional)</span>
                    </label>
                    <select name="project_id" id="project_id" class="exp-form-select">
                        <option value="">No Project / General Expense</option>
                        @foreach($projects ?? [] as $project)
                            <option value="{{ $project->id }}" {{ old('project_id', $expense->project_id ?? '') == $project->id ? 'selected' : '' }}>{{ $project->title }}</option>
                        @endforeach
                    </select>
                    <div class="exp-form-hint">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                        Link this expense to a project for tracking purposes
                    </div>
                </div>

                <div id="travel-notice" class="exp-notice travel">
                    <div class="exp-notice-icon">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M13 16V6a1 1 0 00-1-1H4a1 1 0 00-1 1v10a1 1 0 001 1h1m8-1a1 1 0 01-1 1H9m4-1V8a1 1 0 011-1h2.586a1 1 0 01.707.293l3.414 3.414a1 1 0 01.293.707V16a1 1 0 01-1 1h-1m-6-1a1 1 0 001 1h1M5 17a2 2 0 104 0m-4 0a2 2 0 114 0m6 0a2 2 0 104 0m-4 0a2 2 0 114 0"></path></svg>
                    </div>
                    <p><strong>Travel Category:</strong> Unit price is automatically set based on the configured travel rate.</p>
                </div>

                <div class="exp-form-group">
                    <label class="exp-form-label">Notes / Description</label>
                    <textarea name="notes" class="exp-form-textarea" placeholder="Add any additional notes...">{{ old('notes', $expense->notes ?? '') }}</textarea>
                </div>
            </div>
        </div>

        <div class="exp-form-card">
            <div class="exp-form-card-header">
                <div class="exp-card-icon green">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                </div>
                <div>
                    <h2 class="exp-form-card-title">Amount Details</h2>
                    <p class="exp-form-card-subtitle">Enter pricing and quantity information</p>
                </div>
            </div>
            <div class="exp-form-card-body">
                <div class="exp-row exp-row-3">
                    <div class="exp-form-group">
                        <label class="exp-form-label">Unit Price <span class="required">*</span></label>
                        <div class="exp-input-group">
                            <span class="exp-input-addon">₹</span>
                            <input type="number" name="unit_price" id="unit_price" value="{{ old('unit_price', $expense->unit_price ?? '0') }}" step="0.01" min="0" class="exp-form-input" required>
                        </div>
                    </div>
                    <div class="exp-form-group">
                        <label class="exp-form-label">Quantity <span class="required">*</span></label>
                        <div class="exp-input-group">
                            <input type="number" name="quantity" id="quantity" value="{{ old('quantity', $expense->quantity ?? '1') }}" step="0.01" min="0.01" class="exp-form-input" required>
                            <span class="exp-input-addon" id="unit-symbol" style="border-left:none;border-right:2px solid var(--input-border);border-radius:0 12px 12px 0">pcs</span>
                        </div>
                    </div>
                    <div class="exp-form-group">
                        <label class="exp-form-label">Tax Rate</label>
                        <div class="exp-input-group">
                            <input type="number" name="tax_rate" id="tax_rate" value="{{ old('tax_rate', $expense->tax_rate ?? '0') }}" step="0.01" min="0" max="100" class="exp-form-input">
                            <span class="exp-input-addon" style="border-left:none;border-right:2px solid var(--input-border);border-radius:0 12px 12px 0">%</span>
                        </div>
                    </div>
                </div>
                <div class="exp-amount-card">
                    <div class="exp-amount-row"><span class="exp-amount-label">Subtotal</span><span class="exp-amount-value" id="display-subtotal">₹0.00</span></div>
                    <div class="exp-amount-row"><span class="exp-amount-label">Tax Amount</span><span class="exp-amount-value" id="display-tax">₹0.00</span></div>
                    <div class="exp-amount-row"><span class="exp-amount-label">Total Amount</span><span class="exp-amount-value" id="display-total">₹0.00</span></div>
                </div>
            </div>
        </div>

        <div class="exp-form-card">
            <div class="exp-form-card-header">
                <div class="exp-card-icon purple">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                </div>
                <div>
                    <h2 class="exp-form-card-title">Payment & Assignment</h2>
                    <p class="exp-form-card-subtitle">Payment details and expense assignment</p>
                </div>
            </div>
            <div class="exp-form-card-body">
                <div class="exp-row exp-row-2">
                    <div class="exp-form-group">
                        <label class="exp-form-label">Vendor / Supplier</label>
                        <input type="text" name="vendor" value="{{ old('vendor', $expense->vendor ?? '') }}" class="exp-form-input" placeholder="Enter vendor name...">
                    </div>
                    <div class="exp-form-group">
                        <label class="exp-form-label">Reference Number</label>
                        <input type="text" name="reference_no" value="{{ old('reference_no', $expense->reference_no ?? '') }}" class="exp-form-input" placeholder="Invoice/Receipt number...">
                    </div>
                </div>
                <div class="exp-row exp-row-2">
                    <div class="exp-form-group">
                        <label class="exp-form-label">Paid By</label>
                        <select name="paid_by" class="exp-form-select">
                            <option value="employee" {{ old('paid_by', $expense->paid_by ?? 'employee') == 'employee' ? 'selected' : '' }}>Employee</option>
                            <option value="company" {{ old('paid_by', $expense->paid_by ?? '') == 'company' ? 'selected' : '' }}>Company</option>
                        </select>
                    </div>
                    <div class="exp-form-group">
                        <label class="exp-form-label">Payment Method</label>
                        <select name="payment_method_id" class="exp-form-select">
                            <option value="">Select Payment Method</option>
                            @foreach($paymentMethods as $method)
                                <option value="{{ $method->id }}" {{ old('payment_method_id', $expense->payment_method_id ?? '') == $method->id ? 'selected' : '' }}>{{ $method->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                @php $user = auth('admin')->user(); @endphp
                @if($user->hasRole('super-admin'))
                    <div class="exp-row exp-row-2">
                        <div class="exp-form-group">
                            <label class="exp-form-label">Employee <span class="required">*</span></label>
                            <select name="employee_id" class="exp-form-select" required>
                                <option value="">Select Employee</option>
                                @foreach($employees as $emp)
                                    <option value="{{ $emp->id }}" {{ old('employee_id', $expense->employee_id ?? $user->id) == $emp->id ? 'selected' : '' }}>{{ $emp->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="exp-form-group">
                            <label class="exp-form-label">Manager</label>
                            <select name="manager_id" class="exp-form-select">
                                <option value="">Select Manager</option>
                                @foreach($managers as $mgr)
                                    <option value="{{ $mgr->id }}" {{ old('manager_id', $expense->manager_id ?? $defaultManager) == $mgr->id ? 'selected' : '' }}>{{ $mgr->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                @else
                    <input type="hidden" name="employee_id" value="{{ $user->id }}">
                    <div class="exp-form-group">
                        <label class="exp-form-label">Employee</label>
                        <select class="exp-form-select" disabled><option selected>{{ $user->name }}</option></select>
                        <div class="exp-form-hint"><svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>Expense will be created for your account</div>
                    </div>
                @endif
            </div>
        </div>

        <div class="exp-form-card">
            <div class="exp-form-card-header">
                <div class="exp-card-icon orange">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"></path></svg>
                </div>
                <div>
                    <h2 class="exp-form-card-title">Attachments</h2>
                    <p class="exp-form-card-subtitle">Upload receipts, invoices, or supporting documents</p>
                </div>
            </div>
            <div class="exp-form-card-body">
                <label class="exp-file-upload" for="file-input">
                    <input type="file" name="attachments[]" id="file-input" multiple accept=".jpg,.jpeg,.png,.pdf,.doc,.docx" style="display:none">
                    <div class="exp-file-upload-icon">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path></svg>
                    </div>
                    <div class="exp-file-upload-text">Click to upload or drag and drop</div>
                    <div class="exp-file-upload-hint">JPG, PNG, PDF, DOC (Max 5MB each)</div>
                </label>
                <div class="exp-file-list" id="file-list">
                    @if(isset($expense) && $expense->attachments->count() > 0)
                        @foreach($expense->attachments as $attachment)
                            <div class="exp-file-item">
                                <div class="exp-file-icon"><svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg></div>
                                <div class="exp-file-info">
                                    <div class="exp-file-name">{{ $attachment->original_name }}</div>
                                    <div class="exp-file-size">{{ $attachment->formatted_file_size }}</div>
                                </div>
                                <a href="{{ route('admin.expense.attachment.download', $attachment->id) }}" target="_blank" style="color: var(--primary);">View</a>
                            </div>
                        @endforeach
                    @endif
                </div>
            </div>
            <div class="exp-form-actions">
                <button type="submit" class="exp-btn-submit">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M5 13l4 4L19 7"></path></svg>
                    {{ isset($expense) ? 'Update Expense' : 'Create Expense' }}
                </button>
                <a href="{{ route('admin.expense.my.index') }}" class="exp-btn-cancel">Cancel</a>
            </div>
        </div>
    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const categorySelect = document.getElementById('category_id');
    const unitSelect = document.getElementById('unit_id');
    const unitPriceInput = document.getElementById('unit_price');
    const quantityInput = document.getElementById('quantity');
    const taxRateInput = document.getElementById('tax_rate');
    const unitSymbol = document.getElementById('unit-symbol');
    const travelNotice = document.getElementById('travel-notice');
    const displaySubtotal = document.getElementById('display-subtotal');
    const displayTax = document.getElementById('display-tax');
    const displayTotal = document.getElementById('display-total');
    const travelRate = {{ $travelRate ?? 10 }};
    const lockTravelRate = {{ ($lockTravelRate ?? false) ? 'true' : 'false' }};
    
    function formatCurrency(amount) {
        return '₹' + parseFloat(amount).toLocaleString('en-IN', {minimumFractionDigits: 2, maximumFractionDigits: 2});
    }
    
    function calculateAmounts() {
        const unitPrice = parseFloat(unitPriceInput.value) || 0;
        const quantity = parseFloat(quantityInput.value) || 0;
        const taxRate = parseFloat(taxRateInput.value) || 0;
        const subtotal = unitPrice * quantity;
        const taxAmount = subtotal * (taxRate / 100);
        const total = subtotal + taxAmount;
        displaySubtotal.textContent = formatCurrency(subtotal);
        displayTax.textContent = formatCurrency(taxAmount);
        displayTotal.textContent = formatCurrency(total);
    }
    
    function handleCategoryChange() {
        const selected = categorySelect.options[categorySelect.selectedIndex];
        if (!selected.value) { travelNotice.classList.remove('show'); return; }
        const isTravel = selected.dataset.travel === '1';
        const categoryUnitPrice = selected.dataset.unitPrice;
        
        if (isTravel) {
            travelNotice.classList.add('show');
            unitPriceInput.value = categoryUnitPrice || travelRate;
            if (lockTravelRate) { unitPriceInput.readOnly = true; unitPriceInput.style.background = 'var(--body-bg)'; }
            for (let option of unitSelect.options) { if (option.dataset.type === 'distance') { unitSelect.value = option.value; unitSymbol.textContent = option.dataset.symbol || 'km'; break; } }
        } else { travelNotice.classList.remove('show'); unitPriceInput.readOnly = false; unitPriceInput.style.background = ''; }
        calculateAmounts();
    }
    
    function handleUnitChange() { const selected = unitSelect.options[unitSelect.selectedIndex]; unitSymbol.textContent = selected.dataset.symbol || 'pcs'; }
    
    categorySelect.addEventListener('change', handleCategoryChange);
    unitSelect.addEventListener('change', handleUnitChange);
    unitPriceInput.addEventListener('input', calculateAmounts);
    quantityInput.addEventListener('input', calculateAmounts);
    taxRateInput.addEventListener('input', calculateAmounts);
    
    const fileInput = document.getElementById('file-input');
    const fileList = document.getElementById('file-list');
    fileInput.addEventListener('change', function() {
        for (let file of this.files) {
            const size = (file.size / 1024).toFixed(1) + ' KB';
            const item = document.createElement('div');
            item.className = 'exp-file-item';
            item.innerHTML = '<div class="exp-file-icon"><svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg></div><div class="exp-file-info"><div class="exp-file-name">' + file.name + '</div><div class="exp-file-size">' + size + '</div></div>';
            fileList.appendChild(item);
        }
    });
    
    handleCategoryChange();
    handleUnitChange();
    calculateAmounts();
});
</script>
