<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Expense - {{ $expense->expense_number }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'DejaVu Sans', Arial, sans-serif;
            font-size: 12px;
            line-height: 1.5;
            color: #333;
            padding: 20px;
        }
        .header {
            display: table;
            width: 100%;
            margin-bottom: 30px;
            border-bottom: 2px solid #3b82f6;
            padding-bottom: 15px;
        }
        .header-left {
            display: table-cell;
            width: 60%;
            vertical-align: top;
        }
        .header-right {
            display: table-cell;
            width: 40%;
            vertical-align: top;
            text-align: right;
        }
        .company-name {
            font-size: 24px;
            font-weight: bold;
            color: #1e40af;
            margin-bottom: 5px;
        }
        .document-title {
            font-size: 18px;
            font-weight: bold;
            color: #333;
            margin-bottom: 10px;
        }
        .expense-number {
            font-size: 14px;
            color: #666;
        }
        .status-badge {
            display: inline-block;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: bold;
            text-transform: uppercase;
            margin-top: 10px;
        }
        .status-paid {
            background: #d1fae5;
            color: #065f46;
        }
        .status-approved {
            background: #dbeafe;
            color: #1e40af;
        }
        .info-section {
            display: table;
            width: 100%;
            margin-bottom: 25px;
        }
        .info-box {
            display: table-cell;
            width: 50%;
            vertical-align: top;
            padding-right: 15px;
        }
        .info-box:last-child {
            padding-right: 0;
            padding-left: 15px;
        }
        .info-box-title {
            font-size: 11px;
            font-weight: bold;
            color: #6b7280;
            text-transform: uppercase;
            margin-bottom: 8px;
            border-bottom: 1px solid #e5e7eb;
            padding-bottom: 5px;
        }
        .info-row {
            display: table;
            width: 100%;
            margin-bottom: 5px;
        }
        .info-label {
            display: table-cell;
            width: 40%;
            color: #6b7280;
            font-size: 11px;
        }
        .info-value {
            display: table-cell;
            width: 60%;
            font-weight: 500;
        }
        .details-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 25px;
        }
        .details-table th {
            background: #f3f4f6;
            padding: 10px;
            text-align: left;
            font-size: 11px;
            font-weight: bold;
            color: #374151;
            border-bottom: 2px solid #d1d5db;
        }
        .details-table td {
            padding: 10px;
            border-bottom: 1px solid #e5e7eb;
        }
        .amount-section {
            width: 300px;
            margin-left: auto;
            margin-bottom: 25px;
        }
        .amount-row {
            display: table;
            width: 100%;
            padding: 8px 0;
            border-bottom: 1px solid #e5e7eb;
        }
        .amount-row:last-child {
            border-bottom: none;
        }
        .amount-label {
            display: table-cell;
            width: 50%;
            color: #6b7280;
        }
        .amount-value {
            display: table-cell;
            width: 50%;
            text-align: right;
            font-weight: 500;
        }
        .amount-row.total {
            background: #f3f4f6;
            padding: 12px 10px;
            border-radius: 5px;
        }
        .amount-row.total .amount-label,
        .amount-row.total .amount-value {
            font-weight: bold;
            font-size: 14px;
            color: #1e40af;
        }
        .amount-row.paid {
            background: #d1fae5;
            padding: 12px 10px;
            border-radius: 5px;
            margin-top: 5px;
        }
        .amount-row.paid .amount-label,
        .amount-row.paid .amount-value {
            font-weight: bold;
            color: #065f46;
        }
        .payment-section {
            margin-bottom: 25px;
        }
        .section-title {
            font-size: 14px;
            font-weight: bold;
            color: #374151;
            margin-bottom: 15px;
            padding-bottom: 5px;
            border-bottom: 2px solid #3b82f6;
        }
        .payment-table {
            width: 100%;
            border-collapse: collapse;
        }
        .payment-table th {
            background: #f3f4f6;
            padding: 8px 10px;
            text-align: left;
            font-size: 10px;
            font-weight: bold;
            color: #374151;
            border-bottom: 1px solid #d1d5db;
        }
        .payment-table td {
            padding: 8px 10px;
            border-bottom: 1px solid #e5e7eb;
            font-size: 11px;
        }
        .footer {
            margin-top: 40px;
            padding-top: 15px;
            border-top: 1px solid #e5e7eb;
            text-align: center;
            color: #9ca3af;
            font-size: 10px;
        }
        .signatures {
            display: table;
            width: 100%;
            margin-top: 50px;
        }
        .signature-box {
            display: table-cell;
            width: 33.33%;
            text-align: center;
            padding: 0 20px;
        }
        .signature-line {
            border-top: 1px solid #333;
            margin-top: 40px;
            padding-top: 8px;
            font-size: 11px;
            color: #666;
        }
        .notes-box {
            background: #f9fafb;
            border: 1px solid #e5e7eb;
            border-radius: 5px;
            padding: 15px;
            margin-bottom: 25px;
        }
        .notes-title {
            font-size: 11px;
            font-weight: bold;
            color: #6b7280;
            margin-bottom: 8px;
        }
        .notes-content {
            font-size: 11px;
            color: #374151;
        }
        .watermark {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 80px;
            font-weight: bold;
            color: rgba(16, 185, 129, 0.1);
            z-index: -1;
        }
    </style>
</head>
<body>
    @if($expense->payment_status === 'paid')
    <div class="watermark">PAID</div>
    @endif

    <!-- Header -->
    <div class="header">
        <div class="header-left">
            <div class="company-name">{{ config('app.name', 'EchoPx Technologies') }}</div>
            <div style="color: #6b7280; font-size: 11px;">Expense Reimbursement Report</div>
        </div>
        <div class="header-right">
            <div class="document-title">EXPENSE VOUCHER</div>
            <div class="expense-number">#{{ $expense->expense_number }}</div>
            <div class="status-badge {{ $expense->payment_status === 'paid' ? 'status-paid' : 'status-approved' }}">
                {{ strtoupper($expense->payment_status_label) }}
            </div>
        </div>
    </div>

    <!-- Info Section -->
    <div class="info-section">
        <div class="info-box">
            <div class="info-box-title">Employee Details</div>
            <div class="info-row">
                <div class="info-label">Name</div>
                <div class="info-value">{{ $expense->employee?->name ?? '-' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Email</div>
                <div class="info-value">{{ $expense->employee?->email ?? '-' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Manager</div>
                <div class="info-value">{{ $expense->manager?->name ?? '-' }}</div>
            </div>
        </div>
        <div class="info-box">
            <div class="info-box-title">Expense Details</div>
            <div class="info-row">
                <div class="info-label">Date</div>
                <div class="info-value">{{ $expense->expense_date?->format('d M Y') }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Category</div>
                <div class="info-value">{{ $expense->category?->name ?? '-' }}</div>
            </div>
            @if($expense->project_id)
            <div class="info-row">
                <div class="info-label">Project</div>
                <div class="info-value">{{ $expense->project_title ?? '-' }}</div>
            </div>
            @endif
            <div class="info-row">
                <div class="info-label">Paid By</div>
                <div class="info-value">{{ ucfirst($expense->paid_by) }}</div>
            </div>
        </div>
    </div>

    <!-- Expense Details Table -->
    <table class="details-table">
        <thead>
            <tr>
                <th style="width: 40%;">Description</th>
                <th style="width: 15%;">Unit Price</th>
                <th style="width: 15%;">Quantity</th>
                <th style="width: 15%;">Tax</th>
                <th style="width: 15%; text-align: right;">Amount</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>
                    <strong>{{ $expense->title }}</strong>
                    @if($expense->vendor)
                    <br><small style="color: #6b7280;">Vendor: {{ $expense->vendor }}</small>
                    @endif
                    @if($expense->reference_no)
                    <br><small style="color: #6b7280;">Ref: {{ $expense->reference_no }}</small>
                    @endif
                </td>
                <td>₹{{ number_format($expense->unit_price, 2) }}</td>
                <td>{{ number_format($expense->quantity, 2) }} {{ $expense->unit?->symbol ?? 'pcs' }}</td>
                <td>
                    @if($expense->tax_rate > 0)
                        {{ $expense->tax_rate }}% (₹{{ number_format($expense->tax_amount, 2) }})
                    @else
                        -
                    @endif
                </td>
                <td style="text-align: right;">₹{{ number_format($expense->amount, 2) }}</td>
            </tr>
        </tbody>
    </table>

    <!-- Amount Summary -->
    <div class="amount-section">
        <div class="amount-row">
            <div class="amount-label">Subtotal</div>
            <div class="amount-value">₹{{ number_format($expense->subtotal, 2) }}</div>
        </div>
        @if($expense->tax_amount > 0)
        <div class="amount-row">
            <div class="amount-label">Tax ({{ $expense->tax_rate }}%)</div>
            <div class="amount-value">₹{{ number_format($expense->tax_amount, 2) }}</div>
        </div>
        @endif
        <div class="amount-row total">
            <div class="amount-label">Total Amount</div>
            <div class="amount-value">₹{{ number_format($expense->amount, 2) }}</div>
        </div>
        <div class="amount-row paid">
            <div class="amount-label">Amount Paid</div>
            <div class="amount-value">₹{{ number_format($expense->total_paid, 2) }}</div>
        </div>
    </div>

    <!-- Notes -->
    @if($expense->notes)
    <div class="notes-box">
        <div class="notes-title">NOTES / REMARKS</div>
        <div class="notes-content">{{ $expense->notes }}</div>
    </div>
    @endif

    <!-- Payment History -->
    @if($expense->payments->count() > 0)
    <div class="payment-section">
        <div class="section-title">Payment History</div>
        <table class="payment-table">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Amount</th>
                    <th>Method</th>
                    <th>Reference</th>
                    <th>Processed By</th>
                </tr>
            </thead>
            <tbody>
                @foreach($expense->payments as $payment)
                <tr>
                    <td>{{ $payment->payment_date?->format('d M Y') }}</td>
                    <td>₹{{ number_format($payment->amount, 2) }}</td>
                    <td>{{ $payment->paymentMethod?->name ?? '-' }}</td>
                    <td>{{ $payment->transaction_id ?? $payment->payment_reference ?? '-' }}</td>
                    <td>{{ $payment->processedByAdmin?->name ?? '-' }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    @endif

    <!-- Approval Info -->
    <div class="info-section" style="margin-top: 20px;">
        <div class="info-box">
            <div class="info-box-title">Approval Information</div>
            <div class="info-row">
                <div class="info-label">Submitted</div>
                <div class="info-value">{{ $expense->submitted_at?->format('d M Y H:i') ?? '-' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Approved By</div>
                <div class="info-value">{{ $expense->approvedByAdmin?->name ?? '-' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Approved On</div>
                <div class="info-value">{{ $expense->approved_at?->format('d M Y H:i') ?? '-' }}</div>
            </div>
        </div>
        <div class="info-box">
            <div class="info-box-title">Payment Information</div>
            <div class="info-row">
                <div class="info-label">Payment Status</div>
                <div class="info-value">{{ ucfirst($expense->payment_status_label) }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Paid On</div>
                <div class="info-value">{{ $expense->paid_at?->format('d M Y H:i') ?? '-' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Processed By</div>
                <div class="info-value">{{ $expense->paidByAdmin?->name ?? '-' }}</div>
            </div>
        </div>
    </div>

    <!-- Signatures -->
    <div class="signatures">
        <div class="signature-box">
            <div class="signature-line">Employee Signature</div>
        </div>
        <div class="signature-box">
            <div class="signature-line">Manager Approval</div>
        </div>
        <div class="signature-box">
            <div class="signature-line">Finance Approval</div>
        </div>
    </div>

    <!-- Footer -->
    <div class="footer">
        Generated on {{ now()->format('d M Y H:i') }} | {{ config('app.name', 'EchoPx Technologies') }}
    </div>
</body>
</html>