<style>
    /* ========== EXPENSES PAGE DESIGN ========== */
    .exp-page { padding: 24px; max-width: 1400px; margin: 0 auto; }
    
    /* Header */
    .exp-header {
        display: flex;
        align-items: center;
        gap: 20px;
        margin-bottom: 24px;
        background: linear-gradient(135deg, #3b82f6, #6366f1);
        padding: 24px 32px;
        border-radius: 20px;
        position: relative;
        overflow: hidden;
    }
    .exp-header::before {
        content: '';
        position: absolute;
        top: -50%;
        right: -10%;
        width: 250px;
        height: 250px;
        background: rgba(255,255,255,0.1);
        border-radius: 50%;
    }
    .exp-header::after {
        content: '';
        position: absolute;
        bottom: -40%;
        left: 20%;
        width: 150px;
        height: 150px;
        background: rgba(255,255,255,0.05);
        border-radius: 50%;
    }
    .exp-header-icon {
        width: 56px;
        height: 56px;
        background: rgba(255,255,255,0.2);
        backdrop-filter: blur(10px);
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 1;
    }
    .exp-header-icon svg { width: 28px; height: 28px; color: #fff; }
    .exp-header-content { flex: 1; z-index: 1; }
    .exp-header h1 { font-size: 26px; font-weight: 800; color: #fff; margin: 0 0 4px 0; }
    .exp-header p { color: rgba(255,255,255,0.85); font-size: 14px; margin: 0; }
    .exp-header-actions { display: flex; gap: 12px; z-index: 1; flex-wrap: wrap; }
    .btn-new-exp {
        display: inline-flex;
        align-items: center;
        gap: 10px;
        background: #fff;
        color: #3b82f6;
        padding: 12px 24px;
        border-radius: 12px;
        text-decoration: none;
        font-weight: 700;
        font-size: 14px;
        transition: all 0.3s;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    }
    .btn-new-exp:hover { transform: translateY(-2px); box-shadow: 0 8px 25px rgba(0,0,0,0.15); }
    .btn-new-exp svg { width: 20px; height: 20px; }
    .btn-approval {
        display: inline-flex;
        align-items: center;
        gap: 10px;
        background: rgba(255,255,255,0.2);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255,255,255,0.3);
        color: #fff;
        padding: 12px 24px;
        border-radius: 12px;
        text-decoration: none;
        font-weight: 600;
        font-size: 14px;
        transition: all 0.3s;
    }
    .btn-approval:hover { background: rgba(255,255,255,0.3); }
    .btn-approval svg { width: 20px; height: 20px; }

    /* Stats Row */
    .exp-stats {
        display: flex;
        gap: 12px;
        margin-bottom: 24px;
        flex-wrap: wrap;
    }
    .exp-stat-card {
        flex: 1;
        min-width: 120px;
        background: var(--card-bg);
        border: 1px solid var(--card-border);
        border-radius: 14px;
        padding: 14px 16px;
        display: flex;
        align-items: center;
        gap: 12px;
        transition: all 0.3s;
        cursor: pointer;
    }
    .exp-stat-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 25px rgba(0,0,0,0.08);
    }
    .exp-stat-card.active {
        border-color: var(--primary);
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.15);
    }
    .exp-stat-icon {
        width: 40px;
        height: 40px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }
    .exp-stat-icon svg { width: 20px; height: 20px; color: #fff; }
    .exp-stat-icon.blue { background: linear-gradient(135deg, #3b82f6, #2563eb); }
    .exp-stat-icon.gray { background: linear-gradient(135deg, #6b7280, #4b5563); }
    .exp-stat-icon.orange { background: linear-gradient(135deg, #f59e0b, #d97706); }
    .exp-stat-icon.green { background: linear-gradient(135deg, #10b981, #059669); }
    .exp-stat-icon.red { background: linear-gradient(135deg, #ef4444, #dc2626); }
    .exp-stat-icon.purple { background: linear-gradient(135deg, #8b5cf6, #7c3aed); }
    .exp-stat-value { font-size: 20px; font-weight: 800; color: var(--text-primary); line-height: 1; }
    .exp-stat-label { font-size: 11px; color: var(--text-muted); margin-top: 3px; font-weight: 500; }

    /* Table Card */
    .exp-table-card {
        background: var(--card-bg);
        border: 1px solid var(--card-border);
        border-radius: 16px;
        overflow: hidden;
        box-shadow: 0 4px 20px rgba(0,0,0,0.04);
    }
    .exp-table-header {
        padding: 18px 24px;
        border-bottom: 1px solid var(--card-border);
        background: linear-gradient(to right, var(--body-bg), transparent);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 16px;
    }
    .exp-table-title-section {
        display: flex;
        align-items: center;
        gap: 12px;
    }
    .exp-table-icon {
        width: 40px;
        height: 40px;
        background: linear-gradient(135deg, #3b82f6, #6366f1);
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .exp-table-icon svg { width: 20px; height: 20px; color: #fff; }
    .exp-table-title { font-size: 16px; font-weight: 700; color: var(--text-primary); }
    .exp-table-subtitle { font-size: 12px; color: var(--text-muted); margin-top: 2px; }

    /* Filters */
    .exp-filter-section { display: flex; gap: 10px; align-items: center; flex-wrap: wrap; }
    .exp-filter-select {
        padding: 10px 14px;
        border: 1px solid var(--input-border);
        border-radius: 10px;
        font-size: 13px;
        font-weight: 500;
        background: var(--input-bg);
        color: var(--input-text);
        cursor: pointer;
        min-width: 140px;
        transition: all 0.2s;
    }
    .exp-filter-select:focus { outline: none; border-color: var(--primary); box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1); }

    /* Status badges */
    .exp-badge {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
    }
    .exp-badge-draft { background: rgba(107, 114, 128, 0.1); color: #6b7280; }
    .exp-badge-submitted { background: rgba(245, 158, 11, 0.1); color: #d97706; }
    .exp-badge-approved { background: rgba(16, 185, 129, 0.1); color: #059669; }
    .exp-badge-rejected { background: rgba(239, 68, 68, 0.1); color: #dc2626; }
    .exp-badge-paid { background: rgba(139, 92, 246, 0.1); color: #7c3aed; }
    .exp-badge-unpaid { background: rgba(239, 68, 68, 0.1); color: #dc2626; }
    .exp-badge-partially_paid { background: rgba(245, 158, 11, 0.1); color: #d97706; }

    /* Responsive */
    @media (max-width: 768px) {
        .exp-header { flex-direction: column; text-align: center; padding: 20px; }
        .exp-header-actions { width: 100%; justify-content: center; }
        .exp-stats { gap: 8px; }
        .exp-stat-card { min-width: 100px; padding: 12px; }
        .exp-stat-icon { width: 36px; height: 36px; }
        .exp-stat-value { font-size: 18px; }
        .exp-table-header { flex-direction: column; align-items: flex-start; }
    }
</style>

<div class="exp-page">
    <!-- Header -->
    <div class="exp-header">
        <div class="exp-header-icon">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 14l6-6m-5.5.5h.01m4.99 5h.01M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16l3.5-2 3.5 2 3.5-2 3.5 2z"></path></svg>
        </div>
        <div class="exp-header-content">
            <h1>Expenses</h1>
            <p>Manage and track all expense claims</p>
        </div>
        <div class="exp-header-actions">
            @if(auth('admin')->user()->hasRole('super-admin'))
            <a href="{{ route('admin.expense.approval.dashboard') }}" class="btn-approval">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"></path></svg>
                Approval Dashboard
            </a>
            @endif
            <a href="{{ route('admin.expense.create') }}" class="btn-new-exp">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M12 4v16m8-8H4"></path></svg>
                New Expense
            </a>
        </div>
    </div>

    <!-- Stats Row -->
    <div class="exp-stats">
        <div class="exp-stat-card active" data-filter="all" onclick="filterByStatus('')">
            <div class="exp-stat-icon blue">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 14l6-6m-5.5.5h.01m4.99 5h.01M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16l3.5-2 3.5 2 3.5-2 3.5 2z"></path></svg>
            </div>
            <div>
                <div class="exp-stat-value">{{ $stats['total'] }}</div>
                <div class="exp-stat-label">Total</div>
            </div>
        </div>
        <div class="exp-stat-card" data-filter="draft" onclick="filterByStatus('draft')">
            <div class="exp-stat-icon gray">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg>
            </div>
            <div>
                <div class="exp-stat-value">{{ $stats['draft'] }}</div>
                <div class="exp-stat-label">Draft</div>
            </div>
        </div>
        <div class="exp-stat-card" data-filter="submitted" onclick="filterByStatus('submitted')">
            <div class="exp-stat-icon orange">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
            </div>
            <div>
                <div class="exp-stat-value">{{ $stats['submitted'] }}</div>
                <div class="exp-stat-label">Pending</div>
            </div>
        </div>
        <div class="exp-stat-card" data-filter="approved" onclick="filterByStatus('approved')">
            <div class="exp-stat-icon green">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
            </div>
            <div>
                <div class="exp-stat-value">{{ $stats['approved'] }}</div>
                <div class="exp-stat-label">Approved</div>
            </div>
        </div>
        <div class="exp-stat-card" data-filter="rejected" onclick="filterByStatus('rejected')">
            <div class="exp-stat-icon red">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
            </div>
            <div>
                <div class="exp-stat-value">{{ $stats['rejected'] }}</div>
                <div class="exp-stat-label">Rejected</div>
            </div>
        </div>
        <div class="exp-stat-card" data-filter="paid" onclick="filterByStatus('paid')">
            <div class="exp-stat-icon purple">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
            </div>
            <div>
                <div class="exp-stat-value">{{ $stats['paid'] }}</div>
                <div class="exp-stat-label">Paid</div>
            </div>
        </div>
    </div>

    <!-- Table Card -->
    <div class="exp-table-card">
        <div class="exp-table-header">
            <div class="exp-table-title-section">
                <div class="exp-table-icon">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M4 6h16M4 10h16M4 14h16M4 18h16"></path></svg>
                </div>
                <div>
                    <div class="exp-table-title">Expense List</div>
                    <div class="exp-table-subtitle">All employee expense claims</div>
                </div>
            </div>
            
            <div class="exp-filter-section">
                <select class="exp-filter-select" id="statusFilter" data-dt-filter="status" data-dt-table="expenseTable">
                    <option value="">All Status</option>
                    <option value="draft">Draft</option>
                    <option value="submitted">Submitted</option>
                    <option value="approved">Approved</option>
                    <option value="rejected">Rejected</option>
                    <option value="paid">Paid</option>
                </select>
                <select class="exp-filter-select" id="paymentStatusFilter" data-dt-filter="payment_status" data-dt-table="expenseTable">
                    <option value="">All Payment</option>
                    <option value="unpaid">Unpaid</option>
                    <option value="partially_paid">Partial</option>
                    <option value="paid">Paid</option>
                </select>
            </div>
        </div>
        <div style="padding: 0;">
            <table id="expenseTable" 
                   class="dt-table dt-search dt-export dt-perpage dt-checkbox" 
                   data-route="{{ route('admin.expense.data') }}"
                   data-delete-route="{{ route('admin.expense.bulk-delete') }}">
                <thead>
                    <tr>
                        <th class="dt-sort" data-col="expense_number">Expense #</th>
                        <th class="dt-sort dt-clickable" data-col="title">Title</th>
                        <th data-col="category_name">Category</th>
                        <th data-col="employee_name">Employee</th>
                        <th class="dt-sort" data-col="amount" >Amount</th>
                        {{-- data-render="currency"  --}}
                        <th class="dt-sort" data-col="expense_date">Date</th>
                        <th class="dt-sort" data-col="status" data-render="expenseStatus">Status</th>
                        <th data-col="payment_status" data-render="paymentStatus">Payment</th>
                        <th data-render="actions">Actions</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>

@include('core::datatable')

<script>
    // Currency settings from database
    const currencySettings = {
        symbol: '{{ $currency->symbol ?? "₹" }}',
        decimalDigits: {{ $currency->decimal_digits ?? 2 }},
        decimalSeparator: '{{ $currency->decimal_separator ?? "." }}',
        thousandSeparator: '{{ $currency->thousand_separator ?? "," }}',
        symbolPosition: '{{ $currency->symbol_position ?? "before" }}',
        spaceBetween: {{ $currency->space_between ?? 0 }},
        showSymbol: true // Show currency symbol from database
    };

    window.dtRenders = window.dtRenders || {};
    
    // Currency renderer using database settings
    window.dtRenders.currency = function(value, row) {
        if (value === null || value === undefined || value === '') return '-';
        
        // Remove any existing currency symbols and commas
        var num = String(value).replace(/[₹$€£,\s]/g, '');
        var parsed = parseFloat(num);
        if (isNaN(parsed)) return '-';
        
        // Format using database currency settings
        var parts = parsed.toFixed(currencySettings.decimalDigits).split('.');
        parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, currencySettings.thousandSeparator);
        var formatted = parts.join(currencySettings.decimalSeparator);
        
        // Add currency symbol if enabled
        if (currencySettings.showSymbol) {
            var space = currencySettings.spaceBetween ? ' ' : '';
            if (currencySettings.symbolPosition === 'before') {
                return currencySettings.symbol + space + formatted;
            } else {
                return formatted + space + currencySettings.symbol;
            }
        }
        
        return formatted;
    };
    
    window.dtRenders.expenseStatus = function(value, row) {
        var badges = {
            'draft': 'exp-badge-draft',
            'submitted': 'exp-badge-submitted',
            'approved': 'exp-badge-approved',
            'rejected': 'exp-badge-rejected',
            'paid': 'exp-badge-paid'
        };
        var icons = {
            'draft': '<svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="width:12px;height:12px"><path d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg>',
            'submitted': '<svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="width:12px;height:12px"><path d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>',
            'approved': '<svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="width:12px;height:12px"><path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>',
            'rejected': '<svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="width:12px;height:12px"><path d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>',
            'paid': '<svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="width:12px;height:12px"><path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>'
        };
        var badge = badges[value] || 'exp-badge-draft';
        var icon = icons[value] || '';
        var label = row.status_label || value;
        return '<span class="exp-badge ' + badge + '">' + icon + ' ' + label + '</span>';
    };
    
    window.dtRenders.paymentStatus = function(value, row) {
        var badges = {
            'unpaid': 'exp-badge-unpaid',
            'partially_paid': 'exp-badge-partially_paid',
            'paid': 'exp-badge-paid'
        };
        var badge = badges[value] || 'exp-badge-unpaid';
        var label = row.payment_status_label || value;
        return '<span class="exp-badge ' + badge + '">' + label + '</span>';
    };
    
    function filterByStatus(status) {
        document.getElementById('statusFilter').value = status;
        var event = new Event('change', { bubbles: true });
        document.getElementById('statusFilter').dispatchEvent(event);
        
        document.querySelectorAll('.exp-stat-card').forEach(function(card) {
            card.classList.remove('active');
            if ((status === '' && card.dataset.filter === 'all') || card.dataset.filter === status) {
                card.classList.add('active');
            }
        });
    }
</script>
