<style>
    /* ========== MY EXPENSES PAGE DESIGN ========== */
    .my-exp-page { padding: 24px; max-width: 1400px; margin: 0 auto; }
    
    /* Header */
    .my-exp-header {
        display: flex;
        align-items: center;
        gap: 20px;
        margin-bottom: 24px;
        background: linear-gradient(135deg, #3b82f6, #8b5cf6);
        padding: 24px 32px;
        border-radius: 20px;
        position: relative;
        overflow: hidden;
    }
    .my-exp-header::before {
        content: '';
        position: absolute;
        top: -50%;
        right: -10%;
        width: 250px;
        height: 250px;
        background: rgba(255,255,255,0.1);
        border-radius: 50%;
    }
    .my-exp-header::after {
        content: '';
        position: absolute;
        bottom: -40%;
        left: 20%;
        width: 150px;
        height: 150px;
        background: rgba(255,255,255,0.05);
        border-radius: 50%;
    }
    .my-exp-header-icon {
        width: 56px;
        height: 56px;
        background: rgba(255,255,255,0.2);
        backdrop-filter: blur(10px);
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 1;
    }
    .my-exp-header-icon svg { width: 28px; height: 28px; color: #fff; }
    .my-exp-header-content { flex: 1; z-index: 1; }
    .my-exp-header h1 { font-size: 26px; font-weight: 800; color: #fff; margin: 0 0 4px 0; }
    .my-exp-header p { color: rgba(255,255,255,0.85); font-size: 14px; margin: 0; }
    .my-exp-header-actions { z-index: 1; }
    .btn-new-exp {
        display: inline-flex;
        align-items: center;
        gap: 10px;
        background: #fff;
        color: #3b82f6;
        padding: 12px 24px;
        border-radius: 12px;
        text-decoration: none;
        font-weight: 700;
        font-size: 14px;
        transition: all 0.3s;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    }
    .btn-new-exp:hover { transform: translateY(-2px); box-shadow: 0 8px 25px rgba(0,0,0,0.15); }
    .btn-new-exp svg { width: 20px; height: 20px; }

    /* Alert Messages */
    .my-exp-alert {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 14px 18px;
        border-radius: 12px;
        margin-bottom: 20px;
        font-size: 14px;
        font-weight: 500;
    }
    .my-exp-alert svg { width: 20px; height: 20px; flex-shrink: 0; }
    .my-exp-alert.success { background: linear-gradient(135deg, rgba(16, 185, 129, 0.1), rgba(5, 150, 105, 0.1)); border: 1px solid rgba(16, 185, 129, 0.3); color: #059669; }
    .my-exp-alert.error { background: linear-gradient(135deg, rgba(239, 68, 68, 0.1), rgba(220, 38, 38, 0.1)); border: 1px solid rgba(239, 68, 68, 0.3); color: #dc2626; }

    /* Stats Row */
    .my-exp-stats {
        display: flex;
        gap: 12px;
        margin-bottom: 24px;
        flex-wrap: wrap;
    }
    .my-stat-card {
        flex: 1;
        min-width: 130px;
        background: var(--card-bg);
        border: 1px solid var(--card-border);
        border-radius: 14px;
        padding: 16px;
        display: flex;
        align-items: center;
        gap: 14px;
        transition: all 0.3s;
        cursor: pointer;
    }
    .my-stat-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 25px rgba(0,0,0,0.08);
    }
    .my-stat-card.active {
        border-color: var(--primary);
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.15);
    }
    .my-stat-icon {
        width: 42px;
        height: 42px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }
    .my-stat-icon svg { width: 20px; height: 20px; color: #fff; }
    .my-stat-icon.blue { background: linear-gradient(135deg, #3b82f6, #2563eb); }
    .my-stat-icon.gray { background: linear-gradient(135deg, #6b7280, #4b5563); }
    .my-stat-icon.orange { background: linear-gradient(135deg, #f59e0b, #d97706); }
    .my-stat-icon.green { background: linear-gradient(135deg, #10b981, #059669); }
    .my-stat-icon.purple { background: linear-gradient(135deg, #8b5cf6, #7c3aed); }
    .my-stat-icon.teal { background: linear-gradient(135deg, #14b8a6, #0d9488); }
    .my-stat-value { font-size: 22px; font-weight: 800; color: var(--text-primary); line-height: 1; }
    .my-stat-label { font-size: 12px; color: var(--text-muted); margin-top: 4px; font-weight: 500; }

    /* Table Card */
    .my-exp-table-card {
        background: var(--card-bg);
        border: 1px solid var(--card-border);
        border-radius: 16px;
        overflow: hidden;
        box-shadow: 0 4px 20px rgba(0,0,0,0.04);
    }
    .my-exp-table-header {
        padding: 18px 24px;
        border-bottom: 1px solid var(--card-border);
        background: linear-gradient(to right, var(--body-bg), transparent);
        display: flex;
        align-items: center;
        gap: 12px;
    }
    .my-exp-table-icon {
        width: 40px;
        height: 40px;
        background: linear-gradient(135deg, #3b82f6, #6366f1);
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .my-exp-table-icon svg { width: 20px; height: 20px; color: #fff; }
    .my-exp-table-title { font-size: 16px; font-weight: 700; color: var(--text-primary); }
    .my-exp-table-subtitle { font-size: 12px; color: var(--text-muted); margin-top: 2px; }

    /* Status Badges */
    .exp-badge {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
    }
    .exp-badge-draft { background: rgba(107, 114, 128, 0.1); color: #6b7280; }
    .exp-badge-submitted { background: rgba(245, 158, 11, 0.1); color: #d97706; }
    .exp-badge-approved { background: rgba(16, 185, 129, 0.1); color: #059669; }
    .exp-badge-rejected { background: rgba(239, 68, 68, 0.1); color: #dc2626; }
    .exp-badge-paid { background: rgba(139, 92, 246, 0.1); color: #7c3aed; }

    /* Action Buttons */
    .exp-action-btn {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        padding: 6px 12px;
        border-radius: 6px;
        font-size: 12px;
        font-weight: 600;
        text-decoration: none;
        border: none;
        cursor: pointer;
        transition: all 0.2s;
        margin-right: 4px;
    }
    .exp-action-btn:last-child { margin-right: 0; }
    .exp-action-view { background: rgba(59, 130, 246, 0.1); color: #3b82f6; }
    .exp-action-view:hover { background: rgba(59, 130, 246, 0.2); }
    .exp-action-edit { background: rgba(245, 158, 11, 0.1); color: #d97706; }
    .exp-action-edit:hover { background: rgba(245, 158, 11, 0.2); }
    .exp-action-delete { background: rgba(239, 68, 68, 0.1); color: #dc2626; }
    .exp-action-delete:hover { background: rgba(239, 68, 68, 0.2); }
    .exp-action-submit { background: linear-gradient(135deg, #10b981, #059669); color: #fff; }
    .exp-action-submit:hover { transform: translateY(-1px); box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3); }

    /* Responsive */
    @media (max-width: 768px) {
        .my-exp-header { flex-direction: column; text-align: center; padding: 20px; }
        .my-exp-header-actions { width: 100%; }
        .btn-new-exp { width: 100%; justify-content: center; }
        .my-exp-stats { gap: 8px; }
        .my-stat-card { min-width: 100px; padding: 12px; }
        .my-stat-icon { width: 36px; height: 36px; }
        .my-stat-value { font-size: 18px; }
    }
</style>

<div class="my-exp-page">
    <!-- Alert Messages -->
    @if(session('success'))
        <div class="my-exp-alert success">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
            {{ session('success') }}
        </div>
    @endif
    @if(session('error'))
        <div class="my-exp-alert error">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
            {{ session('error') }}
        </div>
    @endif

    <!-- Header -->
    <div class="my-exp-header">
        <div class="my-exp-header-icon">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 14l6-6m-5.5.5h.01m4.99 5h.01M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16l3.5-2 3.5 2 3.5-2 3.5 2z"></path></svg>
        </div>
        <div class="my-exp-header-content">
            <h1>My Expenses</h1>
            <p>Track and manage your expense claims</p>
        </div>
        <div class="my-exp-header-actions">
            <a href="{{ route('admin.expense.create') }}" class="btn-new-exp">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M12 4v16m8-8H4"></path></svg>
                New Expense
            </a>
        </div>
    </div>

    <!-- Stats Row -->
    <div class="my-exp-stats">
        <div class="my-stat-card active" data-filter="all" onclick="filterMyExpenses('')">
            <div class="my-stat-icon blue">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 14l6-6m-5.5.5h.01m4.99 5h.01M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16l3.5-2 3.5 2 3.5-2 3.5 2z"></path></svg>
            </div>
            <div>
                <div class="my-stat-value">{{ $stats['total'] }}</div>
                <div class="my-stat-label">Total</div>
            </div>
        </div>
        <div class="my-stat-card" data-filter="draft" onclick="filterMyExpenses('draft')">
            <div class="my-stat-icon gray">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg>
            </div>
            <div>
                <div class="my-stat-value">{{ $stats['draft'] }}</div>
                <div class="my-stat-label">Draft</div>
            </div>
        </div>
        <div class="my-stat-card" data-filter="submitted" onclick="filterMyExpenses('submitted')">
            <div class="my-stat-icon orange">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
            </div>
            <div>
                <div class="my-stat-value">{{ $stats['submitted'] }}</div>
                <div class="my-stat-label">Pending</div>
            </div>
        </div>
        <div class="my-stat-card" data-filter="approved" onclick="filterMyExpenses('approved')">
            <div class="my-stat-icon green">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
            </div>
            <div>
                <div class="my-stat-value">{{ $stats['approved'] }}</div>
                <div class="my-stat-label">Approved</div>
            </div>
        </div>
        <div class="my-stat-card" data-filter="paid" onclick="filterMyExpenses('paid')">
            <div class="my-stat-icon purple">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
            </div>
            <div>
                <div class="my-stat-value">{{ $stats['paid'] }}</div>
                <div class="my-stat-label">Paid</div>
            </div>
        </div>
        <div class="my-stat-card">
            <div class="my-stat-icon teal">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
            </div>
            <div>
                <div class="my-stat-value">{{ $currency ? $currency->symbol : '₹' }}{{ number_format($stats['total_paid'], $currency ? $currency->decimal_digits : 2) }}</div>
                <div class="my-stat-label">Received</div>
            </div>
        </div>
    </div>

    <!-- Table Card -->
    <div class="my-exp-table-card">
        <div class="my-exp-table-header">
            <div class="my-exp-table-icon">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M4 6h16M4 10h16M4 14h16M4 18h16"></path></svg>
            </div>
            <div>
                <div class="my-exp-table-title">Expense List</div>
                <div class="my-exp-table-subtitle">Your submitted expense claims</div>
            </div>
        </div>
        <div style="padding: 0;">
            <table id="myExpenseTable" 
                   class="dt-table dt-search dt-perpage" 
                   data-route="{{ route('admin.expense.my.data') }}"
                   data-delete-route="{{ route('admin.expense.destroy', ':id') }}">
                <thead>
                    <tr>
                        <th data-col="expense_number">Expense #</th>
                        <th data-col="title">Title</th>
                        <th data-col="category_name">Category</th>
                        <th data-col="amount" >Amount</th>
                        {{-- data-render="currency" --}}
                        <th data-col="expense_date">Date</th>
                        <th data-col="status" data-render="myExpStatus">Status</th>
                        <th data-render="myActions">Actions</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>

@include('core::datatable')
<script>
// Currency settings from database
const currencySettings = {
    symbol: '{{ $currency->symbol ?? "₹" }}',
    decimalDigits: {{ $currency->decimal_digits ?? 2 }},
    decimalSeparator: '{{ $currency->decimal_separator ?? "." }}',
    thousandSeparator: '{{ $currency->thousand_separator ?? "," }}',
    symbolPosition: '{{ $currency->symbol_position ?? "before" }}',
    spaceBetween: {{ $currency->space_between ?? 0 }},
    showSymbol: true // Show currency symbol from database
};

window.dtRenders = window.dtRenders || {};

// Currency renderer using database settings
window.dtRenders.currency = function(value, row) {
    if (value === null || value === undefined || value === '') return '-';
    
    // Remove any existing currency symbols and commas
    var num = String(value).replace(/[₹$€£,\s]/g, '');
    var parsed = parseFloat(num);
    if (isNaN(parsed)) return '-';
    
    // Format using database currency settings
    var parts = parsed.toFixed(currencySettings.decimalDigits).split('.');
    parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, currencySettings.thousandSeparator);
    var formatted = parts.join(currencySettings.decimalSeparator);
    
    // Add currency symbol if enabled
    if (currencySettings.showSymbol) {
        var space = currencySettings.spaceBetween ? ' ' : '';
        if (currencySettings.symbolPosition === 'before') {
            return currencySettings.symbol + space + formatted;
        } else {
            return formatted + space + currencySettings.symbol;
        }
    }
    
    return formatted;
};

window.dtRenders.myExpStatus = function(v, r) {
    var badges = {
        'draft': 'exp-badge-draft',
        'submitted': 'exp-badge-submitted',
        'approved': 'exp-badge-approved',
        'rejected': 'exp-badge-rejected',
        'paid': 'exp-badge-paid'
    };
    var icons = {
        'draft': '<svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="width:14px;height:14px"><path d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg>',
        'submitted': '<svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="width:14px;height:14px"><path d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>',
        'approved': '<svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="width:14px;height:14px"><path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>',
        'rejected': '<svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="width:14px;height:14px"><path d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>',
        'paid': '<svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="width:14px;height:14px"><path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>'
    };
    var badge = badges[v] || 'exp-badge-draft';
    var icon = icons[v] || '';
    var label = r.status_label || v;
    return '<span class="exp-badge ' + badge + '">' + icon + ' ' + label + '</span>';
};

window.dtRenders.myActions = function(v, row) {
    var html = '<div style="display:flex;gap:4px;flex-wrap:wrap">';
    
    // View button
    html += '<a href="' + row._show_url + '" class="exp-action-btn exp-action-view">View</a>';
    
    // Edit only for draft
    if (row.status === 'draft') {
        html += '<a href="' + row._edit_url + '" class="exp-action-btn exp-action-edit">Edit</a>';
        html += '<button class="exp-action-btn exp-action-delete btn-delete-expense" data-id="' + row.id + '">Delete</button>';
        html += '<form action="{{ url("admin/expense") }}/' + row.id + '/submit" method="POST" style="display:inline;margin:0">';
        html += '@csrf';
        html += '<button type="submit" class="exp-action-btn exp-action-submit">Submit</button>';
        html += '</form>';
    }
    
    html += '</div>';
    return html;
};

// Filter function
function filterMyExpenses(status) {
    // Update active card
    document.querySelectorAll('.my-stat-card').forEach(function(card) {
        card.classList.remove('active');
        if ((status === '' && card.dataset.filter === 'all') || card.dataset.filter === status) {
            card.classList.add('active');
        }
    });
    
    // Trigger table filter if datatable supports it
    if (window.dtInstances && window.dtInstances['myExpenseTable']) {
        window.dtInstances['myExpenseTable'].filter('status', status);
    }
}

// Custom delete handler
document.addEventListener('click', function(e) {
    if (e.target.classList.contains('btn-delete-expense')) {
        var id = e.target.getAttribute('data-id');
        
        if (confirm('Are you sure you want to delete this expense? This action cannot be undone.')) {
            var form = document.createElement('form');
            form.method = 'POST';
            form.action = '/admin/expense/' + id;
            form.style.display = 'none';
            
            var csrf = document.createElement('input');
            csrf.type = 'hidden';
            csrf.name = '_token';
            csrf.value = '{{ csrf_token() }}';
            form.appendChild(csrf);
            
            var method = document.createElement('input');
            method.type = 'hidden';
            method.name = '_method';
            method.value = 'DELETE';
            form.appendChild(method);
            
            document.body.appendChild(form);
            form.submit();
        }
    }
});
</script>