<style>
    .payment-page { max-width: 700px; margin: 0 auto; padding: 20px; }
    .payment-header { display: flex; align-items: center; gap: 16px; margin-bottom: 24px; }
    .btn-back { width: 40px; height: 40px; display: flex; align-items: center; justify-content: center; background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 10px; color: var(--text-secondary); text-decoration: none; }
    .payment-header h1 { font-size: 24px; font-weight: 700; color: var(--text-primary); margin: 0; }
    
    .expense-summary { background: linear-gradient(135deg, var(--primary), var(--primary-hover)); color: #fff; padding: 24px; border-radius: 12px; margin-bottom: 24px; }
    .expense-summary-title { font-size: 18px; font-weight: 600; margin-bottom: 16px; }
    .expense-summary-row { display: flex; justify-content: space-between; padding: 8px 0; border-bottom: 1px solid rgba(255,255,255,0.2); }
    .expense-summary-row:last-child { border-bottom: none; font-size: 20px; font-weight: 700; padding-top: 16px; margin-top: 8px; }
    
    .form-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; }
    .form-card-header { padding: 16px 20px; border-bottom: 1px solid var(--card-border); }
    .form-card-title { font-size: 16px; font-weight: 600; color: var(--text-primary); margin: 0; }
    .form-card-body { padding: 20px; }
    
    .form-group { margin-bottom: 20px; }
    .form-label { display: block; font-size: 14px; font-weight: 600; color: var(--text-primary); margin-bottom: 8px; }
    .form-input, .form-select, .form-textarea { width: 100%; padding: 12px 16px; font-size: 14px; background: var(--input-bg); border: 1px solid var(--input-border); border-radius: 10px; color: var(--input-text); }
    .form-row-2 { display: grid; grid-template-columns: repeat(2, 1fr); gap: 16px; }
    
    .form-actions { display: flex; gap: 12px; padding: 20px; background: var(--body-bg); border-top: 1px solid var(--card-border); }
    .btn-submit { display: inline-flex; align-items: center; gap: 8px; padding: 12px 24px; background: #8b5cf6; color: #fff; border: none; border-radius: 10px; font-size: 14px; font-weight: 600; cursor: pointer; }
    .btn-cancel { display: inline-flex; align-items: center; padding: 12px 24px; background: var(--card-bg); color: var(--text-secondary); border: 1px solid var(--card-border); border-radius: 10px; font-size: 14px; font-weight: 600; text-decoration: none; }
    
    .payment-history { margin-top: 24px; }
    .payment-item { display: flex; justify-content: space-between; align-items: center; padding: 12px 16px; background: var(--body-bg); border-radius: 8px; margin-bottom: 8px; }
    .payment-item-info { font-size: 13px; color: var(--text-muted); }
    .payment-item-amount { font-size: 15px; font-weight: 600; color: var(--success); }
</style>

<div class="payment-page">
    <div class="payment-header">
        <a href="{{ route('admin.expense.approval.dashboard') }}" class="btn-back">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="width:20px;height:20px"><path d="M15 19l-7-7 7-7"></path></svg>
        </a>
        <h1>Process Payment</h1>
    </div>

    <div class="expense-summary">
        <div class="expense-summary-title">{{ $expense->title }} <small>#{{ $expense->expense_number }}</small></div>
        <div class="expense-summary-row">
            <span>Total Amount</span>
            <span>₹{{ number_format($expense->amount, 2) }}</span>
        </div>
        <div class="expense-summary-row">
            <span>Already Paid</span>
            <span>₹{{ number_format($expense->total_paid, 2) }}</span>
        </div>
        <div class="expense-summary-row">
            <span>Remaining Balance</span>
            <span>₹{{ number_format($expense->remaining_balance, 2) }}</span>
        </div>
    </div>

    <div class="form-card">
        <div class="form-card-header">
            <h2 class="form-card-title">Payment Details</h2>
        </div>
        <form action="{{ route('admin.expense.payment.process', $expense->id) }}" method="POST">
            @csrf
            <div class="form-card-body">
                <div class="form-row-2">
                    <div class="form-group">
                        <label class="form-label">Amount *</label>
                        <input type="number" name="amount" class="form-input" value="{{ $expense->remaining_balance }}" step="0.01" min="0.01" max="{{ $expense->remaining_balance }}" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Payment Date *</label>
                        <input type="date" name="payment_date" class="form-input" value="{{ date('Y-m-d') }}" required>
                    </div>
                </div>
                <div class="form-row-2">
                    <div class="form-group">
                        <label class="form-label">Payment Method *</label>
                        <select name="payment_method_id" class="form-select" required>
                            <option value="">Select Method</option>
                            @foreach($paymentMethods as $method)
                            <option value="{{ $method->id }}">{{ $method->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Transaction ID</label>
                        <input type="text" name="transaction_id" class="form-input" placeholder="Optional">
                    </div>
                </div>
                <div class="form-group">
                    <label class="form-label">Bank Details</label>
                    <input type="text" name="bank_details" class="form-input" placeholder="Account/IFSC details (optional)">
                </div>
                <div class="form-group">
                    <label class="form-label">Note</label>
                    <textarea name="note" class="form-input" rows="2" placeholder="Optional payment note"></textarea>
                </div>
            </div>
            <div class="form-actions">
                <button type="submit" class="btn-submit">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="width:18px;height:18px"><path d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                    Process Payment
                </button>
                <a href="{{ route('admin.expense.approval.dashboard') }}" class="btn-cancel">Cancel</a>
            </div>
        </form>
    </div>

    @if($expense->payments->count() > 0)
    <div class="payment-history">
        <h3 style="font-size: 16px; font-weight: 600; margin-bottom: 12px;">Previous Payments</h3>
        @foreach($expense->payments as $payment)
        <div class="payment-item">
            <div>
                <div style="font-weight: 600; color: var(--text-primary);">{{ $payment->payment_reference }}</div>
                <div class="payment-item-info">{{ $payment->payment_date?->format('d M Y') }} • {{ $payment->paymentMethod?->name ?? 'N/A' }}</div>
            </div>
            <div class="payment-item-amount">₹{{ number_format($payment->amount, 2) }}</div>
        </div>
        @endforeach
    </div>
    @endif
</div>
