<style>
    .expense-view { max-width: 1000px; margin: 0 auto; padding: 20px; }
    .view-header { display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 24px; flex-wrap: wrap; gap: 16px; }
    .view-header-left { display: flex; align-items: center; gap: 16px; }
    .btn-back { width: 40px; height: 40px; display: flex; align-items: center; justify-content: center; background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 10px; color: var(--text-secondary); text-decoration: none; }
    .btn-back:hover { background: var(--body-bg); color: var(--text-primary); }
    .view-title h1 { font-size: 24px; font-weight: 700; color: var(--text-primary); margin: 0 0 4px 0; }
    .view-title p { font-size: 14px; color: var(--text-muted); margin: 0; }
    .header-actions { display: flex; gap: 10px; flex-wrap: wrap; }
    .btn-action { display: inline-flex; align-items: center; gap: 6px; padding: 10px 16px; border-radius: 8px; font-size: 13px; font-weight: 600; text-decoration: none; border: none; cursor: pointer; transition: all 0.2s; }
    .btn-action svg { width: 16px; height: 16px; }
    .btn-edit { background: var(--card-bg); border: 1px solid var(--card-border); color: var(--text-primary); }
    .btn-edit:hover { background: var(--body-bg); }
    .btn-submit { background: var(--primary); color: #fff; }
    .btn-submit:hover { background: var(--primary-hover); }
    .btn-approve { background: var(--success); color: #fff; }
    .btn-approve:hover { opacity: 0.9; }
    .btn-reject { background: var(--danger); color: #fff; }
    .btn-reject:hover { opacity: 0.9; }
    .btn-pay { background: linear-gradient(135deg, #8b5cf6, #7c3aed); color: #fff; }
    .btn-pay:hover { opacity: 0.9; }
    .btn-print { background: linear-gradient(135deg, #f59e0b, #d97706); color: #fff; }
    .btn-print:hover { opacity: 0.9; }
    .btn-view-pdf { background: linear-gradient(135deg, #6366f1, #4f46e5); color: #fff; }
    .btn-view-pdf:hover { opacity: 0.9; }

    .status-badges { display: flex; gap: 8px; margin-top: 12px; }
    .status-badge { display: inline-flex; align-items: center; gap: 6px; padding: 6px 12px; border-radius: 20px; font-size: 12px; font-weight: 600; }
    .status-badge svg { width: 14px; height: 14px; }
    .badge-draft { background: rgba(107, 114, 128, 0.1); color: #6b7280; }
    .badge-submitted { background: rgba(59, 130, 246, 0.1); color: #3b82f6; }
    .badge-approved { background: rgba(16, 185, 129, 0.1); color: #10b981; }
    .badge-rejected { background: rgba(239, 68, 68, 0.1); color: #ef4444; }
    .badge-paid { background: rgba(139, 92, 246, 0.1); color: #8b5cf6; }
    .badge-unpaid { background: rgba(239, 68, 68, 0.1); color: #ef4444; }
    .badge-partially_paid { background: rgba(245, 158, 11, 0.1); color: #f59e0b; }

    .view-grid { display: grid; grid-template-columns: 2fr 1fr; gap: 20px; }
    @media (max-width: 900px) { .view-grid { grid-template-columns: 1fr; } }

    .view-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; margin-bottom: 20px; }
    .view-card-header { padding: 16px 20px; border-bottom: 1px solid var(--card-border); display: flex; justify-content: space-between; align-items: center; }
    .view-card-title { font-size: 15px; font-weight: 600; color: var(--text-primary); display: flex; align-items: center; gap: 8px; }
    .view-card-title svg { width: 18px; height: 18px; color: var(--primary); }
    .view-card-body { padding: 20px; }

    .detail-row { display: flex; padding: 12px 0; border-bottom: 1px solid var(--card-border); }
    .detail-row:last-child { border-bottom: none; }
    .detail-label { width: 140px; font-size: 13px; color: var(--text-muted); flex-shrink: 0; }
    .detail-value { font-size: 14px; color: var(--text-primary); font-weight: 500; }

    .amount-summary { background: linear-gradient(135deg, var(--primary), var(--primary-hover)); border-radius: 12px; padding: 20px; color: #fff; }
    .amount-summary-title { font-size: 13px; opacity: 0.8; margin-bottom: 8px; }
    .amount-summary-value { font-size: 32px; font-weight: 700; margin-bottom: 16px; }
    .amount-summary-details { display: grid; grid-template-columns: 1fr 1fr; gap: 12px; padding-top: 16px; border-top: 1px solid rgba(255,255,255,0.2); }
    .amount-detail { text-align: center; }
    .amount-detail-value { font-size: 18px; font-weight: 600; }
    .amount-detail-label { font-size: 11px; opacity: 0.8; margin-top: 4px; }

    .timeline { padding: 0; margin: 0; list-style: none; }
    .timeline-item { position: relative; padding-left: 28px; padding-bottom: 20px; }
    .timeline-item:last-child { padding-bottom: 0; }
    .timeline-item:before { content: ''; position: absolute; left: 7px; top: 24px; bottom: 0; width: 2px; background: var(--card-border); }
    .timeline-item:last-child:before { display: none; }
    .timeline-dot { position: absolute; left: 0; top: 4px; width: 16px; height: 16px; border-radius: 50%; background: var(--primary); display: flex; align-items: center; justify-content: center; }
    .timeline-dot svg { width: 10px; height: 10px; color: #fff; }
    .timeline-dot.success { background: var(--success); }
    .timeline-dot.danger { background: var(--danger); }
    .timeline-dot.warning { background: #f59e0b; }
    .timeline-content { font-size: 14px; color: var(--text-primary); }
    .timeline-meta { font-size: 12px; color: var(--text-muted); margin-top: 4px; }

    .attachment-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(150px, 1fr)); gap: 12px; }
    .attachment-item { background: var(--body-bg); border: 1px solid var(--card-border); border-radius: 10px; padding: 16px; text-align: center; transition: all 0.2s; }
    .attachment-item:hover { border-color: var(--primary); }
    .attachment-icon { width: 48px; height: 48px; margin: 0 auto 12px; background: var(--primary-light); border-radius: 12px; display: flex; align-items: center; justify-content: center; }
    .attachment-icon svg { width: 24px; height: 24px; color: var(--primary); }
    .attachment-icon.image { background: rgba(236, 72, 153, 0.1); }
    .attachment-icon.image svg { color: #ec4899; }
    .attachment-name { font-size: 12px; color: var(--text-primary); font-weight: 500; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
    .attachment-size { font-size: 11px; color: var(--text-muted); margin-top: 4px; }
    .attachment-link { display: inline-block; margin-top: 8px; font-size: 12px; color: var(--primary); text-decoration: none; }

    .rejection-box { background: rgba(239, 68, 68, 0.1); border: 1px solid rgba(239, 68, 68, 0.2); border-radius: 10px; padding: 16px; margin-bottom: 20px; }
    .rejection-box-title { font-size: 14px; font-weight: 600; color: var(--danger); margin-bottom: 8px; display: flex; align-items: center; gap: 8px; }
    .rejection-box-title svg { width: 18px; height: 18px; }
    .rejection-box p { font-size: 14px; color: var(--text-primary); margin: 0; }

    .payment-table { width: 100%; border-collapse: collapse; }
    .payment-table th, .payment-table td { padding: 12px; text-align: left; border-bottom: 1px solid var(--card-border); font-size: 13px; }
    .payment-table th { font-weight: 600; color: var(--text-muted); background: var(--body-bg); }
    .payment-table td { color: var(--text-primary); }

    /* Reject Modal */
    .modal-overlay { position: fixed; inset: 0; background: rgba(0,0,0,0.5); display: none; align-items: center; justify-content: center; z-index: 1000; }
    .modal-overlay.show { display: flex; }
    .modal-box { background: var(--card-bg); border-radius: 16px; width: 100%; max-width: 480px; margin: 20px; }
    .modal-header { padding: 20px; border-bottom: 1px solid var(--card-border); display: flex; justify-content: space-between; align-items: center; }
    .modal-title { font-size: 18px; font-weight: 600; color: var(--text-primary); }
    .modal-close { background: none; border: none; font-size: 24px; color: var(--text-muted); cursor: pointer; }
    .modal-body { padding: 20px; }
    .modal-footer { padding: 20px; border-top: 1px solid var(--card-border); display: flex; gap: 12px; justify-content: flex-end; }
</style>

<div class="expense-view">
    <div class="view-header">
        <div class="view-header-left">
            <a href="{{ route('admin.expense.index') }}" class="btn-back">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M15 19l-7-7 7-7"></path></svg>
            </a>
            <div class="view-title">
                <h1>{{ $expense->title }}</h1>
                <p>{{ $expense->expense_number }} • {{ $expense->expense_date->format('d M Y') }}</p>
                <div class="status-badges">
                    <span class="status-badge badge-{{ $expense->status }}">
                        {{ $expense->status_label }}
                    </span>
                    <span class="status-badge badge-{{ $expense->payment_status }}">
                        {{ $expense->payment_status_label }}
                    </span>
                </div>
            </div>
        </div>
        <div class="header-actions">
            @if($expense->canBeEdited())
                <a href="{{ route('admin.expense.edit', $expense->id) }}" class="btn-action btn-edit">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg>
                    Edit
                </a>
            @endif
            @if($expense->canBeSubmitted())
                <form action="{{ route('admin.expense.submit', $expense->id) }}" method="POST" style="display:inline">
                    @csrf
                    <button type="submit" class="btn-action btn-submit">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"></path></svg>
                        Submit for Approval
                    </button>
                </form>
            @endif
            @can('expense.approve')
                @if($expense->canBeApproved())
                    <form action="{{ route('admin.expense.approve', $expense->id) }}" method="POST" style="display:inline">
                        @csrf
                        <button type="submit" class="btn-action btn-approve">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M5 13l4 4L19 7"></path></svg>
                            Approve
                        </button>
                    </form>
                    <button type="button" class="btn-action btn-reject" onclick="showRejectModal()">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M6 18L18 6M6 6l12 12"></path></svg>
                        Reject
                    </button>
                @endif
            @endcan
            @can('expense.pay')
                @if($expense->canBePaid())
                    <a href="{{ route('admin.expense.payment.form', $expense->id) }}" class="btn-action btn-pay">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                        Process Payment
                    </a>
                @endif
            @endcan
            
            {{-- PDF Print Button - Show for approved/paid expenses --}}
            @if(in_array($expense->status, ['approved', 'paid']))
                <a href="{{ route('admin.expense.pdf', $expense->id) }}" class="btn-action btn-print" title="Download PDF">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path></svg>
                    Download PDF
                </a>
                <a href="{{ route('admin.expense.pdf.view', $expense->id) }}" target="_blank" class="btn-action btn-view-pdf" title="View PDF">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path><path d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path></svg>
                    View PDF
                </a>
            @endif
        </div>
    </div>

    @if($expense->status === 'rejected' && $expense->rejection_reason)
        <div class="rejection-box">
            <div class="rejection-box-title">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path></svg>
                Rejection Reason
            </div>
            <p>{{ $expense->rejection_reason }}</p>
        </div>
    @endif

    <div class="view-grid">
        <div class="view-main">
            <!-- Expense Details -->
            <div class="view-card">
                <div class="view-card-header">
                    <div class="view-card-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 14l6-6m-5.5.5h.01m4.99 5h.01M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16l3.5-2 3.5 2 3.5-2 3.5 2z"></path></svg>
                        Expense Details
                    </div>
                </div>
                <div class="view-card-body">
                    <div class="detail-row">
                        <div class="detail-label">Category</div>
                        <div class="detail-value">{{ $expense->category?->name ?? '-' }}</div>
                    </div>
                    @if($expense->project_id)
                    <div class="detail-row">
                        <div class="detail-label">Project</div>
                        <div class="detail-value">{{ $expense->project_title ?? '-' }}</div>
                    </div>
                    @endif
                    <div class="detail-row">
                        <div class="detail-label">Unit Price</div>
                        <div class="detail-value">₹{{ number_format($expense->unit_price, 2) }}</div>
                    </div>
                    <div class="detail-row">
                        <div class="detail-label">Quantity</div>
                        <div class="detail-value">{{ number_format($expense->quantity, 2) }} {{ $expense->unit?->symbol ?? 'pcs' }}</div>
                    </div>
                    <div class="detail-row">
                        <div class="detail-label">Subtotal</div>
                        <div class="detail-value">₹{{ number_format($expense->subtotal, 2) }}</div>
                    </div>
                    @if($expense->tax_amount > 0)
                    <div class="detail-row">
                        <div class="detail-label">Tax ({{ $expense->tax_rate }}%)</div>
                        <div class="detail-value">₹{{ number_format($expense->tax_amount, 2) }}</div>
                    </div>
                    @endif
                    <div class="detail-row">
                        <div class="detail-label">Vendor</div>
                        <div class="detail-value">{{ $expense->vendor ?? '-' }}</div>
                    </div>
                    <div class="detail-row">
                        <div class="detail-label">Reference No.</div>
                        <div class="detail-value">{{ $expense->reference_no ?? '-' }}</div>
                    </div>
                    <div class="detail-row">
                        <div class="detail-label">Paid By</div>
                        <div class="detail-value">{{ ucfirst($expense->paid_by) }}</div>
                    </div>
                    @if($expense->notes)
                    <div class="detail-row">
                        <div class="detail-label">Notes</div>
                        <div class="detail-value">{{ $expense->notes }}</div>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Assignment -->
            <div class="view-card">
                <div class="view-card-header">
                    <div class="view-card-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                        Assignment
                    </div>
                </div>
                <div class="view-card-body">
                    <div class="detail-row">
                        <div class="detail-label">Employee</div>
                        <div class="detail-value">{{ $expense->employee?->name ?? '-' }}</div>
                    </div>
                    <div class="detail-row">
                        <div class="detail-label">Manager</div>
                        <div class="detail-value">{{ $expense->manager?->name ?? '-' }}</div>
                    </div>
                    <div class="detail-row">
                        <div class="detail-label">Created By</div>
                        <div class="detail-value">{{ $expense->createdByAdmin?->name ?? '-' }}</div>
                    </div>
                    @if($expense->approved_by)
                    <div class="detail-row">
                        <div class="detail-label">{{ $expense->status === 'rejected' ? 'Rejected By' : 'Approved By' }}</div>
                        <div class="detail-value">{{ $expense->approvedByAdmin?->name ?? '-' }} <span style="color: var(--text-muted); font-size: 12px;">{{ $expense->approved_at?->format('d M Y H:i') }}</span></div>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Attachments -->
            @if($expense->attachments->count() > 0)
            <div class="view-card">
                <div class="view-card-header">
                    <div class="view-card-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"></path></svg>
                        Attachments ({{ $expense->attachments->count() }})
                    </div>
                </div>
                <div class="view-card-body">
                    <div class="attachment-grid">
                        @foreach($expense->attachments as $attachment)
                        <div class="attachment-item">
                            <div class="attachment-icon {{ $attachment->is_image ? 'image' : '' }}">
                                @if($attachment->is_image)
                                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                                @else
                                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                                @endif
                            </div>
                            <div class="attachment-name" title="{{ $attachment->original_name }}">{{ $attachment->original_name }}</div>
                            <div class="attachment-size">{{ $attachment->formatted_file_size }}</div>
                            <a href="{{ route('admin.expense.attachment.download', $attachment->id) }}" target="_blank" class="attachment-link">View</a>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
            @endif

            <!-- Payments -->
            @if($expense->payments->count() > 0)
            <div class="view-card">
                <div class="view-card-header">
                    <div class="view-card-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2z"></path></svg>
                        Payment History
                    </div>
                </div>
                <div class="view-card-body" style="padding: 0;">
                    <table class="payment-table">
                        <thead>
                            <tr>
                                <th>Reference</th>
                                <th>Date</th>
                                <th>Method</th>
                                <th>Amount</th>
                                <th>Processed By</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($expense->payments as $payment)
                            <tr>
                                <td>{{ $payment->payment_reference }}</td>
                                <td>{{ $payment->payment_date->format('d M Y') }}</td>
                                <td>{{ $payment->paymentMethod?->name ?? '-' }}</td>
                                <td style="font-weight: 600; color: var(--success);">₹{{ number_format($payment->amount, 2) }}</td>
                                <td>{{ $payment->createdByAdmin?->name ?? '-' }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            @endif
        </div>

        <div class="view-sidebar">
            <!-- Amount Summary -->
            <div class="amount-summary">
                <div class="amount-summary-title">Total Amount</div>
                <div class="amount-summary-value">₹{{ number_format($expense->amount, 2) }}</div>
                <div class="amount-summary-details">
                    <div class="amount-detail">
                        <div class="amount-detail-value">₹{{ number_format($expense->total_paid, 2) }}</div>
                        <div class="amount-detail-label">Paid</div>
                    </div>
                    <div class="amount-detail">
                        <div class="amount-detail-value">₹{{ number_format($expense->remaining_balance, 2) }}</div>
                        <div class="amount-detail-label">Balance</div>
                    </div>
                </div>
            </div>

            <!-- Activity Timeline -->
            <div class="view-card" style="margin-top: 20px;">
                <div class="view-card-header">
                    <div class="view-card-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                        Activity
                    </div>
                </div>
                <div class="view-card-body">
                    <ul class="timeline">
                        @forelse($expense->activityLogs->take(10) as $log)
                        <li class="timeline-item">
                            <div class="timeline-dot {{ $log->action_color }}">
                                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M5 13l4 4L19 7"></path></svg>
                            </div>
                            <div class="timeline-content">{{ $log->action_label }}</div>
                            <div class="timeline-meta">
                                {{ $log->createdByAdmin?->name ?? 'System' }} • {{ $log->created_at->diffForHumans() }}
                            </div>
                        </li>
                        @empty
                        <li class="timeline-item">
                            <div class="timeline-content" style="color: var(--text-muted);">No activity yet</div>
                        </li>
                        @endforelse
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Reject Modal -->
<div class="modal-overlay" id="rejectModal">
    <div class="modal-box">
        <div class="modal-header">
            <div class="modal-title">Reject Expense</div>
            <button class="modal-close" onclick="hideRejectModal()">&times;</button>
        </div>
        <form action="{{ route('admin.expense.reject', $expense->id) }}" method="POST">
            @csrf
            <div class="modal-body">
                <div class="form-group" style="margin-bottom: 0;">
                    <label class="form-label">Reason for Rejection <span style="color: var(--danger);">*</span></label>
                    <textarea name="rejection_reason" class="form-textarea" style="min-height: 120px;" placeholder="Please provide a reason for rejection..." required></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn-action btn-edit" onclick="hideRejectModal()">Cancel</button>
                <button type="submit" class="btn-action btn-reject">Reject Expense</button>
            </div>
        </form>
    </div>
</div>

<script>
function showRejectModal() {
    document.getElementById('rejectModal').classList.add('show');
}
function hideRejectModal() {
    document.getElementById('rejectModal').classList.remove('show');
}
document.getElementById('rejectModal').addEventListener('click', function(e) {
    if (e.target === this) hideRejectModal();
});
</script>
