<?php

use Illuminate\Support\Facades\Route;
use Modules\Expense\Http\Controllers\ExpenseController;
use Modules\Expense\Http\Controllers\ExpenseApprovalController;
use Modules\Expense\Http\Controllers\ExpenseCategoryController;
use App\Http\Middleware\EnsureIsAdmin;

Route::prefix('admin/expense')
    ->middleware([EnsureIsAdmin::class])
    ->name('admin.expense.')
    ->group(function () {
        
        // ==================== MAIN EXPENSE ROUTES ====================
        Route::get('/', [ExpenseController::class, 'index'])->name('index');
        Route::match(['get', 'post'], '/data', [ExpenseController::class, 'dataTable'])->name('data');
        Route::post('/bulk-delete', [ExpenseController::class, 'bulkDelete'])->name('bulk-delete');
        
        Route::get('/create', [ExpenseController::class, 'create'])->name('create');
        Route::post('/', [ExpenseController::class, 'store'])->name('store');
        Route::get('/{id}', [ExpenseController::class, 'show'])->name('show')->where('id', '[0-9]+');
        Route::get('/{id}/pdf', [ExpenseController::class, 'generatePdf'])->name('pdf')->where('id', '[0-9]+');
        Route::get('/{id}/pdf/view', [ExpenseController::class, 'viewPdf'])->name('pdf.view')->where('id', '[0-9]+');
        Route::get('/{id}/edit', [ExpenseController::class, 'edit'])->name('edit')->where('id', '[0-9]+');
        Route::put('/{id}', [ExpenseController::class, 'update'])->name('update')->where('id', '[0-9]+');
        Route::delete('/{id}', [ExpenseController::class, 'destroy'])->name('destroy')->where('id', '[0-9]+');
        
        // ==================== APPROVAL ROUTES ====================
        Route::prefix('approval')->name('approval.')->group(function () {
            Route::get('/', [ExpenseApprovalController::class, 'dashboard'])->name('dashboard');
            Route::post('/bulk', [ExpenseApprovalController::class, 'bulkApprove'])->name('bulk');
        });
        
        // Expense workflow actions
        Route::post('/{id}/submit', [ExpenseApprovalController::class, 'submit'])->name('submit')->where('id', '[0-9]+');
        Route::post('/{id}/approve', [ExpenseApprovalController::class, 'approve'])->name('approve')->where('id', '[0-9]+');
        Route::post('/{id}/reject', [ExpenseApprovalController::class, 'reject'])->name('reject')->where('id', '[0-9]+');
        
        // ==================== PAYMENT ROUTES ====================
        Route::prefix('payment')->name('payment.')->group(function () {
            Route::get('/{id}', [ExpenseApprovalController::class, 'paymentForm'])->name('form')->where('id', '[0-9]+');
            Route::post('/{id}', [ExpenseApprovalController::class, 'processPayment'])->name('process')->where('id', '[0-9]+');
            Route::post('/quick', [ExpenseApprovalController::class, 'quickPay'])->name('quick');
            Route::get('/{id}/history', [ExpenseApprovalController::class, 'paymentHistory'])->name('history')->where('id', '[0-9]+');
        });
        
        // ==================== MY EXPENSES ROUTES ====================
        Route::prefix('my')->name('my.')->group(function () {
            Route::get('/', [ExpenseApprovalController::class, 'myExpenses'])->name('index');
            Route::get('/data', [ExpenseApprovalController::class, 'myExpensesData'])->name('data');
        });
        
        // ==================== CATEGORY ROUTES ====================
        Route::prefix('categories')->name('categories.')->group(function () {
            Route::get('/', [ExpenseCategoryController::class, 'index'])->name('index');
            Route::get('/data', [ExpenseCategoryController::class, 'dataTable'])->name('data');
            Route::get('/search', [ExpenseCategoryController::class, 'search'])->name('search');
            
            Route::get('/create', [ExpenseCategoryController::class, 'create'])->name('create');
            Route::post('/', [ExpenseCategoryController::class, 'store'])->name('store');
            Route::get('/{id}/edit', [ExpenseCategoryController::class, 'edit'])->name('edit');
            Route::put('/{id}', [ExpenseCategoryController::class, 'update'])->name('update');
            Route::delete('/{id}', [ExpenseCategoryController::class, 'destroy'])->name('destroy');
            Route::post('/{id}/toggle-status', [ExpenseCategoryController::class, 'toggleStatus'])->name('toggle-status');
        });
        
        // ==================== ATTACHMENT ROUTES ====================
        Route::get('/attachment/{id}/download', [ExpenseController::class, 'downloadAttachment'])->name('attachment.download');
        Route::delete('/attachment/{id}', [ExpenseController::class, 'deleteAttachment'])->name('attachment.delete');
    });
