<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        // If table already exists (from Inventory or other module), skip creation
        if (Schema::hasTable('products')) {
            return;
        }

        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name', 191);
            $table->string('sku', 100)->unique();
            $table->text('description')->nullable();
            $table->decimal('purchase_price', 12, 2)->default(0);
            $table->decimal('sale_price', 12, 2)->default(0);
            $table->decimal('mrp', 12, 2)->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            
            $table->index('name');
            $table->index('is_active');
        });
    }

    public function down(): void
    {
        // Check if any other module uses products table
        $otherModulesUsingProducts = ['inventory', 'pos', 'purchase'];
        
        if (Schema::hasTable('modules')) {
            $otherModuleExists = DB::table('modules')
                ->whereIn('alias', $otherModulesUsingProducts)
                ->where('is_installed', true)
                ->exists();
            
            if ($otherModuleExists) {
                return; // Don't drop, another module needs this table
            }
        }

        // Safe to drop - no other module using it
        Schema::dropIfExists('products');
    }
};
