<?php

namespace Modules\Product\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Artisan;

class ProductServiceProvider extends ServiceProvider
{
    protected string $moduleName = 'Product';
    protected string $moduleNameLower = 'product';

    public function boot(): void
    {
        $this->registerConfig();
        $this->registerViews();
        $this->loadMigrationsFrom(module_path($this->moduleName, 'Database/Migrations'));
        
        // Auto-create products table if it doesn't exist
        $this->ensureProductsTableExists();
    }

    public function register(): void
    {
        $this->app->register(RouteServiceProvider::class);
    }

    protected function registerConfig(): void
    {
        $this->mergeConfigFrom(module_path($this->moduleName, 'Config/config.php'), $this->moduleNameLower);
    }

    protected function registerViews(): void
    {
        $sourcePath = module_path($this->moduleName, 'Resources/views');
        $this->loadViewsFrom($sourcePath, $this->moduleNameLower);
    }

    /**
     * Ensure products table exists - create if missing
     */
    protected function ensureProductsTableExists(): void
    {
        try {
            if (!Schema::hasTable('products')) {
                Schema::create('products', function ($table) {
                    $table->id();
                    $table->string('name', 191);
                    $table->string('sku', 100)->unique();
                    $table->text('description')->nullable();
                    $table->decimal('purchase_price', 12, 2)->default(0);
                    $table->decimal('sale_price', 12, 2)->default(0);
                    $table->decimal('mrp', 12, 2)->nullable();
                    $table->boolean('is_active')->default(true);
                    $table->timestamps();
                    
                    $table->index('name');
                    $table->index('is_active');
                });
            }
        } catch (\Exception $e) {
            // Silently fail if table creation fails (e.g., during artisan commands)
        }
    }
}
