<?php

namespace Modules\Projects\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Schema;

class DiscussionReply extends Model
{
    protected $table = 'project_discussion_replies';

    protected $fillable = [
        'discussion_id',
        'message',
        'created_by',
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function discussion()
    {
        return $this->belongsTo(Discussion::class, 'discussion_id');
    }

    public function creator()
    {
        // Try Staff model first, then Admin
        if (class_exists('App\Models\Staff')) {
            return $this->belongsTo('App\Models\Staff', 'created_by');
        }
        if (class_exists('App\Models\Admin')) {
            return $this->belongsTo('App\Models\Admin', 'created_by');
        }
        return $this->belongsTo(DiscussionReply::class, 'id', 'id')->whereRaw('1 = 0');
    }
}
