<?php

namespace Modules\Projects\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class ProjectStatus extends Model
{
    protected $table = 'project_statuses';

    protected $fillable = [
        'name',
        'label',
        'color',
        'sort_order',
        'is_default',
        'show_by_default',
        'is_active',
    ];

    protected $casts = [
        'is_default' => 'boolean',
        'show_by_default' => 'boolean',
        'is_active' => 'boolean',
    ];

    // ==================== ACCESSORS ====================

    /**
     * Get label attribute - returns name if label column doesn't exist
     */
    public function getLabelAttribute(): string
    {
        // If label column exists and has value, return it
        if (isset($this->attributes['label']) && $this->attributes['label']) {
            return $this->attributes['label'];
        }
        // Otherwise return name column
        return $this->attributes['name'] ?? 'Unknown';
    }

    /**
     * Get name attribute - returns label if name column doesn't exist
     */
    public function getNameAttribute(): string
    {
        // If name column exists and has value, return it
        if (isset($this->attributes['name']) && $this->attributes['name']) {
            return $this->attributes['name'];
        }
        // Otherwise return label column
        return $this->attributes['label'] ?? 'Unknown';
    }

    // ==================== RELATIONSHIPS ====================

    public function projects()
    {
        return $this->hasMany(Project::class, 'status_id');
    }

    // ==================== SCOPES ====================

    public function scopeActive(Builder $query): Builder
    {
        return $query->where('is_active', true);
    }

    public function scopeDefault(Builder $query): Builder
    {
        if (\Schema::hasColumn('project_statuses', 'is_default')) {
            return $query->where('is_default', true);
        }
        return $query->where('show_by_default', true);
    }
}
