<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<style>
/* ========== ANIMATIONS ========== */
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes slideIn {
    from { opacity: 0; transform: translateX(-10px); }
    to { opacity: 1; transform: translateX(0); }
}

@keyframes shake {
    0%, 100% { transform: translateX(0); }
    25% { transform: translateX(-5px); }
    75% { transform: translateX(5px); }
}

@keyframes pulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.05); }
}

@keyframes spin {
    to { transform: rotate(360deg); }
}

/* ========== BASE LAYOUT ========== */
.form-page { 
    max-width: 900px; 
    margin: 0 auto; 
    padding: 24px;
    animation: fadeInUp 0.5s ease;
    min-height: 100vh;
}

/* ========== HEADER ========== */
.form-header { 
    display: flex; 
    align-items: center; 
    gap: 16px; 
    margin-bottom: 28px;
    animation: slideIn 0.3s ease;
}

.form-header h1 {
    font-size: 28px;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0;
    letter-spacing: -0.02em;
}

.btn-back {
    width: 42px; 
    height: 42px;
    display: flex; 
    align-items: center; 
    justify-content: center;
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 10px;
    text-decoration: none;
    color: var(--text-secondary);
    transition: all 0.3s ease;
    flex-shrink: 0;
}

.btn-back:hover {
    background: var(--primary);
    color: white;
    border-color: var(--primary);
    transform: translateX(-3px);
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
}

/* ========== FORM CARD ========== */
.form-card {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
    animation: fadeInUp 0.6s ease;
}

.form-card-body { 
    padding: 28px;
}

/* ========== SECTION HEADERS ========== */
.section-header {
    display: flex;
    align-items: center;
    gap: 12px;
    margin-bottom: 24px;
    padding-bottom: 14px;
    border-bottom: 2px solid var(--card-border);
    animation: slideIn 0.4s ease;
}

.section-icon {
    width: 24px;
    height: 24px;
    color: var(--primary);
    flex-shrink: 0;
}

.section-title {
    font-size: 17px;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0;
    letter-spacing: -0.01em;
}

.section-divider {
    height: 1px;
    background: var(--card-border);
    margin: 32px 0;
}

/* ========== FORM GROUPS ========== */
.form-group { 
    margin-bottom: 20px;
    animation: fadeInUp 0.5s ease;
    animation-fill-mode: backwards;
}

.form-group:nth-child(1) { animation-delay: 0.05s; }
.form-group:nth-child(2) { animation-delay: 0.1s; }
.form-group:nth-child(3) { animation-delay: 0.15s; }
.form-group:nth-child(4) { animation-delay: 0.2s; }

.form-label {
    display: flex;
    align-items: center;
    gap: 6px;
    font-size: 14px;
    font-weight: 600;
    margin-bottom: 8px;
    color: var(--text-primary);
}

.label-icon {
    width: 16px;
    height: 16px;
    color: var(--text-secondary);
}

.label-hint {
    font-size: 12px;
    font-weight: 400;
    color: var(--text-muted);
    margin-left: auto;
}

/* ========== FORM INPUTS ========== */
.form-input, 
.form-select, 
.form-textarea {
    width: 100%;
    padding: 12px 16px;
    background: var(--input-bg);
    border: 1px solid var(--input-border);
    border-radius: 10px;
    font-size: 14px;
    color: var(--input-text);
    transition: all 0.3s ease;
    font-family: inherit;
}

.form-input:hover, 
.form-select:hover, 
.form-textarea:hover {
    border-color: var(--primary);
}

.form-input:focus, 
.form-select:focus, 
.form-textarea:focus {
    outline: none;
    border-color: var(--primary);
    background: var(--card-bg);
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    transform: translateY(-1px);
}

.form-input::placeholder,
.form-textarea::placeholder {
    color: var(--text-muted);
    opacity: 0.7;
}

.form-textarea { 
    min-height: 180px; 
    resize: vertical;
    line-height: 1.6;
}

/* ========== ERROR STATES ========== */
.form-input.error, 
.form-select.error, 
.form-textarea.error {
    border-color: var(--danger);
    animation: shake 0.3s ease;
}

.form-error {
    display: block;
    margin-top: 6px;
    font-size: 13px;
    color: var(--danger);
    font-weight: 500;
}

/* ========== FILE UPLOAD STYLES ========== */
.file-upload-area {
    border: 2px dashed var(--card-border);
    border-radius: 12px;
    padding: 30px 20px;
    text-align: center;
    cursor: pointer;
    transition: all 0.3s ease;
    background: var(--input-bg);
}

.file-upload-area:hover,
.file-upload-area.dragover {
    border-color: var(--primary);
    background: var(--primary-light);
}

.file-upload-area.dragover {
    transform: scale(1.01);
}

.file-upload-icon {
    width: 48px;
    height: 48px;
    color: var(--text-muted);
    margin-bottom: 12px;
}

.file-upload-text {
    font-size: 14px;
    color: var(--text-secondary);
    margin-bottom: 8px;
}

.file-upload-text strong {
    color: var(--primary);
}

.file-upload-hint {
    font-size: 12px;
    color: var(--text-muted);
}

.file-input {
    display: none;
}

/* File Preview List */
.file-preview-list {
    margin-top: 16px;
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.file-preview-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 12px 16px;
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 10px;
    animation: fadeInUp 0.3s ease;
}

.file-preview-icon {
    width: 36px;
    height: 36px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: var(--primary-light);
    border-radius: 8px;
    color: var(--primary);
    flex-shrink: 0;
}

.file-preview-icon svg {
    width: 20px;
    height: 20px;
}

.file-preview-icon.image {
    background: var(--success-light);
    color: var(--success);
}

.file-preview-icon.document {
    background: var(--warning-light);
    color: var(--warning);
}

.file-preview-icon.archive {
    background: var(--info-light);
    color: var(--info);
}

.file-preview-info {
    flex: 1;
    min-width: 0;
}

.file-preview-name {
    font-size: 14px;
    font-weight: 600;
    color: var(--text-primary);
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.file-preview-size {
    font-size: 12px;
    color: var(--text-muted);
}

.file-preview-remove {
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: transparent;
    border: 1px solid transparent;
    border-radius: 8px;
    color: var(--text-muted);
    cursor: pointer;
    transition: all 0.2s ease;
}

.file-preview-remove:hover {
    background: var(--danger-light);
    border-color: var(--danger);
    color: var(--danger);
}

.file-preview-remove svg {
    width: 18px;
    height: 18px;
}

/* Image thumbnail preview */
.file-preview-thumbnail {
    width: 36px;
    height: 36px;
    border-radius: 8px;
    object-fit: cover;
    flex-shrink: 0;
}

/* ========== FORM ACTIONS ========== */
.form-actions {
    padding: 20px 28px;
    border-top: 1px solid var(--card-border);
    display: flex;
    gap: 12px;
    background: var(--body-bg);
}

.btn-submit {
    padding: 12px 24px;
    background: var(--primary);
    color: white;
    border: none;
    border-radius: 10px;
    font-weight: 600;
    font-size: 14px;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 8px;
}

.btn-submit:hover { 
    background: var(--primary-hover);
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(59, 130, 246, 0.4);
}

.btn-submit:active {
    transform: translateY(0);
}

.btn-submit.loading {
    pointer-events: none;
    opacity: 0.8;
}

.btn-submit.loading svg {
    animation: spin 1s linear infinite;
}

.btn-cancel {
    padding: 12px 24px;
    background: var(--card-bg);
    color: var(--text-secondary);
    border: 1px solid var(--card-border);
    border-radius: 10px;
    font-weight: 600;
    font-size: 14px;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 8px;
    text-decoration: none;
}

.btn-cancel:hover {
    background: var(--danger-light);
    color: var(--danger);
    border-color: var(--danger);
}

/* ========== CHECKBOX ========== */
.form-checkbox {
    display: flex;
    align-items: flex-start;
    gap: 12px;
    padding: 16px;
    background: var(--input-bg);
    border: 1px solid var(--card-border);
    border-radius: 10px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.form-checkbox:hover {
    border-color: var(--primary);
    background: var(--card-bg);
}

.form-checkbox input[type="checkbox"] {
    width: 20px;
    height: 20px;
    margin: 0;
    cursor: pointer;
    accent-color: var(--primary);
    flex-shrink: 0;
}

.form-checkbox label {
    font-size: 14px;
    color: var(--text-secondary);
    cursor: pointer;
    line-height: 1.5;
}

.form-checkbox label strong {
    color: var(--text-primary);
}

/* ========== HELPERS ========== */
.form-help {
    display: flex;
    align-items: center;
    gap: 6px;
    margin-top: 6px;
    font-size: 12px;
    color: var(--text-muted);
}

.form-help svg {
    width: 14px;
    height: 14px;
    flex-shrink: 0;
}

.char-counter {
    display: block;
    text-align: right;
    font-size: 12px;
    color: var(--text-muted);
    margin-top: 6px;
    transition: color 0.3s ease;
}

.char-counter.warning { color: var(--warning); }
.char-counter.danger { color: var(--danger); }

.required {
    color: var(--danger);
    font-weight: 700;
}

/* ========== ALERTS ========== */
.alert-errors {
    background: var(--danger-light);
    border: 1px solid var(--danger);
    color: var(--danger);
    padding: 16px 20px;
    border-radius: 12px;
    margin-bottom: 24px;
    animation: fadeInUp 0.4s ease;
}

.alert-errors strong {
    display: flex;
    align-items: center;
    gap: 8px;
    margin-bottom: 10px;
}

.alert-errors ul {
    margin: 0;
    padding-left: 24px;
}

.alert-errors li {
    margin-bottom: 4px;
}

/* ========== SELECT2 CUSTOM STYLES ========== */
.select2-container--default .select2-selection--single {
    height: 46px;
    background: var(--input-bg);
    border: 1px solid var(--input-border);
    border-radius: 10px;
    padding: 8px 16px;
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 28px;
    color: var(--input-text);
    padding-left: 0;
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 44px;
    right: 12px;
}

.select2-container--default .select2-selection--single:hover {
    border-color: var(--primary);
}

.select2-container--default.select2-container--focus .select2-selection--single {
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.select2-dropdown {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 10px;
    box-shadow: 0 8px 24px rgba(0, 0, 0, 0.12);
}

.select2-container--default .select2-results__option--highlighted[aria-selected] {
    background: var(--primary);
    color: white;
}

.select2-container--default .select2-search--dropdown .select2-search__field {
    background: var(--input-bg);
    border: 1px solid var(--input-border);
    border-radius: 8px;
    padding: 10px 12px;
    color: var(--input-text);
}

.select2-results__option {
    padding: 10px 14px;
    color: var(--text-primary);
}

/* Project highlight */
.project-highlight {
    position: relative;
}

.project-highlight::before {
    content: '';
    position: absolute;
    left: -12px;
    top: 0;
    bottom: 0;
    width: 4px;
    background: var(--primary);
    border-radius: 4px;
}
</style>

<div class="form-page">
    <!-- HEADER -->
    <div class="form-header">
        <a href="{{ route('admin.discussions.index') }}" class="btn-back" title="Back to Discussions">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M19 12H5M12 19l-7-7 7-7"/>
            </svg>
        </a>
        <div>
            <h1>Start New Discussion</h1>
        </div>
    </div>

    <!-- ERROR ALERTS -->
    @if($errors->any())
    <div class="alert-errors">
        <strong>
            <svg style="width: 16px; height: 16px;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <circle cx="12" cy="12" r="10"/>
                <line x1="12" y1="8" x2="12" y2="12"/>
                <line x1="12" y1="16" x2="12.01" y2="16"/>
            </svg>
            Please fix the following errors:
        </strong>
        <ul>
            @foreach($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <!-- FORM -->
    <form action="{{ route('admin.discussions.store') }}" method="POST" id="discussionForm" enctype="multipart/form-data">
        @csrf
        <div class="form-card">
            <div class="form-card-body">
                
                <!-- ========== DISCUSSION SCOPE ========== -->
                <div class="section-header">
                    <svg class="section-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/>
                    </svg>
                    <h3 class="section-title">Discussion Scope</h3>
                </div>

                <div class="form-group">
                    <label class="form-label">
                        <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/>
                            <polyline points="9 22 9 12 15 12 15 22"/>
                        </svg>
                        Project <span class="required">*</span>
                    </label>
                    <select name="project_id" id="project-select" class="form-select" required>
                        <option value="">-- Select Project --</option>
                        @foreach($projects as $project)
                        <option value="{{ $project->id }}" {{ old('project_id') == $project->id ? 'selected' : '' }}>
                            {{ $project->title }}
                        </option>
                        @endforeach
                    </select>
                    <span class="form-help">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="10"/>
                            <path d="M12 16v-4M12 8h.01"/>
                        </svg>
                        Select the project this discussion belongs to
                    </span>
                    @error('project_id')
                    <span class="form-error">{{ $message }}</span>
                    @enderror
                </div>

                <div class="section-divider"></div>

                <!-- ========== DISCUSSION CONTENT ========== -->
                <div class="section-header">
                    <svg class="section-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                        <polyline points="14 2 14 8 20 8"/>
                        <line x1="16" y1="13" x2="8" y2="13"/>
                        <line x1="16" y1="17" x2="8" y2="17"/>
                        <polyline points="10 9 9 9 8 9"/>
                    </svg>
                    <h3 class="section-title">Discussion Content</h3>
                </div>

                <div class="form-group">
                    <label class="form-label">
                        <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M4 15s1-1 4-1 5 2 8 2 4-1 4-1V3s-1 1-4 1-5-2-8-2-4 1-4 1z"/>
                            <line x1="4" y1="22" x2="4" y2="15"/>
                        </svg>
                        Discussion Title <span class="required">*</span>
                    </label>
                    <input 
                        type="text" 
                        name="title" 
                        id="discussion-title"
                        class="form-input" 
                        value="{{ old('title') }}" 
                        placeholder="e.g., Q4 Planning Meeting, Design Review Feedback, Sprint Retrospective"
                        required
                        maxlength="191"
                        autocomplete="off"
                    >
                    <span class="form-help">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="10"/>
                            <path d="M12 16v-4M12 8h.01"/>
                        </svg>
                        A clear, descriptive title that summarizes the discussion topic
                    </span>
                    @error('title')
                    <span class="form-error">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label">
                        <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/>
                            <line x1="9" y1="10" x2="15" y2="10"/>
                            <line x1="12" y1="7" x2="12" y2="13"/>
                        </svg>
                        Message <span class="required">*</span>
                    </label>
                    <textarea 
                        name="message" 
                        id="message"
                        class="form-textarea"
                        placeholder="Share your thoughts, updates, questions, or announcements here. Be clear and specific to facilitate productive discussion."
                        required
                        maxlength="65535"
                    >{{ old('message') }}</textarea>
                    <span class="char-counter" id="msg-counter">0 / 65535 characters</span>
                    @error('message')
                    <span class="form-error">{{ $message }}</span>
                    @enderror
                </div>

                <div class="section-divider"></div>

                <!-- ========== FILE ATTACHMENTS ========== -->
                <div class="section-header">
                    <svg class="section-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M21.44 11.05l-9.19 9.19a6 6 0 0 1-8.49-8.49l9.19-9.19a4 4 0 0 1 5.66 5.66l-9.2 9.19a2 2 0 0 1-2.83-2.83l8.49-8.48"/>
                    </svg>
                    <h3 class="section-title">Attachments</h3>
                    <span class="label-hint">Optional</span>
                </div>

                <div class="form-group">
                    <div class="file-upload-area" id="dropZone">
                        <svg class="file-upload-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"/>
                            <polyline points="17 8 12 3 7 8"/>
                            <line x1="12" y1="3" x2="12" y2="15"/>
                        </svg>
                        <div class="file-upload-text">
                            <strong>Click to upload</strong> or drag and drop files here
                        </div>
                        <div class="file-upload-hint">
                            Supported: Images, PDF, DOC, XLS, ZIP (Max 10MB each)
                        </div>
                        <input 
                            type="file" 
                            name="attachments[]" 
                            id="fileInput" 
                            class="file-input" 
                            multiple
                            accept=".jpg,.jpeg,.png,.gif,.webp,.svg,.pdf,.doc,.docx,.xls,.xlsx,.csv,.ppt,.pptx,.txt,.rtf,.zip,.rar,.7z,.html,.css,.js,.json,.xml"
                        >
                    </div>
                    
                    <div class="file-preview-list" id="filePreviewList"></div>
                    
                    @error('attachments')
                    <span class="form-error">{{ $message }}</span>
                    @enderror
                    @error('attachments.*')
                    <span class="form-error">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <!-- ========== FORM ACTIONS ========== -->
            <div class="form-actions">
                <button type="submit" class="btn-submit" id="submitBtn">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/>
                        <line x1="9" y1="10" x2="15" y2="10"/>
                        <line x1="12" y1="7" x2="12" y2="13"/>
                    </svg>
                    Create Discussion
                </button>
                <a href="{{ route('admin.discussions.index') }}" class="btn-cancel">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="12" cy="12" r="10"/>
                        <line x1="15" y1="9" x2="9" y2="15"/>
                        <line x1="9" y1="9" x2="15" y2="15"/>
                    </svg>
                    Cancel
                </a>
            </div>
        </div>
    </form>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
$(document).ready(function() {
    // ========== SELECT2 INITIALIZATION ==========
    $('#project-select').select2({
        placeholder: 'Search and select a project...',
        allowClear: true,
        width: '100%',
        theme: 'default',
        language: {
            noResults: function() {
                return "No projects found";
            },
            searching: function() {
                return "Searching...";
            }
        }
    });

    // ========== PROJECT HIGHLIGHT ==========
    const projectSelect = document.getElementById('project-select');
    if (projectSelect) {
        projectSelect.closest('.form-group').classList.add('project-highlight');
    }

    // ========== CHARACTER COUNTER ==========
    function setupCharCounter(textareaId, counterId, maxLength) {
        const textarea = document.getElementById(textareaId);
        const counter = document.getElementById(counterId);
        
        if (textarea && counter) {
            textarea.addEventListener('input', function() {
                const current = this.value.length;
                counter.textContent = `${current} / ${maxLength} characters`;
                
                counter.classList.remove('warning', 'danger');
                if (current > maxLength * 0.95) {
                    counter.classList.add('danger');
                } else if (current > maxLength * 0.85) {
                    counter.classList.add('warning');
                }
            });
        }
    }
    
    setupCharCounter('message', 'msg-counter', 65535);

    // ========== FILE UPLOAD HANDLING ==========
    const dropZone = document.getElementById('dropZone');
    const fileInput = document.getElementById('fileInput');
    const filePreviewList = document.getElementById('filePreviewList');
    let selectedFiles = new DataTransfer();

    // Click to upload
    dropZone.addEventListener('click', () => fileInput.click());

    // Drag and drop events
    dropZone.addEventListener('dragover', (e) => {
        e.preventDefault();
        dropZone.classList.add('dragover');
    });

    dropZone.addEventListener('dragleave', (e) => {
        e.preventDefault();
        dropZone.classList.remove('dragover');
    });

    dropZone.addEventListener('drop', (e) => {
        e.preventDefault();
        dropZone.classList.remove('dragover');
        handleFiles(e.dataTransfer.files);
    });

    // File input change
    fileInput.addEventListener('change', (e) => {
        handleFiles(e.target.files);
    });

    function handleFiles(files) {
        const maxSize = 10 * 1024 * 1024; // 10MB
        const allowedTypes = [
            'image/jpeg', 'image/png', 'image/gif', 'image/webp', 'image/svg+xml',
            'application/pdf',
            'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
            'application/vnd.ms-excel', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
            'text/csv',
            'application/vnd.ms-powerpoint', 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
            'text/plain', 'application/rtf',
            'application/zip', 'application/x-rar-compressed', 'application/x-7z-compressed',
            'text/html', 'text/css', 'application/javascript', 'application/json', 'application/xml'
        ];

        Array.from(files).forEach(file => {
            // Check file size
            if (file.size > maxSize) {
                alert(`File "${file.name}" exceeds 10MB limit`);
                return;
            }

            // Check file type
            if (!allowedTypes.includes(file.type) && !file.name.match(/\.(rar|7z)$/i)) {
                alert(`File type not allowed: ${file.name}`);
                return;
            }

            // Add to DataTransfer
            selectedFiles.items.add(file);
        });

        // Update file input
        fileInput.files = selectedFiles.files;
        
        // Render previews
        renderFilePreviews();
    }

    function renderFilePreviews() {
        filePreviewList.innerHTML = '';

        Array.from(selectedFiles.files).forEach((file, index) => {
            const item = document.createElement('div');
            item.className = 'file-preview-item';
            
            const iconClass = getFileIconClass(file.type, file.name);
            const icon = getFileIcon(file.type, file.name);
            
            item.innerHTML = `
                <div class="file-preview-icon ${iconClass}">
                    ${icon}
                </div>
                <div class="file-preview-info">
                    <div class="file-preview-name">${escapeHtml(file.name)}</div>
                    <div class="file-preview-size">${formatFileSize(file.size)}</div>
                </div>
                <button type="button" class="file-preview-remove" data-index="${index}" title="Remove file">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="18" y1="6" x2="6" y2="18"/>
                        <line x1="6" y1="6" x2="18" y2="18"/>
                    </svg>
                </button>
            `;

            // Add image thumbnail if applicable
            if (file.type.startsWith('image/')) {
                const reader = new FileReader();
                reader.onload = (e) => {
                    const iconDiv = item.querySelector('.file-preview-icon');
                    iconDiv.outerHTML = `<img src="${e.target.result}" class="file-preview-thumbnail" alt="${escapeHtml(file.name)}">`;
                };
                reader.readAsDataURL(file);
            }

            filePreviewList.appendChild(item);
        });

        // Add remove handlers
        document.querySelectorAll('.file-preview-remove').forEach(btn => {
            btn.addEventListener('click', (e) => {
                e.preventDefault();
                const index = parseInt(btn.dataset.index);
                removeFile(index);
            });
        });
    }

    function removeFile(index) {
        const newFiles = new DataTransfer();
        Array.from(selectedFiles.files).forEach((file, i) => {
            if (i !== index) {
                newFiles.items.add(file);
            }
        });
        selectedFiles = newFiles;
        fileInput.files = selectedFiles.files;
        renderFilePreviews();
    }

    function getFileIconClass(mimeType, fileName) {
        if (mimeType.startsWith('image/')) return 'image';
        if (mimeType.includes('pdf') || mimeType.includes('word') || mimeType.includes('document')) return 'document';
        if (mimeType.includes('zip') || mimeType.includes('rar') || mimeType.includes('7z') || fileName.match(/\.(zip|rar|7z)$/i)) return 'archive';
        return '';
    }

    function getFileIcon(mimeType, fileName) {
        if (mimeType.startsWith('image/')) {
            return `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <rect x="3" y="3" width="18" height="18" rx="2" ry="2"/>
                <circle cx="8.5" cy="8.5" r="1.5"/>
                <polyline points="21 15 16 10 5 21"/>
            </svg>`;
        }
        if (mimeType.includes('pdf')) {
            return `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                <polyline points="14 2 14 8 20 8"/>
                <line x1="16" y1="13" x2="8" y2="13"/>
                <line x1="16" y1="17" x2="8" y2="17"/>
            </svg>`;
        }
        if (mimeType.includes('zip') || mimeType.includes('rar') || mimeType.includes('7z') || fileName.match(/\.(zip|rar|7z)$/i)) {
            return `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M21 8v13H3V8"/>
                <path d="M1 3h22v5H1z"/>
                <path d="M10 12h4"/>
            </svg>`;
        }
        return `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
            <path d="M13 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V9z"/>
            <polyline points="13 2 13 9 20 9"/>
        </svg>`;
    }

    function formatFileSize(bytes) {
        if (bytes >= 1073741824) return (bytes / 1073741824).toFixed(2) + ' GB';
        if (bytes >= 1048576) return (bytes / 1048576).toFixed(2) + ' MB';
        if (bytes >= 1024) return (bytes / 1024).toFixed(2) + ' KB';
        return bytes + ' bytes';
    }

    function escapeHtml(text) {
        const div = document.createElement('div');
        div.textContent = text;
        return div.innerHTML;
    }

    // ========== FORM VALIDATION & SUBMISSION ==========
    const form = document.getElementById('discussionForm');
    const submitBtn = document.getElementById('submitBtn');
    
    form.addEventListener('submit', function(e) {
        submitBtn.classList.add('loading');
        submitBtn.disabled = true;
        
        const title = form.querySelector('[name="title"]');
        const message = form.querySelector('[name="message"]');
        const projectId = form.querySelector('[name="project_id"]');
        
        // Validate title
        if (!title.value.trim()) {
            e.preventDefault();
            title.classList.add('error');
            title.focus();
            resetSubmitButton();
            return false;
        }
        
        // Validate message
        if (!message.value.trim()) {
            e.preventDefault();
            message.classList.add('error');
            message.focus();
            resetSubmitButton();
            return false;
        }
        
        // Validate project selection
        if (!projectId.value) {
            e.preventDefault();
            projectId.classList.add('error');
            projectId.focus();
            resetSubmitButton();
            return false;
        }
    });
    
    function resetSubmitButton() {
        submitBtn.classList.remove('loading');
        submitBtn.disabled = false;
    }
    
    // Remove error class on input
    form.querySelectorAll('.form-input, .form-select, .form-textarea').forEach(input => {
        input.addEventListener('input', function() {
            this.classList.remove('error');
        });
    });

    // ========== AUTO-FOCUS ==========
    setTimeout(() => {
        document.querySelector('[name="project_id"]').focus();
    }, 300);

    // ========== TEXTAREA AUTO-RESIZE ==========
    const messageTextarea = document.getElementById('message');
    if (messageTextarea) {
        messageTextarea.addEventListener('input', function() {
            this.style.height = 'auto';
            this.style.height = (this.scrollHeight) + 'px';
        });
    }

    // ========== CONFIRM NAVIGATION AWAY IF FORM DIRTY ==========
    let formDirty = false;
    
    form.querySelectorAll('input, select, textarea').forEach(field => {
        field.addEventListener('change', () => formDirty = true);
    });
    
    window.addEventListener('beforeunload', function(e) {
        if (formDirty && !submitBtn.classList.contains('loading')) {
            e.preventDefault();
            e.returnValue = '';
        }
    });
    
    form.addEventListener('submit', () => formDirty = false);
});
</script>