<style>
/* ========================================
   Discussions - Hardcoded Styles
   ======================================== */

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

.discussions-page {
    padding: 24px;
    animation: fadeIn 0.4s ease;
    background: #f8fafc;
    min-height: 100vh;
}

/* Page Header */
.page-header {
    background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
    padding: 20px 24px;
    border-radius: 12px;
    margin-bottom: 20px;
    box-shadow: 0 4px 15px rgba(59, 130, 246, 0.3);
}

.header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 20px;
}

.header-left h1 {
    color: white;
    font-size: 22px;
    font-weight: 700;
    margin: 0 0 4px 0;
    display: flex;
    align-items: center;
    gap: 10px;
}

.header-left h1 svg { width: 20px; height: 20px; }
.header-left p { color: rgba(255, 255, 255, 0.9); font-size: 14px; margin: 0; }

/* Search Bar */
.header-search {
    flex: 1;
    max-width: 320px;
    position: relative;
}

.header-search svg {
    position: absolute;
    left: 12px;
    top: 50%;
    transform: translateY(-50%);
    width: 14px;
    height: 14px;
    color: rgba(255, 255, 255, 0.7);
    pointer-events: none;
}

.header-search input {
    width: 100%;
    padding: 10px 12px 10px 36px;
    border-radius: 8px;
    border: 1px solid rgba(255, 255, 255, 0.3);
    font-size: 14px;
    background: rgba(255, 255, 255, 0.15);
    color: white;
    transition: all 0.3s ease;
}

.header-search input::placeholder { color: rgba(255, 255, 255, 0.7); }
.header-search input:focus {
    outline: none;
    background: white;
    color: #1e293b;
    border-color: white;
}

/* Header Button */
.btn-primary {
    padding: 10px 18px;
    background: white;
    color: #3b82f6;
    border: none;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 600;
    text-decoration: none;
    display: flex;
    align-items: center;
    gap: 6px;
    cursor: pointer;
    transition: all 0.2s ease;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(255, 255, 255, 0.3);
}

.btn-primary svg { width: 14px; height: 14px; }

/* Stats Cards */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 16px;
    margin-bottom: 20px;
}

.stat-card {
    background: #ffffff;
    border: 1px solid #e2e8f0;
    border-radius: 12px;
    padding: 16px 20px;
    display: flex;
    align-items: center;
    gap: 16px;
    transition: all 0.3s ease;
}

.stat-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
}

.stat-icon {
    width: 42px;
    height: 42px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.stat-icon svg { width: 20px; height: 20px; color: white; }
.stat-icon-primary { background: #3b82f6; }

.stat-content h3 {
    font-size: 26px;
    font-weight: 700;
    color: #1e293b;
    margin: 0;
    line-height: 1;
}

.stat-content p {
    font-size: 12px;
    color: #64748b;
    margin: 4px 0 0 0;
    text-transform: uppercase;
    letter-spacing: 0.05em;
    font-weight: 600;
}

/* Filters Card */
.filters-card {
    background: #ffffff;
    border: 1px solid #e2e8f0;
    padding: 16px 20px;
    border-radius: 12px;
    margin-bottom: 20px;
}

.filters-row {
    display: flex;
    gap: 12px;
    align-items: center;
    flex-wrap: wrap;
}

.quick-filters { display: flex; gap: 8px; }

.filter-btn {
    padding: 8px 16px;
    border: 1px solid #e2e8f0;
    background: #ffffff;
    color: #64748b;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s ease;
}

.filter-btn:hover {
    border-color: #3b82f6;
    color: #3b82f6;
}

.filter-btn.active {
    background: #3b82f6;
    color: white;
    border-color: #3b82f6;
}

.per-page {
    display: flex;
    align-items: center;
    gap: 8px;
    margin-left: auto;
}

.per-page label { font-size: 14px; color: #64748b; font-weight: 600; }

.per-page select {
    padding: 8px 12px;
    border: 1px solid #e2e8f0;
    background: #ffffff;
    color: #1e293b;
    border-radius: 8px;
    font-size: 14px;
    cursor: pointer;
}

/* Table Card */
.table-card {
    background: #ffffff;
    border: 1px solid #e2e8f0;
    border-radius: 12px;
    overflow: hidden;
}

.table-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 16px 20px;
    border-bottom: 1px solid #e2e8f0;
}

.table-title {
    font-size: 16px;
    font-weight: 700;
    color: #1e293b;
    display: flex;
    align-items: center;
    gap: 10px;
    margin: 0;
}

.table-title svg { width: 18px; height: 18px; color: #3b82f6; }

.pagination-info { font-size: 13px; color: #64748b; }

/* Data Table */
.data-table {
    width: 100%;
    border-collapse: collapse;
}

.data-table th {
    background: #f8fafc;
    padding: 12px 16px;
    text-align: left;
    font-size: 12px;
    font-weight: 700;
    color: #64748b;
    text-transform: uppercase;
    letter-spacing: 0.05em;
    border-bottom: 1px solid #e2e8f0;
}

.data-table th.sortable { cursor: pointer; user-select: none; }
.data-table th.sortable:hover { color: #3b82f6; }

.data-table td {
    padding: 14px 16px;
    font-size: 14px;
    color: #1e293b;
    border-bottom: 1px solid #f1f5f9;
    vertical-align: middle;
}

.data-table tbody tr:hover { background: #f8fafc; }
.data-table tbody tr:last-child td { border-bottom: none; }

/* Actions */
.actions { display: flex; gap: 6px; }

.btn-icon {
    width: 32px;
    height: 32px;
    border: none;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.2s ease;
    text-decoration: none;
}

.btn-icon svg { width: 16px; height: 16px; }

.btn-view { background: #dbeafe; color: #1d4ed8; }
.btn-view:hover { background: #3b82f6; color: white; }

.btn-delete { background: #fee2e2; color: #dc2626; }
.btn-delete:hover { background: #ef4444; color: white; }

/* Empty State */
.empty-state {
    text-align: center;
    padding: 48px 24px;
    color: #94a3b8;
}

.empty-state svg { width: 48px; height: 48px; margin-bottom: 16px; opacity: 0.5; }
.empty-state h3 { font-size: 18px; color: #64748b; margin: 0 0 8px 0; }
.empty-state p { font-size: 14px; margin: 0; }

/* Pagination */
.pagination {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 6px;
    padding: 16px;
    border-top: 1px solid #e2e8f0;
}

.page-btn {
    padding: 8px 14px;
    border: 1px solid #e2e8f0;
    background: #ffffff;
    color: #64748b;
    border-radius: 6px;
    font-size: 13px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s ease;
}

.page-btn:hover:not(:disabled) { border-color: #3b82f6; color: #3b82f6; }
.page-btn.active { background: #3b82f6; color: white; border-color: #3b82f6; }
.page-btn:disabled { opacity: 0.5; cursor: not-allowed; }

/* Responsive */
@media (max-width: 768px) {
    .discussions-page { padding: 16px; }
    .stats-grid { grid-template-columns: 1fr; }
    .header-content { flex-direction: column; align-items: stretch; }
    .header-search { max-width: 100%; }
}
</style>

<div class="discussions-page">
    <!-- Page Header -->
    <div class="page-header">
        <div class="header-content">
            <div class="header-left">
                <h1>
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                    </svg>
                    Discussions
                </h1>
                <p>Project discussions and updates</p>
            </div>
            
            <div class="header-search">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                </svg>
                <input type="text" id="searchInput" placeholder="Search discussions...">
            </div>
            
            <a href="{{ route('admin.discussions.create') }}" class="btn-primary">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"/>
                </svg>
                New Discussion
            </a>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon stat-icon-primary">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                </svg>
            </div>
            <div class="stat-content">
                <h3 id="totalDiscussions">{{ number_format($stats['total'] ?? 0) }}</h3>
                <p>Total Discussions</p>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-icon stat-icon-primary">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                </svg>
            </div>
            <div class="stat-content">
                <h3 id="myDiscussions">{{ number_format($stats['my_discussions'] ?? 0) }}</h3>
                <p>My Discussions</p>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="filters-card">
        <div class="filters-row">
            <div class="quick-filters">
                <button class="filter-btn active" onclick="applyFilter(this, 'all')">All</button>
                <button class="filter-btn" onclick="applyFilter(this, 'my_discussions')">My Discussions</button>
            </div>

            <div class="per-page">
                <label>Show:</label>
                <select id="perPageSelect" onchange="changePerPage(this.value)">
                    <option value="15" selected>15</option>
                    <option value="25">25</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                </select>
            </div>
        </div>
    </div>

    <!-- Discussions Table -->
    <div class="table-card">
        <div class="table-header">
            <h3 class="table-title">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                </svg>
                All Discussions
            </h3>
            <div class="pagination-info" id="paginationInfo">Showing 0-0 of 0 discussions</div>
        </div>

        <table class="data-table">
            <thead>
                <tr>
                    <th style="width: 40px;"><input type="checkbox" id="selectAll" onchange="toggleSelectAll(this)"></th>
                    <th class="sortable" data-column="id">ID</th>
                    <th class="sortable" data-column="title">Title</th>
                    <th class="sortable" data-column="project_id">Project</th>
                    <th class="sortable" data-column="created_by">Created By</th>
                    <th>Replies</th>
                    <th class="sortable" data-column="created_at">Created</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody id="discussionsBody"></tbody>
        </table>

        <div class="pagination" id="pagination" style="display: none;"></div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
let currentPage = 1;
let perPage = 15;
let totalRecords = 0;
let lastPage = 1;
let sortColumn = 'created_at';
let sortDirection = 'desc';
let selectedIds = [];
let currentFilter = 'all';

$(document).ready(function() {
    loadDiscussions();

    let searchTimeout;
    $('#searchInput').on('keyup', function() {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(() => {
            currentPage = 1;
            loadDiscussions();
        }, 500);
    });

    $('.sortable').on('click', function() {
        const column = $(this).data('column');
        if (sortColumn === column) {
            sortDirection = sortDirection === 'asc' ? 'desc' : 'asc';
        } else {
            sortColumn = column;
            sortDirection = 'asc';
        }
        $('.sortable').removeClass('sorting-asc sorting-desc');
        $(this).addClass('sorting-' + sortDirection);
        loadDiscussions();
    });
});

function loadDiscussions() {
    const filters = {
        search: $('#searchInput').val(),
        filter_type: currentFilter,
        page: currentPage,
        per_page: perPage,
        sort: sortColumn,
        dir: sortDirection
    };

    $.ajax({
        url: '{{ route("admin.discussions.data") }}',
        type: 'GET',
        data: filters,
        success: function(response) {
            renderDiscussions(response.data);
            updatePagination(response);
        },
        error: function(xhr) {
            alert('Error: ' + (xhr.responseJSON?.message || 'Unknown error'));
        }
    });
}

function renderDiscussions(discussions) {
    const tbody = $('#discussionsBody');
    tbody.empty();

    if (discussions.length === 0) {
        tbody.append('<tr><td colspan="8"><div class="empty-state"><svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/></svg><h3>No Discussions Found</h3><p>No discussions match your criteria</p></div></td></tr>');
        return;
    }

    discussions.forEach(discussion => {
        const row = '<tr>' +
            '<td><input type="checkbox" class="discussion-checkbox" value="' + discussion.id + '" onchange="toggleSelection(this)"></td>' +
            '<td><strong>#' + discussion.id + '</strong></td>' +
            '<td><strong>' + discussion.title + '</strong></td>' +
            '<td>' + discussion.project_display + '</td>' +
            '<td>' + discussion.creator_display + '</td>' +
            '<td>' + (discussion.replies_count || 0) + '</td>' +
            '<td>' + discussion.created_at_display + '</td>' +
            '<td><div class="actions">' +
                '<a href="' + discussion._show_url + '" class="btn-icon btn-view" title="View"><svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/><path stroke-linecap="round" stroke-linejoin="round" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/></svg></a>' +
                '<button class="btn-icon btn-delete" onclick="deleteDiscussion(' + discussion.id + ')" title="Delete"><svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/></svg></button>' +
            '</div></td>' +
        '</tr>';
        tbody.append(row);
    });
}

function updatePagination(response) {
    totalRecords = response.total || 0;
    currentPage = response.current_page || 1;
    lastPage = response.last_page || 1;

    const startRecord = totalRecords === 0 ? 0 : ((currentPage - 1) * perPage) + 1;
    const endRecord = Math.min(currentPage * perPage, totalRecords);
    $('#paginationInfo').text('Showing ' + startRecord + '-' + endRecord + ' of ' + totalRecords + ' discussions');

    const pagination = $('#pagination');
    if (lastPage <= 1) { pagination.hide(); return; }

    pagination.show().empty();
    pagination.append('<button class="page-btn" onclick="goToPage(' + (currentPage - 1) + ')" ' + (currentPage === 1 ? 'disabled' : '') + '>Previous</button>');

    for (let i = 1; i <= lastPage; i++) {
        if (i === 1 || i === lastPage || (i >= currentPage - 2 && i <= currentPage + 2)) {
            pagination.append('<button class="page-btn ' + (i === currentPage ? 'active' : '') + '" onclick="goToPage(' + i + ')">' + i + '</button>');
        } else if (i === currentPage - 3 || i === currentPage + 3) {
            pagination.append('<span style="padding: 0 8px;">...</span>');
        }
    }

    pagination.append('<button class="page-btn" onclick="goToPage(' + (currentPage + 1) + ')" ' + (currentPage === lastPage ? 'disabled' : '') + '>Next</button>');
}

function goToPage(page) {
    if (page < 1 || page > lastPage) return;
    currentPage = page;
    loadDiscussions();
}

function changePerPage(value) {
    perPage = parseInt(value);
    currentPage = 1;
    loadDiscussions();
}

function applyFilter(button, type) {
    $('.filter-btn').removeClass('active');
    $(button).addClass('active');
    currentFilter = type;
    currentPage = 1;
    loadDiscussions();
}

function toggleSelection(checkbox) {
    const id = parseInt(checkbox.value);
    if (checkbox.checked) {
        selectedIds.push(id);
    } else {
        selectedIds = selectedIds.filter(item => item !== id);
    }
}

function toggleSelectAll(checkbox) {
    $('.discussion-checkbox').prop('checked', checkbox.checked);
    selectedIds = checkbox.checked ? $('.discussion-checkbox').map(function() { return parseInt(this.value); }).get() : [];
}

function deleteDiscussion(discussionId) {
    if (!confirm('Delete this discussion?')) return;

    $.ajax({
        url: '/admin/projects/discussions/' + discussionId,
        type: 'DELETE',
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        success: function(response) {
            if (response.success) {
                alert(response.message);
                loadDiscussions();
                updateStats();
            }
        },
        error: function(xhr) {
            alert('Delete failed: ' + (xhr.responseJSON?.message || 'Error'));
        }
    });
}

function updateStats() {
    $.ajax({
        url: '{{ route("admin.discussions.stats") }}',
        type: 'GET',
        success: function(stats) {
            $('#totalDiscussions').text(stats.total.toLocaleString());
            $('#myDiscussions').text(stats.my_discussions.toLocaleString());
        }
    });
}
</script>
