<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<style>
/* ========== ANIMATIONS ========== */
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes slideIn {
    from { opacity: 0; transform: translateX(-10px); }
    to { opacity: 1; transform: translateX(0); }
}

@keyframes shake {
    0%, 100% { transform: translateX(0); }
    25% { transform: translateX(-5px); }
    75% { transform: translateX(5px); }
}

@keyframes pulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.05); }
}

@keyframes spin {
    to { transform: rotate(360deg); }
}

/* ========== BASE LAYOUT ========== */
.form-page { 
    max-width: 900px; 
    margin: 0 auto; 
    padding: 24px;
    animation: fadeInUp 0.5s ease;
    min-height: 100vh;
}

/* ========== HEADER ========== */
.form-header { 
    display: flex; 
    align-items: center; 
    gap: 16px; 
    margin-bottom: 28px;
    animation: slideIn 0.3s ease;
}

.form-header h1 {
    font-size: 28px;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0;
    letter-spacing: -0.02em;
}

.btn-back {
    width: 42px; 
    height: 42px;
    display: flex; 
    align-items: center; 
    justify-content: center;
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 10px;
    text-decoration: none;
    color: var(--text-secondary);
    transition: all 0.3s ease;
    flex-shrink: 0;
}

.btn-back:hover {
    background: var(--primary);
    color: white;
    border-color: var(--primary);
    transform: translateX(-3px);
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
}

/* ========== FORM CARD ========== */
.form-card {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
    animation: fadeInUp 0.6s ease;
}

.form-card-body { 
    padding: 28px;
}

/* ========== SECTION HEADERS ========== */
.section-header {
    display: flex;
    align-items: center;
    gap: 12px;
    margin-bottom: 24px;
    padding-bottom: 14px;
    border-bottom: 2px solid var(--card-border);
    animation: slideIn 0.4s ease;
}

.section-icon {
    width: 24px;
    height: 24px;
    color: var(--primary);
    flex-shrink: 0;
}

.section-title {
    font-size: 17px;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0;
    letter-spacing: -0.01em;
}

.section-divider {
    height: 1px;
    background: var(--card-border);
    margin: 32px 0;
}

/* ========== FORM GROUPS ========== */
.form-group { 
    margin-bottom: 20px;
    animation: fadeInUp 0.5s ease;
    animation-fill-mode: backwards;
}

.form-group:nth-child(1) { animation-delay: 0.05s; }
.form-group:nth-child(2) { animation-delay: 0.1s; }
.form-group:nth-child(3) { animation-delay: 0.15s; }
.form-group:nth-child(4) { animation-delay: 0.2s; }

.form-label {
    display: flex;
    align-items: center;
    gap: 6px;
    font-size: 14px;
    font-weight: 600;
    margin-bottom: 8px;
    color: var(--text-primary);
}

.label-icon {
    width: 16px;
    height: 16px;
    color: var(--text-secondary);
}

.label-hint {
    font-size: 12px;
    font-weight: 400;
    color: var(--text-muted);
    margin-left: auto;
}

/* ========== FORM INPUTS ========== */
.form-input, 
.form-select, 
.form-textarea {
    width: 100%;
    padding: 12px 16px;
    background: var(--input-bg);
    border: 1px solid var(--input-border);
    border-radius: 10px;
    font-size: 14px;
    color: var(--input-text);
    transition: all 0.3s ease;
    font-family: inherit;
}

.form-input:hover, 
.form-select:hover, 
.form-textarea:hover {
    border-color: var(--primary);
}

.form-input:focus, 
.form-select:focus, 
.form-textarea:focus {
    outline: none;
    border-color: var(--primary);
    background: var(--card-bg);
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    transform: translateY(-1px);
}

.form-input::placeholder,
.form-textarea::placeholder {
    color: var(--text-muted);
    opacity: 0.7;
}

.form-textarea { 
    min-height: 120px; 
    resize: vertical;
    line-height: 1.6;
}

/* ========== ERROR STATES ========== */
.form-input.error, 
.form-select.error, 
.form-textarea.error {
    border-color: var(--danger);
    animation: shake 0.3s ease;
}

.form-error {
    display: block;
    margin-top: 6px;
    font-size: 13px;
    color: var(--danger);
    font-weight: 500;
}

/* ========== FORM ROWS ========== */
.form-row {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 16px;
}

@media (max-width: 768px) {
    .form-row {
        grid-template-columns: 1fr;
    }
}

/* ========== FORM ACTIONS ========== */
.form-actions {
    padding: 20px 28px;
    border-top: 1px solid var(--card-border);
    display: flex;
    gap: 12px;
    background: var(--body-bg);
}

.btn-submit {
    padding: 12px 24px;
    background: var(--primary);
    color: white;
    border: none;
    border-radius: 10px;
    font-weight: 600;
    font-size: 14px;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 8px;
}

.btn-submit:hover { 
    background: var(--primary-hover);
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(59, 130, 246, 0.4);
}

.btn-submit:active {
    transform: translateY(0);
}

.btn-submit.loading {
    position: relative;
    pointer-events: none;
    opacity: 0.7;
}

.btn-submit.loading::after {
    content: '';
    position: absolute;
    width: 16px;
    height: 16px;
    border: 2px solid white;
    border-top-color: transparent;
    border-radius: 50%;
    animation: spin 0.6s linear infinite;
    right: 12px;
}

.btn-cancel {
    padding: 12px 24px;
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 10px;
    text-decoration: none;
    color: var(--text-primary);
    font-weight: 600;
    font-size: 14px;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 8px;
}

.btn-cancel:hover {
    background: var(--danger-light);
    border-color: var(--danger);
    color: var(--danger);
    transform: translateY(-2px);
}

/* ========== REQUIRED INDICATOR ========== */
.required { 
    color: var(--danger);
    font-weight: bold;
    margin-left: 2px;
}

/* ========== ALERT ERRORS ========== */
.alert-errors {
    background: var(--danger-light);
    border: 1px solid var(--danger);
    padding: 16px 20px;
    border-radius: 12px;
    margin-bottom: 24px;
    color: var(--danger);
    animation: slideIn 0.4s ease;
}

.alert-errors strong {
    display: block;
    margin-bottom: 8px;
    font-size: 14px;
}

.alert-errors ul {
    margin: 0;
    padding-left: 20px;
}

.alert-errors li {
    margin: 6px 0;
    font-size: 13px;
}

/* ========== CHECKBOX STYLING ========== */
.form-checkbox {
    display: flex;
    align-items: center;
    gap: 10px;
    margin-top: 8px;
    padding: 14px 16px;
    background: var(--primary-light);
    border-radius: 10px;
    transition: all 0.3s ease;
    border: 1px solid transparent;
}

.form-checkbox:hover {
    background: rgba(59, 130, 246, 0.15);
    border-color: var(--primary);
}

.form-checkbox input[type="checkbox"] {
    width: 20px;
    height: 20px;
    cursor: pointer;
    accent-color: var(--primary);
    flex-shrink: 0;
}

.form-checkbox label {
    cursor: pointer;
    user-select: none;
    font-weight: 500;
    color: var(--text-primary);
    font-size: 14px;
    margin: 0;
}

/* ========== HELPER TEXT ========== */
.form-help {
    display: block;
    margin-top: 6px;
    font-size: 12px;
    color: var(--text-muted);
    line-height: 1.4;
}

.form-help svg {
    width: 14px;
    height: 14px;
    display: inline-block;
    vertical-align: middle;
    margin-right: 4px;
    color: var(--primary);
}

/* ========== CHARACTER COUNTER ========== */
.char-counter {
    display: block;
    margin-top: 6px;
    font-size: 12px;
    color: var(--text-muted);
    text-align: right;
    font-weight: 500;
}

.char-counter.warning {
    color: var(--warning);
}

.char-counter.danger {
    color: var(--danger);
}

/* ========== SELECT2 CUSTOM STYLING ========== */
.select2-container--default .select2-selection--single {
    background: var(--input-bg);
    border: 1px solid var(--input-border);
    border-radius: 10px;
    height: 48px;
    padding: 0 16px;
    transition: all 0.3s ease;
}

.select2-container--default .select2-selection--single:hover {
    border-color: var(--primary);
}

.select2-container--default.select2-container--focus .select2-selection--single {
    border-color: var(--primary);
    background: var(--card-bg);
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    color: var(--input-text);
    line-height: 48px;
    padding: 0;
}

.select2-container--default .select2-selection--single .select2-selection__placeholder {
    color: var(--text-muted);
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 48px;
    right: 16px;
}

.select2-dropdown {
    background: var(--card-bg);
    border: 1px solid var(--input-border);
    border-radius: 10px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    animation: fadeInUp 0.2s ease;
}

.select2-container--default .select2-results__option {
    padding: 10px 14px;
    color: var(--text-primary);
}

.select2-container--default .select2-results__option--highlighted[aria-selected] {
    background: var(--primary);
    color: white;
}

.select2-container--default .select2-results__option[aria-selected=true] {
    background: var(--primary-light);
    color: var(--primary);
}

.select2-container--default .select2-search--dropdown .select2-search__field {
    background: var(--input-bg);
    border: 1px solid var(--input-border);
    color: var(--input-text);
    border-radius: 8px;
    padding: 8px 12px;
}

.select2-container--default .select2-search--dropdown .select2-search__field:focus {
    border-color: var(--primary);
    outline: none;
}

/* ========== PROJECT HIGHLIGHT ========== */
.project-highlight {
    background: rgba(59, 130, 246, 0.05);
    border: 1px solid rgba(59, 130, 246, 0.2);
    transition: all 0.3s ease;
}

/* ========== RESPONSIVE ========== */
@media (max-width: 768px) {
    .form-page {
        padding: 16px;
    }
    
    .form-header h1 {
        font-size: 22px;
    }
    
    .form-card-body {
        padding: 20px;
    }
    
    .form-actions {
        flex-direction: column;
    }
    
    .btn-submit,
    .btn-cancel {
        width: 100%;
        justify-content: center;
    }
}
</style>

<div class="form-page">
    <!-- HEADER -->
    <div class="form-header">
        <a href="{{ route('admin.milestones.index') }}" class="btn-back" title="Back to Milestones">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M19 12H5M12 19l-7-7 7-7"/>
            </svg>
        </a>
        <h1>Create New Milestone</h1>
    </div>

    <!-- ERROR ALERTS -->
    @if($errors->any())
    <div class="alert-errors">
        <strong>⚠️ Please fix the following errors:</strong>
        <ul>
            @foreach($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <!-- FORM -->
    <form action="{{ route('admin.milestones.store') }}" method="POST" id="milestoneForm">
        @csrf
        <div class="form-card">
            <div class="form-card-body">
                
                <!-- ========== MILESTONE INFORMATION ========== -->
                <div class="section-header">
                    <svg class="section-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="12" cy="12" r="10"/>
                        <polyline points="12 6 12 12 16 14"/>
                    </svg>
                    <h3 class="section-title">Milestone Information</h3>
                </div>

                <div class="form-group">
                    <label class="form-label">
                        <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/>
                            <polyline points="9 22 9 12 15 12 15 22"/>
                        </svg>
                        Project <span class="required">*</span>
                    </label>
                    <select name="project_id" id="project-select" class="form-select" required>
                        <option value="">-- Select Project --</option>
                        @foreach($projects as $project)
                        <option value="{{ $project->id }}" {{ old('project_id') == $project->id ? 'selected' : '' }}>
                            {{ $project->title }}
                        </option>
                        @endforeach
                    </select>
                    <span class="form-help">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="10"/>
                            <path d="M12 16v-4M12 8h.01"/>
                        </svg>
                        Select the project this milestone belongs to
                    </span>
                    @error('project_id')
                    <span class="form-error">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label">
                        <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                            <polyline points="14 2 14 8 20 8"/>
                            <line x1="16" y1="13" x2="8" y2="13"/>
                            <line x1="16" y1="17" x2="8" y2="17"/>
                            <polyline points="10 9 9 9 8 9"/>
                        </svg>
                        Milestone Name <span class="required">*</span>
                    </label>
                    <input 
                        type="text" 
                        name="name" 
                        id="milestone-name"
                        class="form-input" 
                        value="{{ old('name') }}" 
                        placeholder="e.g., Phase 1 - Discovery, Beta Release, Final Delivery"
                        required
                        maxlength="191"
                        autocomplete="off"
                    >
                    @error('name')
                    <span class="form-error">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label">
                        <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                            <polyline points="14 2 14 8 20 8"/>
                            <line x1="16" y1="13" x2="8" y2="13"/>
                            <line x1="16" y1="17" x2="8" y2="17"/>
                        </svg>
                        Description
                        <span class="label-hint">Optional</span>
                    </label>
                    <textarea 
                        name="description" 
                        id="description"
                        class="form-textarea"
                        placeholder="Describe the scope, deliverables, and acceptance criteria for this milestone..."
                        maxlength="65535"
                    >{{ old('description') }}</textarea>
                    <span class="char-counter" id="desc-counter">0 / 65535 characters</span>
                    @error('description')
                    <span class="form-error">{{ $message }}</span>
                    @enderror
                </div>

                <div class="section-divider"></div>

                <!-- ========== SCHEDULE & SETTINGS ========== -->
                <div class="section-header">
                    <svg class="section-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <rect x="3" y="4" width="18" height="18" rx="2" ry="2"/>
                        <line x1="16" y1="2" x2="16" y2="6"/>
                        <line x1="8" y1="2" x2="8" y2="6"/>
                        <line x1="3" y1="10" x2="21" y2="10"/>
                    </svg>
                    <h3 class="section-title">Schedule & Settings</h3>
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label class="form-label">
                            <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <rect x="3" y="4" width="18" height="18" rx="2" ry="2"/>
                                <line x1="16" y1="2" x2="16" y2="6"/>
                                <line x1="8" y1="2" x2="8" y2="6"/>
                                <line x1="3" y1="10" x2="21" y2="10"/>
                                <path d="M8 14h.01M12 14h.01M16 14h.01M8 18h.01M12 18h.01M16 18h.01"/>
                            </svg>
                            Target Date
                        </label>
                        <input 
                            type="date" 
                            name="target_date" 
                            id="target-date"
                            class="form-input"
                            value="{{ old('target_date') }}"
                        >
                        <span class="form-help">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <circle cx="12" cy="12" r="10"/>
                                <path d="M12 16v-4M12 8h.01"/>
                            </svg>
                            Expected completion date for this milestone
                        </span>
                        @error('target_date')
                        <span class="form-error">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label class="form-label">
                            <svg class="label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <line x1="8" y1="6" x2="21" y2="6"/>
                                <line x1="8" y1="12" x2="21" y2="12"/>
                                <line x1="8" y1="18" x2="21" y2="18"/>
                                <line x1="3" y1="6" x2="3.01" y2="6"/>
                                <line x1="3" y1="12" x2="3.01" y2="12"/>
                                <line x1="3" y1="18" x2="3.01" y2="18"/>
                            </svg>
                            Sort Order
                        </label>
                        <input 
                            type="number" 
                            name="sort_order" 
                            class="form-input" 
                            min="0"
                            step="1"
                            placeholder="0"
                            value="{{ old('sort_order', 0) }}"
                        >
                        <span class="form-help">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <circle cx="12" cy="12" r="10"/>
                                <path d="M12 16v-4M12 8h.01"/>
                            </svg>
                            Lower numbers appear first in lists
                        </span>
                        @error('sort_order')
                        <span class="form-error">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <div class="form-checkbox">
                    <input 
                        type="checkbox" 
                        name="portal_visible" 
                        id="portal_visible" 
                        value="1" 
                        {{ old('portal_visible') ? 'checked' : '' }}
                    >
                    <label for="portal_visible">
                        <strong>Visible in Customer Portal</strong> — Customers will be able to see this milestone
                    </label>
                </div>
            </div>

            <!-- ========== FORM ACTIONS ========== -->
            <div class="form-actions">
                <button type="submit" class="btn-submit" id="submitBtn">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="12" cy="12" r="10"/>
                        <line x1="12" y1="8" x2="12" y2="16"/>
                        <line x1="8" y1="12" x2="16" y2="12"/>
                    </svg>
                    Create Milestone
                </button>
                <a href="{{ route('admin.milestones.index') }}" class="btn-cancel">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="12" cy="12" r="10"/>
                        <line x1="15" y1="9" x2="9" y2="15"/>
                        <line x1="9" y1="9" x2="15" y2="15"/>
                    </svg>
                    Cancel
                </a>
            </div>
        </div>
    </form>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
$(document).ready(function() {
    // ========== SELECT2 INITIALIZATION ==========
    $('#project-select').select2({
        placeholder: 'Search and select a project...',
        allowClear: true,
        width: '100%',
        theme: 'default',
        language: {
            noResults: function() {
                return "No projects found";
            },
            searching: function() {
                return "Searching...";
            }
        }
    });

    // ========== PROJECT HIGHLIGHT ==========
    const projectSelect = document.getElementById('project-select');
    if (projectSelect) {
        projectSelect.closest('.form-group').classList.add('project-highlight');
    }

    // ========== DATE VALIDATION ==========
    const targetDate = document.getElementById('target-date');
    
    targetDate.addEventListener('change', function() {
        const selected = new Date(this.value);
        const today = new Date();
        today.setHours(0, 0, 0, 0);
        
        if (selected < today) {
            alert('⚠️ Target date cannot be in the past!');
            this.value = '';
            this.classList.add('error');
            setTimeout(() => this.classList.remove('error'), 2000);
        }
    });

    // ========== CHARACTER COUNTER ==========
    function setupCharCounter(textareaId, counterId, maxLength) {
        const textarea = document.getElementById(textareaId);
        const counter = document.getElementById(counterId);
        
        if (textarea && counter) {
            textarea.addEventListener('input', function() {
                const current = this.value.length;
                counter.textContent = `${current} / ${maxLength} characters`;
                
                counter.classList.remove('warning', 'danger');
                if (current > maxLength * 0.95) {
                    counter.classList.add('danger');
                } else if (current > maxLength * 0.85) {
                    counter.classList.add('warning');
                }
            });
        }
    }
    
    setupCharCounter('description', 'desc-counter', 65535);

    // ========== FORM VALIDATION & SUBMISSION ==========
    const form = document.getElementById('milestoneForm');
    const submitBtn = document.getElementById('submitBtn');
    
    form.addEventListener('submit', function(e) {
        submitBtn.classList.add('loading');
        submitBtn.disabled = true;
        
        const milestoneName = form.querySelector('[name="name"]');
        const projectId = form.querySelector('[name="project_id"]');
        
        // Validate milestone name
        if (!milestoneName.value.trim()) {
            e.preventDefault();
            milestoneName.classList.add('error');
            milestoneName.focus();
            resetSubmitButton();
            return false;
        }
        
        // Validate project selection
        if (!projectId.value) {
            e.preventDefault();
            projectId.classList.add('error');
            projectId.focus();
            resetSubmitButton();
            return false;
        }
    });
    
    function resetSubmitButton() {
        submitBtn.classList.remove('loading');
        submitBtn.disabled = false;
    }
    
    // Remove error class on input
    form.querySelectorAll('.form-input, .form-select, .form-textarea').forEach(input => {
        input.addEventListener('input', function() {
            this.classList.remove('error');
        });
    });

    // ========== AUTO-FOCUS ==========
    setTimeout(() => {
        document.querySelector('[name="project_id"]').focus();
    }, 300);

    // ========== CONFIRM NAVIGATION AWAY IF FORM DIRTY ==========
    let formDirty = false;
    
    form.querySelectorAll('input, select, textarea').forEach(field => {
        field.addEventListener('change', () => formDirty = true);
    });
    
    window.addEventListener('beforeunload', function(e) {
        if (formDirty && !submitBtn.classList.contains('loading')) {
            e.preventDefault();
            e.returnValue = '';
        }
    });
    
    form.addEventListener('submit', () => formDirty = false);
});
</script>