<style>
/* ========================================
   Milestone Detail - Theme-Aware (GUIDE COMPLIANT)
   ======================================== */

/* Page Animation */
.milestone-detail-page {
    padding: var(--space-xl);
    animation: fadeIn 0.4s ease;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

/* Slide In Animation */
@keyframes slideIn {
    from { opacity: 0; transform: translateX(-20px); }
    to { opacity: 1; transform: translateX(0); }
}

/* ===== HEADER WITH BACK BUTTON ===== */
.detail-header {
    display: flex;
    align-items: center;
    gap: var(--space-md);
    margin-bottom: var(--space-lg);
    animation: slideIn 0.3s ease;
}

.btn-back {
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: var(--radius-md);
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
}

.btn-back:hover {
    background: var(--primary);
    border-color: var(--primary);
    transform: translateX(-2px);
}

.btn-back svg {
    width: 18px;
    height: 18px;
    color: var(--text-primary);
    transition: all 0.3s ease;
}

.btn-back:hover svg {
    color: white;
}

.header-title-group {
    flex: 1;
}

.header-title-group h1 {
    font-size: var(--font-xl);
    font-weight: 700;
    color: var(--text-primary);
    margin: 0 0 4px 0;
    display: flex;
    align-items: center;
    gap: var(--space-sm);
}

.header-title-group h1 svg {
    width: 20px;
    height: 20px;
    color: var(--primary);
}

.header-subtitle {
    font-size: var(--font-sm);
    color: var(--text-muted);
    margin: 0;
}

/* ===== ACTION BUTTONS GROUP ===== */
.header-actions {
    display: flex;
    gap: var(--space-sm);
}

.btn {
    padding: 10px 16px;
    border-radius: var(--radius-md);
    font-size: var(--font-sm);
    font-weight: 600;
    border: none;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    text-decoration: none;
    transition: all 0.3s ease;
}

.btn svg {
    width: 16px;
    height: 16px;
}

.btn-primary {
    background: var(--primary);
    color: white;
}

.btn-primary:hover {
    background: var(--primary-hover);
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
}

.btn-success {
    background: var(--success);
    color: white;
}

.btn-success:hover {
    background: #059669;
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
}

.btn-warning {
    background: var(--warning);
    color: white;
}

.btn-warning:hover {
    background: #d97706;
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
}

.btn-danger {
    background: var(--danger);
    color: white;
}

.btn-danger:hover {
    background: #dc2626;
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
}

/* ===== MAIN CONTENT GRID ===== */
.detail-grid {
    display: grid;
    grid-template-columns: 2fr 1fr;
    gap: var(--space-lg);
}

/* ===== DETAIL CARD ===== */
.detail-card {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: var(--radius-lg);
    padding: var(--space-xl);
    box-shadow: var(--shadow-sm);
    animation: fadeIn 0.4s ease 0.1s backwards;
}

.detail-card-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: var(--space-lg);
    padding-bottom: var(--space-md);
    border-bottom: 1px solid var(--card-border);
}

.card-title {
    font-size: var(--font-lg);
    font-weight: 700;
    color: var(--text-primary);
    margin: 0;
    display: flex;
    align-items: center;
    gap: var(--space-sm);
}

.card-title svg {
    width: 18px;
    height: 18px;
    color: var(--primary);
}

/* ===== DETAIL ROWS ===== */
.detail-row {
    display: flex;
    padding: var(--space-md) 0;
    border-bottom: 1px solid var(--card-border);
    transition: all 0.3s ease;
}

.detail-row:last-child {
    border-bottom: none;
}

.detail-row:hover {
    background: var(--input-bg);
    margin: 0 calc(var(--space-md) * -1);
    padding-left: var(--space-md);
    padding-right: var(--space-md);
    border-radius: var(--radius-sm);
}

.detail-label {
    width: 180px;
    font-size: var(--font-sm);
    font-weight: 600;
    color: var(--text-secondary);
    display: flex;
    align-items: center;
    gap: var(--space-sm);
    flex-shrink: 0;
}

.detail-label svg {
    width: 16px;
    height: 16px;
    color: var(--text-muted);
}

.detail-value {
    flex: 1;
    font-size: var(--font-base);
    color: var(--text-primary);
    font-weight: 500;
}

/* ===== BADGES ===== */
.badge {
    padding: 6px 12px;
    border-radius: 16px;
    font-size: var(--font-xs);
    font-weight: 600;
    text-transform: uppercase;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    transition: all 0.3s ease;
}

.badge svg {
    width: 14px;
    height: 14px;
}

.badge-success {
    background: var(--success-light);
    color: var(--success);
}

.badge-warning {
    background: var(--warning-light);
    color: var(--warning);
}

.badge-danger {
    background: var(--danger-light);
    color: var(--danger);
}

/* ===== DESCRIPTION BOX ===== */
.description-box {
    background: var(--input-bg);
    border: 1px solid var(--card-border);
    border-radius: var(--radius-md);
    padding: var(--space-md);
    font-size: var(--font-sm);
    color: var(--text-primary);
    line-height: 1.6;
    white-space: pre-wrap;
    min-height: 80px;
}

.description-box.empty {
    color: var(--text-muted);
    font-style: italic;
}

/* ===== SIDEBAR CARDS ===== */
.sidebar-card {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: var(--radius-lg);
    padding: var(--space-lg);
    box-shadow: var(--shadow-sm);
    margin-bottom: var(--space-lg);
}

.sidebar-card:nth-child(1) {
    animation: fadeIn 0.4s ease 0.2s backwards;
}

.sidebar-card:nth-child(2) {
    animation: fadeIn 0.4s ease 0.3s backwards;
}

.sidebar-card:nth-child(3) {
    animation: fadeIn 0.4s ease 0.4s backwards;
}

.sidebar-card-title {
    font-size: var(--font-base);
    font-weight: 700;
    color: var(--text-primary);
    margin: 0 0 var(--space-md) 0;
    display: flex;
    align-items: center;
    gap: var(--space-sm);
}

.sidebar-card-title svg {
    width: 16px;
    height: 16px;
    color: var(--primary);
}

/* ===== PROJECT LINK ===== */
.project-link {
    display: flex;
    align-items: center;
    gap: var(--space-sm);
    padding: var(--space-md);
    background: var(--input-bg);
    border: 1px solid var(--card-border);
    border-radius: var(--radius-md);
    text-decoration: none;
    transition: all 0.3s ease;
}

.project-link:hover {
    background: var(--primary-light);
    border-color: var(--primary);
    transform: translateX(4px);
}

.project-icon {
    width: 40px;
    height: 40px;
    background: var(--primary);
    border-radius: var(--radius-md);
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.project-icon svg {
    width: 20px;
    height: 20px;
    color: white;
}

.project-info h4 {
    font-size: var(--font-sm);
    font-weight: 600;
    color: var(--text-primary);
    margin: 0 0 2px 0;
}

.project-info p {
    font-size: var(--font-xs);
    color: var(--text-muted);
    margin: 0;
}

/* ===== TIMELINE ITEM ===== */
.timeline-item {
    display: flex;
    align-items: center;
    gap: var(--space-sm);
    padding: var(--space-sm) 0;
}

.timeline-icon {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.timeline-icon svg {
    width: 16px;
    height: 16px;
    color: white;
}

.timeline-icon.success {
    background: var(--success);
}

.timeline-icon.warning {
    background: var(--warning);
}

.timeline-icon.danger {
    background: var(--danger);
}

.timeline-content h5 {
    font-size: var(--font-sm);
    font-weight: 600;
    color: var(--text-primary);
    margin: 0 0 2px 0;
}

.timeline-content p {
    font-size: var(--font-xs);
    color: var(--text-muted);
    margin: 0;
}

/* ===== PROGRESS BAR ===== */
.progress-container {
    margin-top: var(--space-sm);
}

.progress-label {
    display: flex;
    justify-content: space-between;
    font-size: var(--font-xs);
    color: var(--text-muted);
    margin-bottom: 6px;
}

.progress-bar-bg {
    height: 8px;
    background: var(--input-bg);
    border-radius: 4px;
    overflow: hidden;
}

.progress-bar-fill {
    height: 100%;
    background: var(--success);
    border-radius: 4px;
    transition: width 0.5s ease;
}

/* ===== EMPTY STATE ===== */
.empty-state-small {
    text-align: center;
    padding: var(--space-lg) var(--space-md);
    color: var(--text-muted);
    font-size: var(--font-sm);
}

.empty-state-small svg {
    width: 32px;
    height: 32px;
    margin-bottom: var(--space-sm);
    opacity: 0.5;
}

/* ===== LOADING OVERLAY ===== */
.loading-overlay {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    z-index: 9999;
    align-items: center;
    justify-content: center;
}

.loading-overlay.active {
    display: flex;
}

@keyframes spin {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}

.spinner {
    width: 40px;
    height: 40px;
    border: 4px solid var(--card-bg);
    border-top: 4px solid var(--primary);
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

/* ===== RESPONSIVE ===== */
@media (max-width: 992px) {
    .detail-grid {
        grid-template-columns: 1fr;
    }
    
    .header-actions {
        flex-wrap: wrap;
    }
}

@media (max-width: 768px) {
    .milestone-detail-page {
        padding: var(--space-md);
    }
    
    .detail-header {
        flex-wrap: wrap;
    }
    
    .detail-row {
        flex-direction: column;
        gap: var(--space-sm);
    }
    
    .detail-label {
        width: 100%;
    }
    
    .header-actions {
        width: 100%;
    }
    
    .btn {
        flex: 1;
        justify-content: center;
    }
}
</style>

<div class="milestone-detail-page">
    <!-- Header with Back Button -->
    <div class="detail-header">
        <a href="{{ route('admin.milestones.index') }}" class="btn-back">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"/>
            </svg>
        </a>

        <div class="header-title-group">
            <h1>
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"/>
                </svg>
                {{ $milestone->name }}
            </h1>
            <p class="header-subtitle">Milestone Details</p>
        </div>

        <div class="header-actions">
            @if($milestone->is_completed)
                <form action="{{ route('admin.milestones.update', $milestone->id) }}" method="POST" style="display: inline;">
                    @csrf
                    @method('PUT')
                    <input type="hidden" name="is_completed" value="0">
                    <input type="hidden" name="project_id" value="{{ $milestone->project_id }}">
                    <input type="hidden" name="name" value="{{ $milestone->name }}">
                    <button type="submit" class="btn btn-warning">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                        </svg>
                        Mark Incomplete
                    </button>
                </form>
            @else
                <form action="{{ route('admin.milestones.update', $milestone->id) }}" method="POST" style="display: inline;">
                    @csrf
                    @method('PUT')
                    <input type="hidden" name="is_completed" value="1">
                    <input type="hidden" name="project_id" value="{{ $milestone->project_id }}">
                    <input type="hidden" name="name" value="{{ $milestone->name }}">
                    <button type="submit" class="btn btn-success">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        Mark Complete
                    </button>
                </form>
            @endif

            <a href="{{ route('admin.milestones.edit', $milestone->id) }}" class="btn btn-primary">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                </svg>
                Edit
            </a>

            <button onclick="deleteMilestone()" class="btn btn-danger">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                </svg>
                Delete
            </button>
        </div>
    </div>

    <!-- Main Content Grid -->
    <div class="detail-grid">
        <!-- Left Column - Main Details -->
        <div>
            <!-- Milestone Information Card -->
            <div class="detail-card">
                <div class="detail-card-header">
                    <h2 class="card-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        Milestone Information
                    </h2>
                </div>

                <div class="detail-row">
                    <div class="detail-label">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                        </svg>
                        Milestone ID
                    </div>
                    <div class="detail-value">
                        <strong>#{{ $milestone->id }}</strong>
                    </div>
                </div>

                <div class="detail-row">
                    <div class="detail-label">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                        </svg>
                        Milestone Name
                    </div>
                    <div class="detail-value">
                        <strong>{{ $milestone->name }}</strong>
                    </div>
                </div>

                <div class="detail-row">
                    <div class="detail-label">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        Status
                    </div>
                    <div class="detail-value">
                        @if($milestone->is_completed)
                            <span class="badge badge-success">
                                <svg fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                </svg>
                                Completed
                            </span>
                        @elseif($milestone->target_date && \Carbon\Carbon::parse($milestone->target_date)->isPast())
                            <span class="badge badge-danger">
                                <svg fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                                </svg>
                                Overdue
                            </span>
                        @else
                            <span class="badge badge-warning">
                                <svg fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd"/>
                                </svg>
                                In Progress
                            </span>
                        @endif
                    </div>
                </div>

                <div class="detail-row">
                    <div class="detail-label">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                        </svg>
                        Target Date
                    </div>
                    <div class="detail-value">
                        @if($milestone->target_date)
                            {{ \Carbon\Carbon::parse($milestone->target_date)->format('F d, Y') }}
                            @if(!$milestone->is_completed)
                                @php
                                    $targetDate = \Carbon\Carbon::parse($milestone->target_date);
                                    $now = \Carbon\Carbon::now();
                                @endphp
                                @if($targetDate->isPast())
                                    <span style="color: var(--danger); font-size: var(--font-xs); font-weight: 600;">
                                        (Overdue by {{ $now->diffInDays($targetDate) }} days)
                                    </span>
                                @else
                                    <span style="color: var(--warning); font-size: var(--font-xs); font-weight: 600;">
                                        ({{ $targetDate->diffInDays($now) }} days remaining)
                                    </span>
                                @endif
                            @endif
                        @else
                            <span style="color: var(--text-muted);">No target date set</span>
                        @endif
                    </div>
                </div>

                @if($milestone->is_completed && $milestone->completed_at)
                <div class="detail-row">
                    <div class="detail-label">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        Completed Date
                    </div>
                    <div class="detail-value">
                        {{ \Carbon\Carbon::parse($milestone->completed_at)->format('F d, Y \a\t g:i A') }}
                    </div>
                </div>
                @endif

                <div class="detail-row">
                    <div class="detail-label">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                            <path stroke-linecap="round" stroke-linejoin="round" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                        </svg>
                        Portal Visible
                    </div>
                    <div class="detail-value">
                        @if($milestone->portal_visible)
                            <span style="color: var(--success); font-weight: 600;">Yes</span>
                        @else
                            <span style="color: var(--text-muted);">No</span>
                        @endif
                    </div>
                </div>

                <div class="detail-row">
                    <div class="detail-label">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M7 16V4m0 0L3 8m4-4l4 4m6 0v12m0 0l4-4m-4 4l-4-4"/>
                        </svg>
                        Sort Order
                    </div>
                    <div class="detail-value">
                        {{ $milestone->sort_order }}
                    </div>
                </div>
            </div>

            <!-- Description Card -->
            <div class="detail-card" style="margin-top: var(--space-lg);">
                <div class="detail-card-header">
                    <h2 class="card-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16M4 18h7"/>
                        </svg>
                        Description
                    </h2>
                </div>

                <div class="description-box {{ empty($milestone->description) ? 'empty' : '' }}">
                    {{ $milestone->description ?? 'No description provided' }}
                </div>
            </div>
        </div>

        <!-- Right Column - Sidebar -->
        <div>
            <!-- Project Card -->
            <div class="sidebar-card">
                <h3 class="sidebar-card-title">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-6l-2-2H5a2 2 0 00-2 2z"/>
                    </svg>
                    Project
                </h3>

                @if($milestone->project)
                    <a href="{{ route('admin.projects.show', $milestone->project->id) }}" class="project-link">
                        <div class="project-icon">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-6l-2-2H5a2 2 0 00-2 2z"/>
                            </svg>
                        </div>
                        <div class="project-info">
                            <h4>{{ $milestone->project->title }}</h4>
                            <p>View Project</p>
                        </div>
                    </a>
                @else
                    <div class="empty-state-small">
                        <svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-6l-2-2H5a2 2 0 00-2 2z"/>
                        </svg>
                        <p>No project assigned</p>
                    </div>
                @endif
            </div>

            <!-- Timeline Card -->
            <div class="sidebar-card">
                <h3 class="sidebar-card-title">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    Timeline
                </h3>

                <div class="timeline-item">
                    <div class="timeline-icon {{ $milestone->is_completed ? 'success' : ($milestone->target_date && \Carbon\Carbon::parse($milestone->target_date)->isPast() ? 'danger' : 'warning') }}">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"/>
                        </svg>
                    </div>
                    <div class="timeline-content">
                        <h5>Created</h5>
                        <p>{{ $milestone->created_at->format('F d, Y \a\t g:i A') }}</p>
                    </div>
                </div>

                @if($milestone->is_completed && $milestone->completed_at)
                <div class="timeline-item">
                    <div class="timeline-icon success">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/>
                        </svg>
                    </div>
                    <div class="timeline-content">
                        <h5>Completed</h5>
                        <p>{{ \Carbon\Carbon::parse($milestone->completed_at)->format('F d, Y \a\t g:i A') }}</p>
                    </div>
                </div>
                @endif

                <div class="timeline-item">
                    <div class="timeline-icon warning">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                        </svg>
                    </div>
                    <div class="timeline-content">
                        <h5>Last Updated</h5>
                        <p>{{ $milestone->updated_at->format('F d, Y \a\t g:i A') }}</p>
                    </div>
                </div>
            </div>

            <!-- Metadata Card -->
            <div class="sidebar-card">
                <h3 class="sidebar-card-title">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                    </svg>
                    Created By
                </h3>

                @if($milestone->creator)
                    <div style="display: flex; align-items: center; gap: var(--space-sm); padding: var(--space-sm) 0;">
                        <div style="width: 36px; height: 36px; background: var(--primary); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-weight: 600; font-size: var(--font-sm);">
                            {{ strtoupper(substr($milestone->creator->name, 0, 1)) }}
                        </div>
                        <div>
                            <h5 style="margin: 0; font-size: var(--font-sm); font-weight: 600; color: var(--text-primary);">
                                {{ $milestone->creator->name }}
                            </h5>
                            <p style="margin: 0; font-size: var(--font-xs); color: var(--text-muted);">
                                {{ $milestone->creator->email }}
                            </p>
                        </div>
                    </div>
                @else
                    <div class="empty-state-small">
                        <svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                        </svg>
                        <p>Creator unknown</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Loading Overlay -->
<div class="loading-overlay" id="loadingOverlay">
    <div class="spinner"></div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
function deleteMilestone() {
    if (!confirm('Are you sure you want to delete this milestone? This action cannot be undone.')) {
        return;
    }

    $('#loadingOverlay').addClass('active');

    $.ajax({
        url: '{{ route("admin.milestones.destroy", $milestone->id) }}',
        type: 'DELETE',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function(response) {
            $('#loadingOverlay').removeClass('active');
            if (response.success) {
                alert(response.message || 'Milestone deleted successfully');
                window.location.href = '{{ route("admin.milestones.index") }}';
            }
        },
        error: function(xhr) {
            $('#loadingOverlay').removeClass('active');
            alert('Delete failed: ' + (xhr.responseJSON?.message || 'Unknown error'));
        }
    });
}
</script>