<style>
/* Base Styles & Animations */
.finance-view { 
    padding: 20px; 
    max-width: 1400px; 
    margin: 0 auto;
    animation: fadeInUp 0.5s ease;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

@keyframes slideIn {
    from {
        opacity: 0;
        transform: translateX(-10px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

@keyframes pulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.05); }
}

@keyframes shimmer {
    0% { background-position: -1000px 0; }
    100% { background-position: 1000px 0; }
}

/* Header */
.finance-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 24px;
    animation: slideIn 0.3s ease;
}

.finance-title-section { 
    display: flex; 
    align-items: center; 
    gap: 16px; 
}

.btn-back {
    width: 40px; 
    height: 40px;
    display: flex; 
    align-items: center; 
    justify-content: center;
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 10px;
    text-decoration: none;
    color: var(--text-primary);
    transition: all 0.3s ease;
}

.btn-back:hover {
    background: var(--primary);
    color: white;
    transform: translateX(-3px);
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
}

.project-subtitle {
    display: flex;
    align-items: center;
    gap: 8px;
    margin: 4px 0 0 0; 
    color: var(--text-secondary);
    font-size: 14px;
}

/* Stats Grid */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
    gap: 16px;
    margin-bottom: 24px;
}

.stat-card {
    background: linear-gradient(135deg, var(--card-bg) 0%, var(--body-bg) 100%);
    border: 1px solid var(--card-border);
    border-radius: 12px;
    padding: 24px;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
    animation: fadeInUp 0.6s ease;
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 4px;
    height: 100%;
    background: var(--primary);
    transform: scaleY(0);
    transition: transform 0.3s ease;
}

.stat-card:hover::before {
    transform: scaleY(1);
}

.stat-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
    border-color: var(--primary);
}

.stat-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 12px;
}

.stat-icon-wrapper {
    width: 48px;
    height: 48px;
    padding: 10px;
    background: var(--primary-light);
    border-radius: 12px;
    color: var(--primary);
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
}

.stat-card:hover .stat-icon-wrapper {
    transform: rotate(5deg) scale(1.1);
}

.stat-icon {
    width: 28px;
    height: 28px;
}

.stat-value {
    font-size: 32px;
    font-weight: 700;
    color: var(--primary);
    line-height: 1;
    margin: 8px 0;
}

.stat-value.money {
    color: var(--success);
}

.stat-value.unbilled {
    color: var(--warning);
}

.stat-label {
    font-size: 14px;
    color: var(--text-secondary);
    font-weight: 500;
}

/* Info Card */
.info-card {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 12px;
    padding: 24px;
    animation: fadeInUp 0.7s ease;
    margin-bottom: 24px;
}

.card-header {
    display: flex;
    align-items: center;
    gap: 12px;
    margin-bottom: 24px;
    padding-bottom: 12px;
    border-bottom: 2px solid var(--card-border);
}

.card-icon {
    width: 24px;
    height: 24px;
    color: var(--primary);
}

.card-title {
    font-size: 18px;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0;
}

.info-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 16px;
    border-bottom: 1px solid var(--card-border);
    transition: all 0.3s ease;
    border-radius: 8px;
}

.info-row:hover {
    background: var(--body-bg);
    transform: translateX(4px);
}

.info-row:last-child { 
    border-bottom: none; 
}

.info-label {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    color: var(--text-secondary);
    font-weight: 500;
}

.info-label-icon {
    width: 18px;
    height: 18px;
    color: var(--text-muted);
}

.info-value {
    font-size: 16px;
    font-weight: 700;
    color: var(--text-primary);
}

.info-value.highlight {
    color: var(--primary);
    font-size: 18px;
}

.info-value.success {
    color: var(--success);
}

.info-value.warning {
    color: var(--warning);
}

/* Empty State */
.empty-state {
    text-align: center;
    padding: 60px 20px;
    color: var(--text-muted);
}

.empty-state-icon {
    width: 80px;
    height: 80px;
    margin: 0 auto 20px;
    opacity: 0.3;
}

/* Billing Method Badge */
.billing-badge {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 6px 14px;
    background: var(--primary-light);
    color: var(--primary);
    border-radius: 20px;
    font-size: 14px;
    font-weight: 600;
}

/* Action Button */
.btn-generate {
    padding: 12px 24px;
    background: var(--success);
    color: white;
    border: none;
    border-radius: 10px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    text-decoration: none;
}

.btn-generate:hover {
    background: #059669;
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(16, 185, 129, 0.4);
}

.btn-icon {
    width: 18px;
    height: 18px;
}

/* Responsive */
@media (max-width: 768px) {
    .finance-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 16px;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .info-row {
        flex-direction: column;
        align-items: flex-start;
        gap: 8px;
    }
}
</style>

<div class="finance-view">
    <!-- Header -->
    <div class="finance-header">
        <div class="finance-title-section">
            <a href="{{ route('admin.projects.show', $project->id) }}" class="btn-back" title="Back to Project">
                <!-- Back Arrow SVG -->
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M19 12H5M12 19l-7-7 7-7"/>
                </svg>
            </a>
            <div>
                <h1 style="margin: 0; font-size: 28px;">Finance Overview</h1>
                <div class="project-subtitle">
                    <!-- Project Icon SVG -->
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/>
                        <polyline points="9 22 9 12 15 12 15 22"/>
                    </svg>
                    {{ $project->title }}
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Grid -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-header">
                <div class="stat-icon-wrapper">
                    <!-- Clock Icon SVG -->
                    <svg class="stat-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="12" cy="12" r="10"/>
                        <polyline points="12 6 12 12 16 14"/>
                    </svg>
                </div>
            </div>
            <div class="stat-value">{{ number_format($stats['total_hours'], 1) }}</div>
            <div class="stat-label">Total Hours Logged</div>
        </div>

        <div class="stat-card">
            <div class="stat-header">
                <div class="stat-icon-wrapper">
                    <!-- Billable Icon SVG -->
                    <svg class="stat-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/>
                        <polyline points="22 4 12 14.01 9 11.01"/>
                    </svg>
                </div>
            </div>
            <div class="stat-value">{{ number_format($stats['billable_hours'], 1) }}</div>
            <div class="stat-label">Billable Hours</div>
        </div>

        <div class="stat-card">
            <div class="stat-header">
                <div class="stat-icon-wrapper" style="background: var(--warning-light); color: var(--warning);">
                    <!-- Unbilled Hours Icon SVG -->
                    <svg class="stat-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="12" cy="12" r="10"/>
                        <line x1="12" y1="8" x2="12" y2="12"/>
                        <line x1="12" y1="16" x2="12.01" y2="16"/>
                    </svg>
                </div>
            </div>
            <div class="stat-value unbilled">{{ number_format($stats['unbilled_hours'], 1) }}</div>
            <div class="stat-label">Unbilled Hours</div>
        </div>

        <div class="stat-card">
            <div class="stat-header">
                <div class="stat-icon-wrapper" style="background: var(--success-light); color: var(--success);">
                    <!-- Money Icon SVG -->
                    <svg class="stat-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="12" y1="1" x2="12" y2="23"/>
                        <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/>
                    </svg>
                </div>
            </div>
            <div class="stat-value money">₹{{ number_format($stats['unbilled_amount'], 2) }}</div>
            <div class="stat-label">Unbilled Amount</div>
        </div>
    </div>

    <!-- Billing Summary Card -->
    <div class="info-card">
        <div class="card-header">
            <!-- Summary Icon SVG -->
            <svg class="card-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <rect x="1" y="4" width="22" height="16" rx="2" ry="2"/>
                <line x1="1" y1="10" x2="23" y2="10"/>
            </svg>
            <h3 class="card-title">Billing Summary</h3>
        </div>
        
        <div class="info-row">
            <div class="info-label">
                <!-- Method Icon SVG -->
                <svg class="info-label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M12 2v20M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/>
                </svg>
                Billing Method
            </div>
            <div class="info-value">
                <span class="billing-badge">{{ ucfirst(str_replace('_', ' ', $project->billing_method)) }}</span>
            </div>
        </div>

        @if($project->billing_method === 'fixed')
        <div class="info-row">
            <div class="info-label">
                <!-- Fixed Amount Icon SVG -->
                <svg class="info-label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <rect x="2" y="7" width="20" height="14" rx="2" ry="2"/>
                    <path d="M16 21V5a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v16"/>
                </svg>
                Fixed Amount
            </div>
            <div class="info-value success">₹{{ number_format($project->fixed_amount, 2) }}</div>
        </div>
        @else
        <div class="info-row">
            <div class="info-label">
                <!-- Hourly Rate Icon SVG -->
                <svg class="info-label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <circle cx="12" cy="12" r="10"/>
                    <polyline points="12 6 12 12 16 14"/>
                </svg>
                Hourly Rate
            </div>
            <div class="info-value success">₹{{ number_format($project->hourly_rate, 2) }}/hour</div>
        </div>
        @endif

        <div class="info-row">
            <div class="info-label">
                <!-- Billed Icon SVG -->
                <svg class="info-label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                    <polyline points="14 2 14 8 20 8"/>
                    <line x1="16" y1="13" x2="8" y2="13"/>
                    <line x1="16" y1="17" x2="8" y2="17"/>
                    <polyline points="10 9 9 9 8 9"/>
                </svg>
                Total Billed Amount
            </div>
            <div class="info-value success">₹{{ number_format($stats['billed_amount'], 2) }}</div>
        </div>

        <div class="info-row">
            <div class="info-label">
                <!-- Unbilled Icon SVG -->
                <svg class="info-label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <circle cx="12" cy="12" r="10"/>
                    <line x1="15" y1="9" x2="9" y2="15"/>
                    <line x1="9" y1="9" x2="15" y2="15"/>
                </svg>
                Total Unbilled Amount
            </div>
            <div class="info-value highlight warning">₹{{ number_format($stats['unbilled_amount'], 2) }}</div>
        </div>
    </div>

    <!-- Generate Invoice Section -->
    @if($stats['unbilled_amount'] > 0)
    <div class="info-card">
        <div class="card-header">
            <!-- Invoice Icon SVG -->
            <svg class="card-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                <polyline points="14 2 14 8 20 8"/>
                <line x1="16" y1="13" x2="8" y2="13"/>
                <line x1="16" y1="17" x2="8" y2="17"/>
                <polyline points="10 9 9 9 8 9"/>
            </svg>
            <h3 class="card-title">Invoice Actions</h3>
        </div>
        
        <div style="padding: 20px; text-align: center;">
            <p style="margin: 0 0 20px 0; color: var(--text-secondary);">
                You have <strong style="color: var(--warning);">₹{{ number_format($stats['unbilled_amount'], 2) }}</strong> ready to be invoiced
            </p>
            <button class="btn-generate" onclick="generateInvoice()">
                <!-- Plus Circle Icon SVG -->
                <svg class="btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <circle cx="12" cy="12" r="10"/>
                    <line x1="12" y1="8" x2="12" y2="16"/>
                    <line x1="8" y1="12" x2="16" y2="12"/>
                </svg>
                Generate Invoice
            </button>
        </div>
    </div>
    @endif

    <!-- Empty State for No Unbilled Amount -->
    @if($stats['unbilled_amount'] == 0 && $stats['total_hours'] > 0)
    <div class="info-card">
        <div class="empty-state">
            <!-- Check Circle Icon SVG -->
            <svg class="empty-state-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/>
                <polyline points="22 4 12 14.01 9 11.01"/>
            </svg>
            <h3 style="margin: 0 0 8px 0; color: var(--success);">All Caught Up!</h3>
            <p style="margin: 0; font-size: 16px;">All billable hours have been invoiced</p>
        </div>
    </div>
    @endif
</div>

<script>
function generateInvoice() {
    // Placeholder for invoice generation
    alert('Invoice generation functionality will be integrated with your Invoice module');
    
    // You can add AJAX call here later:
    /*
    fetch('{{ route("admin.projects.generate-invoice", $project->id) }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        }
    })
    .then(response => response.json())
    .then(data => {
        if(data.success) {
            alert(data.message);
        }
    });
    */
}
</script>