<style>
/* Base Styles & Animations */
.project-view { 
    padding: 20px; 
    max-width: 1400px;
    margin: 0 auto;
    animation: fadeInUp 0.5s ease;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

@keyframes slideIn {
    from {
        opacity: 0;
        transform: translateX(-10px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

@keyframes pulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.05); }
}

@keyframes bounce {
    0%, 100% { transform: translateY(0); }
    50% { transform: translateY(-5px); }
}

/* ==================== TASKS LIST STYLES ==================== */
.tasks-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 16px;
}

.tasks-header-left {
    display: flex;
    align-items: center;
    gap: 12px;
}

.tasks-count-badge {
    background: var(--primary-light);
    color: var(--primary);
    padding: 4px 12px;
    border-radius: 20px;
    font-size: 13px;
    font-weight: 600;
}

.tasks-list {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.task-item {
    display: flex;
    align-items: center;
    gap: 16px;
    padding: 14px 16px;
    background: var(--body-bg);
    border: 1px solid var(--card-border);
    border-radius: 10px;
    transition: all 0.3s ease;
    text-decoration: none;
    color: inherit;
}

.task-item:hover {
    border-color: var(--primary);
    transform: translateX(4px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
}

.task-priority {
    width: 4px;
    height: 40px;
    border-radius: 2px;
    flex-shrink: 0;
}

.task-priority.critical { background: #dc2626; }
.task-priority.high { background: #f97316; }
.task-priority.medium { background: #eab308; }
.task-priority.low { background: #22c55e; }

.task-info {
    flex: 1;
    min-width: 0;
}

.task-title {
    font-size: 14px;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0 0 4px 0;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.task-meta {
    display: flex;
    align-items: center;
    gap: 12px;
    font-size: 12px;
    color: var(--text-muted);
}

.task-meta-item {
    display: flex;
    align-items: center;
    gap: 4px;
}

.task-meta-item svg {
    width: 12px;
    height: 12px;
}

.task-status {
    padding: 4px 10px;
    border-radius: 6px;
    font-size: 11px;
    font-weight: 600;
    white-space: nowrap;
}

.task-due {
    display: flex;
    align-items: center;
    gap: 6px;
    font-size: 12px;
    color: var(--text-muted);
    white-space: nowrap;
}

.task-due.overdue {
    color: #dc2626;
}

.task-due svg {
    width: 14px;
    height: 14px;
}

.task-arrow {
    width: 20px;
    height: 20px;
    color: var(--text-muted);
    transition: all 0.3s ease;
}

.task-item:hover .task-arrow {
    color: var(--primary);
    transform: translateX(4px);
}

.view-all-link {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    color: var(--primary);
    font-size: 13px;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.2s ease;
}

.view-all-link:hover {
    gap: 10px;
}

.view-all-link svg {
    width: 16px;
    height: 16px;
}

/* Header Section */
.project-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    animation: slideIn 0.3s ease;
}

.project-title-section { 
    display: flex; 
    align-items: center; 
    gap: 16px; 
}

.btn-back {
    width: 40px; 
    height: 40px;
    display: flex; 
    align-items: center; 
    justify-content: center;
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 10px;
    text-decoration: none;
    color: var(--text-primary);
    transition: all 0.3s ease;
}

.btn-back:hover {
    background: var(--primary);
    color: white;
    transform: translateX(-3px);
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
}

.project-id-badge {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 6px 12px;
    background: var(--primary-light);
    color: var(--primary);
    border-radius: 20px;
    font-size: 13px;
    font-weight: 600;
    margin-top: 8px;
}

/* Action Buttons */
.project-actions {
    display: flex;
    gap: 12px;
    flex-wrap: wrap;
}

.btn {
    padding: 10px 18px;
    border-radius: 10px;
    text-decoration: none;
    font-size: 13px;
    font-weight: 600;
    transition: all 0.3s ease;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    border: none;
    cursor: pointer;
}

.btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(0, 0, 0, 0.15);
}

.btn-primary {
    background: var(--primary);
    color: white;
}

.btn-primary:hover {
    background: var(--primary-hover);
    box-shadow: 0 6px 16px rgba(59, 130, 246, 0.4);
}

.btn-secondary {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    color: var(--text-primary);
}

.btn-secondary:hover {
    background: var(--primary-light);
    border-color: var(--primary);
    color: var(--primary);
}

.btn-icon {
    width: 16px;
    height: 16px;
}

/* ==================== COMPACT STATS GRID ==================== */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(160px, 1fr));
    gap: 12px;
    margin-bottom: 20px;
}

.stat-card {
    background: linear-gradient(135deg, var(--card-bg) 0%, var(--body-bg) 100%);
    border: 1px solid var(--card-border);
    border-radius: 10px;
    padding: 16px;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
    animation: fadeInUp 0.6s ease;
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 3px;
    height: 100%;
    background: var(--primary);
    transform: scaleY(0);
    transition: transform 0.3s ease;
}

.stat-card:hover::before {
    transform: scaleY(1);
}

.stat-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 6px 16px rgba(0, 0, 0, 0.1);
    border-color: var(--primary);
}

.stat-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 10px;
}

.stat-icon {
    width: 32px;
    height: 32px;
    padding: 6px;
    background: var(--primary-light);
    border-radius: 8px;
    color: var(--primary);
    display: flex;
    align-items: center;
    justify-content: center;
}

.stat-icon svg {
    width: 18px;
    height: 18px;
}

.stat-value {
    font-size: 26px;
    font-weight: 700;
    color: var(--primary);
    line-height: 1;
    margin: 6px 0;
}

.stat-label {
    font-size: 12px;
    color: var(--text-secondary);
    font-weight: 600;
}

/* Info Cards */
.info-card {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 12px;
    padding: 20px;
    margin-bottom: 20px;
    animation: fadeInUp 0.7s ease;
    transition: all 0.3s ease;
}

.info-card:hover {
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
}

.card-header {
    display: flex;
    align-items: center;
    gap: 12px;
    margin-bottom: 18px;
    padding-bottom: 12px;
    border-bottom: 2px solid var(--card-border);
}

.card-icon {
    width: 22px;
    height: 22px;
    color: var(--primary);
}

.card-title {
    font-size: 17px;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0;
}

.info-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
    gap: 16px;
}

.info-item {
    display: flex;
    flex-direction: column;
    gap: 6px;
    padding: 14px;
    background: var(--body-bg);
    border-radius: 8px;
    transition: all 0.3s ease;
}

.info-item:hover {
    background: var(--primary-light);
    transform: translateX(4px);
}

.info-label {
    display: flex;
    align-items: center;
    gap: 6px;
    font-size: 11px;
    color: var(--text-secondary);
    text-transform: uppercase;
    letter-spacing: 0.5px;
    font-weight: 600;
}

.info-label-icon {
    width: 13px;
    height: 13px;
    color: var(--text-muted);
}

.info-value {
    font-size: 15px;
    color: var(--text-primary);
    font-weight: 600;
}

.status-badge {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 5px 12px;
    background: var(--success-light);
    color: var(--success);
    border-radius: 16px;
    font-size: 13px;
    font-weight: 600;
}

.status-dot {
    width: 7px;
    height: 7px;
    border-radius: 50%;
    background: currentColor;
    animation: pulse 2s infinite;
}

/* Team Section */
.team-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
    gap: 10px;
}

.team-member {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 10px;
    background: var(--body-bg);
    border: 1px solid var(--card-border);
    border-radius: 8px;
    transition: all 0.3s ease;
}

.team-member:hover {
    background: var(--primary-light);
    border-color: var(--primary);
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(59, 130, 246, 0.2);
}

.team-avatar {
    width: 36px;
    height: 36px;
    background: var(--primary);
    color: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    font-size: 14px;
}

.team-name {
    font-weight: 600;
    font-size: 14px;
    color: var(--text-primary);
}

.empty-state {
    text-align: center;
    padding: 32px 20px;
    color: var(--text-muted);
}

.empty-state-icon {
    width: 56px;
    height: 56px;
    margin: 0 auto 12px;
    opacity: 0.3;
}

.empty-state p {
    font-size: 14px;
}

/* Notes Section */
.notes-section {
    margin-top: 16px;
    padding: 16px;
    background: var(--body-bg);
    border-radius: 8px;
    border-left: 3px solid var(--primary);
}

.notes-title {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 13px;
    font-weight: 700;
    color: var(--text-secondary);
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-bottom: 10px;
}

.notes-title svg {
    width: 14px;
    height: 14px;
}

.notes-content {
    color: var(--text-primary);
    font-size: 14px;
    line-height: 1.6;
    white-space: pre-wrap;
}

/* Responsive */
@media (max-width: 768px) {
    .project-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 16px;
    }
    
    .project-actions {
        width: 100%;
    }
    
    .btn {
        flex: 1;
        justify-content: center;
    }
    
    .stats-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .info-grid {
        grid-template-columns: 1fr;
    }
    
    .team-grid {
        grid-template-columns: 1fr;
    }
}

@media (max-width: 480px) {
    .stats-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<div class="project-view">
    <!-- Header -->
    <div class="project-header">
        <div class="project-title-section">
            <a href="{{ route('admin.projects.index') }}" class="btn-back" title="Back to Projects">
                <!-- Back Arrow SVG -->
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M19 12H5M12 19l-7-7 7-7"/>
                </svg>
            </a>
            <div>
                <h1 style="margin: 0; font-size: 28px;">{{ $project->title ?? $project->name ?? 'Project #'.$project->id }}</h1>
                <div class="project-id-badge">
                    <!-- ID Icon SVG -->
                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M10 13a5 5 0 0 0 7.54.54l3-3a5 5 0 0 0-7.07-7.07l-1.72 1.71"/>
                        <path d="M14 11a5 5 0 0 0-7.54-.54l-3 3a5 5 0 0 0 7.07 7.07l1.71-1.71"/>
                    </svg>
                    Project #{{ $project->id }}
                </div>
            </div>
        </div>
        <div class="project-actions">
            <a href="{{ route('admin.projects.edit', $project->id) }}" class="btn btn-secondary">
                <!-- Edit Icon SVG -->
                <svg class="btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"/>
                    <path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"/>
                </svg>
                Edit Project
            </a>
            <a href="{{ route('admin.projects.finance', $project->id) }}" class="btn btn-primary">
                <!-- Finance Icon SVG -->
                <svg class="btn-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <line x1="12" y1="1" x2="12" y2="23"/>
                    <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/>
                </svg>
                Finance
            </a>
        </div>
    </div>

    <!-- Stats Grid -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-header">
                <div class="stat-icon">
                    <!-- Tasks Icon SVG -->
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                        <polyline points="14 2 14 8 20 8"/>
                        <line x1="16" y1="13" x2="8" y2="13"/>
                        <line x1="16" y1="17" x2="8" y2="17"/>
                        <polyline points="10 9 9 9 8 9"/>
                    </svg>
                </div>
            </div>
            <div class="stat-value">{{ $stats['total_tasks'] }}</div>
            <div class="stat-label">Total Tasks</div>
        </div>

        <div class="stat-card">
            <div class="stat-header">
                <div class="stat-icon">
                    <!-- Completed Icon SVG -->
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/>
                        <polyline points="22 4 12 14.01 9 11.01"/>
                    </svg>
                </div>
            </div>
            <div class="stat-value" style="color: var(--success);">{{ $stats['completed_tasks'] }}</div>
            <div class="stat-label">Completed Tasks</div>
        </div>

        <div class="stat-card">
            <div class="stat-header">
                <div class="stat-icon">
                    <!-- Clock Icon SVG -->
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="12" cy="12" r="10"/>
                        <polyline points="12 6 12 12 16 14"/>
                    </svg>
                </div>
            </div>
            <div class="stat-value">{{ number_format($stats['total_hours'], 1) }}</div>
            <div class="stat-label">Total Hours</div>
        </div>

        <div class="stat-card">
            <div class="stat-header">
                <div class="stat-icon">
                    <!-- Money Icon SVG -->
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <rect x="1" y="4" width="22" height="16" rx="2" ry="2"/>
                        <line x1="1" y1="10" x2="23" y2="10"/>
                    </svg>
                </div>
            </div>
            <div class="stat-value" style="color: var(--warning);">{{ number_format($stats['billable_hours'], 1) }}</div>
            <div class="stat-label">Billable Hours</div>
        </div>
    </div>

    <!-- Project Details Card -->
    <div class="info-card">
        <div class="card-header">
            <!-- Details Icon SVG -->
            <svg class="card-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <circle cx="12" cy="12" r="10"/>
                <line x1="12" y1="16" x2="12" y2="12"/>
                <line x1="12" y1="8" x2="12.01" y2="8"/>
            </svg>
            <h3 class="card-title">Project Details</h3>
        </div>
        <div class="info-grid">
            {{-- Customer/Client Display --}}
            @php
                $customerName = null;
                if ($project->relationLoaded('account') && $project->account) {
                    $customerName = $project->account->company ?? $project->account->name ?? null;
                } elseif ($project->relationLoaded('customer') && $project->customer) {
                    $customerName = $project->customer->company ?? $project->customer->name ?? null;
                } elseif ($project->client_name) {
                    $customerName = $project->client_name;
                }
            @endphp
            @if($customerName)
            <div class="info-item">
                <div class="info-label">
                    <!-- Customer Icon SVG -->
                    <svg class="info-label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
                        <circle cx="12" cy="7" r="4"/>
                    </svg>
                    Customer
                </div>
                <div class="info-value">{{ $customerName }}</div>
            </div>
            @endif

            <div class="info-item">
                <div class="info-label">
                    <!-- Status Icon SVG -->
                    <svg class="info-label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="12" cy="12" r="10"/>
                        <path d="M12 6v6l4 2"/>
                    </svg>
                    Status
                </div>
                <div class="info-value">
                    <span class="status-badge">
                        <span class="status-dot"></span>
                        @if($project->relationLoaded('status') && $project->status)
                            {{ $project->status->label }}
                        @elseif($project->status)
                            {{ ucfirst(str_replace('_', ' ', $project->status)) }}
                        @else
                            Unknown
                        @endif
                    </span>
                </div>
            </div>

            <div class="info-item">
                <div class="info-label">
                    <!-- Billing Icon SVG -->
                    <svg class="info-label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M12 2v20M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/>
                    </svg>
                    Billing Method
                </div>
                <div class="info-value">{{ ucfirst(str_replace('_', ' ', $project->billing_method)) }}</div>
            </div>

            <div class="info-item">
                <div class="info-label">
                    <!-- Start Date Icon SVG -->
                    <svg class="info-label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <polygon points="5 3 19 12 5 21 5 3"/>
                    </svg>
                    Planned Start
                </div>
                <div class="info-value">{{ $project->planned_start_date ? $project->planned_start_date->format('M d, Y') : 'Not set' }}</div>
            </div>

            <div class="info-item">
                <div class="info-label">
                    <!-- End Date Icon SVG -->
                    <svg class="info-label-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <rect x="3" y="4" width="18" height="18" rx="2" ry="2"/>
                        <line x1="16" y1="2" x2="16" y2="6"/>
                        <line x1="8" y1="2" x2="8" y2="6"/>
                        <line x1="3" y1="10" x2="21" y2="10"/>
                    </svg>
                    Planned End
                </div>
                <div class="info-value">{{ $project->planned_end_date ? $project->planned_end_date->format('M d, Y') : 'Not set' }}</div>
            </div>
        </div>

        @if($project->scope_notes)
        <div class="notes-section">
            <div class="notes-title">
                <!-- Notes Icon SVG -->
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"/>
                    <polyline points="3.27 6.96 12 12.01 20.73 6.96"/>
                    <line x1="12" y1="22.08" x2="12" y2="12"/>
                </svg>
                Scope Notes
            </div>
            <div class="notes-content">{{ $project->scope_notes }}</div>
        </div>
        @endif
    </div>

    <!-- Team Members Card -->
    <div class="info-card">
        <div class="card-header">
            <!-- Team Icon SVG -->
            <svg class="card-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                <circle cx="9" cy="7" r="4"/>
                <path d="M23 21v-2a4 4 0 0 0-3-3.87"/>
                <path d="M16 3.13a4 4 0 0 1 0 7.75"/>
            </svg>
            <h3 class="card-title">Team Members ({{ $project->team->count() }})</h3>
        </div>
        @if($project->team->count() > 0)
        <div class="team-grid">
            @foreach($project->team as $member)
            <div class="team-member">
                <div class="team-avatar">
                    {{ strtoupper(substr($member->name, 0, 1)) }}
                </div>
                <div class="team-name">{{ $member->name }}</div>
            </div>
            @endforeach
        </div>
        @else
        <div class="empty-state">
            <!-- Empty Team Icon SVG -->
            <svg class="empty-state-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                <circle cx="9" cy="7" r="4"/>
                <path d="M23 21v-2a4 4 0 0 0-3-3.87"/>
                <path d="M16 3.13a4 4 0 0 1 0 7.75"/>
            </svg>
            <p style="margin: 0; font-weight: 500;">No team members assigned yet</p>
            <p style="margin: 8px 0 0 0; font-size: 14px;">Add team members to start collaborating</p>
        </div>
        @endif
    </div>

    <!-- Project Tasks Card - Only show if tasks table exists -->
    @php
        $hasTasksModule = Route::has('admin.tasks.index');
        $taskCount = isset($tasks) ? $tasks->count() : 0;
        // Use hasTasksTable from controller if available, otherwise check Schema
        $showTasksSection = isset($hasTasksTable) ? $hasTasksTable : false;
    @endphp
    
    @if($showTasksSection)
    <div class="info-card">
        <div class="card-header">
            <!-- Tasks Icon SVG -->
            <svg class="card-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M9 11l3 3L22 4"/>
                <path d="M21 12v7a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11"/>
            </svg>
            <h3 class="card-title">Project Tasks</h3>
        </div>
        
        <div class="tasks-header">
            <div class="tasks-header-left">
                <span class="tasks-count-badge">{{ $taskCount }} Tasks</span>
            </div>
            @if($taskCount > 0 && $hasTasksModule)
            <a href="{{ route('admin.tasks.index', ['project_id' => $project->id]) }}" class="view-all-link">
                View All
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M5 12h14"/>
                    <path d="M12 5l7 7-7 7"/>
                </svg>
            </a>
            @endif
        </div>

        @if($taskCount > 0)
        <div class="tasks-list">
            @foreach($tasks->take(10) as $task)
            @php
                $taskTitle = $task->title ?? $task->name ?? $task->subject ?? 'Task #'.$task->id;
                $taskStatus = $task->status ?? 'pending';
                $taskPriority = $task->priority ?? 'medium';
                $taskDueDate = $task->due_date ?? $task->deadline ?? null;
                
                // Status colors
                $statusColors = [
                    'pending' => '#f59e0b',
                    'in_progress' => '#3b82f6',
                    'completed' => '#10b981',
                    'on_hold' => '#6b7280',
                    'cancelled' => '#ef4444',
                    'todo' => '#8b5cf6',
                    'open' => '#3b82f6',
                    'closed' => '#10b981',
                ];
                $statusColor = $statusColors[$taskStatus] ?? '#6b7280';
                $taskUrl = $hasTasksModule ? route('admin.tasks.show', $task->id) : '#';
            @endphp
            <a href="{{ $taskUrl }}" class="task-item" @if(!$hasTasksModule) onclick="return false;" style="cursor: default;" @endif>
                <div class="task-priority {{ $taskPriority }}"></div>
                <div class="task-info">
                    <h4 class="task-title">{{ $taskTitle }}</h4>
                    <div class="task-meta">
                        @if(isset($task->estimated_hours) && $task->estimated_hours)
                        <span class="task-meta-item">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <circle cx="12" cy="12" r="10"/>
                                <polyline points="12 6 12 12 16 14"/>
                            </svg>
                            {{ $task->estimated_hours }}h
                        </span>
                        @endif
                        @if(isset($task->created_at))
                        <span class="task-meta-item">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <rect x="3" y="4" width="18" height="18" rx="2" ry="2"/>
                                <line x1="16" y1="2" x2="16" y2="6"/>
                                <line x1="8" y1="2" x2="8" y2="6"/>
                                <line x1="3" y1="10" x2="21" y2="10"/>
                            </svg>
                            {{ \Carbon\Carbon::parse($task->created_at)->format('M d, Y') }}
                        </span>
                        @endif
                    </div>
                </div>
                <span class="task-status" style="background: {{ $statusColor }}20; color: {{ $statusColor }};">
                    {{ ucfirst(str_replace('_', ' ', $taskStatus)) }}
                </span>
                @if($taskDueDate)
                @php
                    $dueDate = \Carbon\Carbon::parse($taskDueDate);
                    $isOverdue = $dueDate->isPast() && !in_array($taskStatus, ['completed', 'closed', 'cancelled']);
                @endphp
                <span class="task-due {{ $isOverdue ? 'overdue' : '' }}">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <rect x="3" y="4" width="18" height="18" rx="2" ry="2"/>
                        <line x1="16" y1="2" x2="16" y2="6"/>
                        <line x1="8" y1="2" x2="8" y2="6"/>
                        <line x1="3" y1="10" x2="21" y2="10"/>
                    </svg>
                    {{ $dueDate->format('M d') }}
                </span>
                @endif
                @if($hasTasksModule)
                <svg class="task-arrow" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
                @endif
            </a>
            @endforeach
        </div>
        
        @if($taskCount > 10 && $hasTasksModule)
        <div style="text-align: center; margin-top: 16px;">
            <a href="{{ route('admin.tasks.index', ['project_id' => $project->id]) }}" class="btn btn-secondary">
                View All {{ $taskCount }} Tasks
            </a>
        </div>
        @endif
        @else
        <div class="empty-state">
            <!-- Empty Tasks Icon SVG -->
            <svg class="empty-state-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M9 11l3 3L22 4"/>
                <path d="M21 12v7a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11"/>
            </svg>
            <p style="margin: 0; font-weight: 500;">No tasks created yet</p>
        </div>
        @endif
    </div>
    @endif
</div>