<?php

use Illuminate\Support\Facades\Route;
use Modules\Projects\Http\Controllers\ProjectController;
use Modules\Projects\Http\Controllers\MilestoneController;
use Modules\Projects\Http\Controllers\DiscussionController;
use Modules\Projects\Http\Controllers\DashboardController;
use App\Http\Middleware\EnsureIsAdmin;

// All routes under admin/projects prefix so menu stays active
Route::prefix('admin/projects')
    ->middleware([EnsureIsAdmin::class])
    ->group(function () {
        
        // ==================== DASHBOARD ====================
        Route::get('/dashboard', [DashboardController::class, 'index'])->name('admin.project-management.dashboard');
        Route::get('/chart-data', [DashboardController::class, 'chartData'])->name('admin.project-management.chart-data');
        Route::get('/refresh-stats', [DashboardController::class, 'refreshStats'])->name('admin.project-management.refresh-stats');
        
        // ==================== PROJECTS ====================
        Route::get('/', [ProjectController::class, 'index'])->name('admin.projects.index');
        Route::get('/data', [ProjectController::class, 'dataTable'])->name('admin.projects.data');
        Route::get('/stats', [ProjectController::class, 'stats'])->name('admin.projects.stats');
        Route::post('/bulk-delete', [ProjectController::class, 'bulkDelete'])->name('admin.projects.bulk-delete');
        Route::get('/create', [ProjectController::class, 'create'])->name('admin.projects.create');
        Route::post('/store', [ProjectController::class, 'store'])->name('admin.projects.store');
        Route::get('/{id}/overview', [ProjectController::class, 'overview'])->name('admin.projects.overview');
        Route::get('/{id}/view', [ProjectController::class, 'show'])->name('admin.projects.show');
        Route::get('/{id}/edit', [ProjectController::class, 'edit'])->name('admin.projects.edit');
        Route::put('/{id}', [ProjectController::class, 'update'])->name('admin.projects.update');
        Route::delete('/{id}', [ProjectController::class, 'destroy'])->name('admin.projects.destroy');
        Route::post('/{id}/pin', [ProjectController::class, 'pin'])->name('admin.projects.pin');
        Route::post('/{id}/duplicate', [ProjectController::class, 'duplicate'])->name('admin.projects.duplicate');
        Route::get('/{id}/finance', [ProjectController::class, 'finance'])->name('admin.projects.finance');
        Route::post('/{id}/generate-invoice', [ProjectController::class, 'generateInvoice'])->name('admin.projects.generate-invoice');
        
        // ==================== MILESTONES ====================
        Route::prefix('milestones')->group(function () {
            Route::get('/', [MilestoneController::class, 'index'])->name('admin.milestones.index');
            Route::get('/data', [MilestoneController::class, 'dataTable'])->name('admin.milestones.data');
            Route::get('/stats', [MilestoneController::class, 'stats'])->name('admin.milestones.stats');
            Route::get('/create', [MilestoneController::class, 'create'])->name('admin.milestones.create');
            Route::post('/', [MilestoneController::class, 'store'])->name('admin.milestones.store');
            Route::post('/bulk-delete', [MilestoneController::class, 'bulkDelete'])->name('admin.milestones.bulk-delete');
            Route::get('/{id}', [MilestoneController::class, 'show'])->name('admin.milestones.show');
            Route::get('/{id}/edit', [MilestoneController::class, 'edit'])->name('admin.milestones.edit');
            Route::put('/{id}', [MilestoneController::class, 'update'])->name('admin.milestones.update');
            Route::delete('/{id}', [MilestoneController::class, 'destroy'])->name('admin.milestones.destroy');
        });
        
        // ==================== DISCUSSIONS ====================
        Route::prefix('discussions')->group(function () {
            Route::get('/', [DiscussionController::class, 'index'])->name('admin.discussions.index');
            Route::get('/data', [DiscussionController::class, 'dataTable'])->name('admin.discussions.data');
            Route::get('/stats', [DiscussionController::class, 'stats'])->name('admin.discussions.stats');
            Route::get('/create', [DiscussionController::class, 'create'])->name('admin.discussions.create');
            Route::post('/', [DiscussionController::class, 'store'])->name('admin.discussions.store');
            Route::post('/bulk-delete', [DiscussionController::class, 'bulkDelete'])->name('admin.discussions.bulk-delete');
            
            // Attachment routes (must be before {id} routes)
            Route::get('/attachment/{id}/preview', [DiscussionController::class, 'previewAttachment'])->name('admin.discussions.attachment.preview');
            Route::get('/attachment/{id}/download', [DiscussionController::class, 'downloadAttachment'])->name('admin.discussions.attachment.download');
            Route::delete('/attachment/{id}', [DiscussionController::class, 'deleteAttachment'])->name('admin.discussions.attachment.delete');
            
            // ID-based routes (must come after specific routes)
            Route::get('/{id}', [DiscussionController::class, 'show'])->name('admin.discussions.show');
            Route::delete('/{id}', [DiscussionController::class, 'destroy'])->name('admin.discussions.destroy');
            Route::post('/{id}/reply', [DiscussionController::class, 'addReply'])->name('admin.discussions.reply');
            Route::delete('/{id}/reply/{replyId}', [DiscussionController::class, 'deleteReply'])->name('admin.discussions.delete-reply');
        });
    });
