@include('purchase::partials.styles')

<div style="padding: 20px;">
    <div class="page-header">
        <h1>Goods Receipt Notes</h1>
        <a href="{{ route('admin.purchase.grn.create') }}" class="btn-add">+ Create GRN</a>
    </div>

    @if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if(session('error'))
    <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon total">📦</div>
            <div><div class="stat-value">{{ $stats['total'] }}</div><div class="stat-label">Total GRN</div></div>
        </div>
        <div class="stat-card">
            <div class="stat-icon draft">📝</div>
            <div><div class="stat-value">{{ $stats['draft'] }}</div><div class="stat-label">Draft</div></div>
        </div>
        <div class="stat-card">
            <div class="stat-icon inspecting">🔍</div>
            <div><div class="stat-value">{{ $stats['inspecting'] }}</div><div class="stat-label">Inspecting</div></div>
        </div>
        <div class="stat-card">
            <div class="stat-icon approved">✅</div>
            <div><div class="stat-value">{{ $stats['approved'] }}</div><div class="stat-label">Approved</div></div>
        </div>
    </div>

    <div class="table-card">
        <div class="table-card-header">
            <div class="table-card-title">GRN List</div>
            <div class="filter-group">
                <select class="filter-select" data-dt-filter="status">
                    <option value="">All Status</option>
                    <option value="DRAFT">Draft</option>
                    <option value="INSPECTING">Inspecting</option>
                    <option value="APPROVED">Approved</option>
                    <option value="REJECTED">Rejected</option>
                    <option value="CANCELLED">Cancelled</option>
                </select>
            </div>
        </div>
        <div class="table-card-body">
            <table class="dt-table dt-search dt-export dt-perpage dt-checkbox" 
                   data-route="{{ route('admin.purchase.grn.data') }}"
                   data-delete-route="{{ route('admin.purchase.grn.bulk-delete') }}">
                <thead>
                    <tr>
                        <th class="dt-sort dt-clickable" data-col="grn_number">GRN Number</th>
                        <th class="dt-sort" data-col="grn_date">Date</th>
                        <th data-col="po_number">PO Number</th>
                        <th data-col="vendor_name">Vendor</th>
                        <th data-col="warehouse_name">Warehouse</th>
                        <th data-col="accepted_qty">Accepted Qty</th>
                        <th data-col="stock_updated" data-render="stock_badge">Stock</th>
                        <th class="dt-sort" data-col="status" data-render="badge">Status</th>
                        <th data-render="actions">Actions</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>

<!-- Reject Modal -->
<div id="rejectModal" style="display:none; position:fixed; top:0; left:0; right:0; bottom:0; background:rgba(0,0,0,0.5); z-index:9999; align-items:center; justify-content:center;">
    <div style="background:#fff; padding:20px; border-radius:8px; width:400px; max-width:90%;">
        <h3 style="margin-top:0;">Reject GRN</h3>
        <form id="rejectForm" method="POST">
            @csrf
            <div style="margin-bottom:15px;">
                <label>Reason:</label>
                <textarea name="rejection_reason" required style="width:100%; padding:8px; border:1px solid #ddd; border-radius:4px; min-height:80px;"></textarea>
            </div>
            <div style="text-align:right;">
                <button type="button" onclick="closeRejectModal()" class="btn btn-outline">Cancel</button>
                <button type="submit" class="btn btn-danger">Reject</button>
            </div>
        </form>
    </div>
</div>

@include('components.datatable')

<script>
// Custom render for stock status
window.dtRenders = window.dtRenders || {};
window.dtRenders['stock_badge'] = function(value, row) {
    if (value === true || value === 'Updated' || value === 1 || value === '1') {
        return '<span class="dt-badge dt-badge-success">Updated</span>';
    }
    return '<span class="dt-badge dt-badge-warning">Pending</span>';
};

function quickApprove(url) {
    if (confirm('Approve this GRN and update stock?')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = url;
        form.innerHTML = '@csrf';
        document.body.appendChild(form);
        form.submit();
    }
}

function showRejectModal(url) {
    document.getElementById('rejectForm').action = url;
    document.getElementById('rejectModal').style.display = 'flex';
}

function closeRejectModal() {
    document.getElementById('rejectModal').style.display = 'none';
}

document.addEventListener('DOMContentLoaded', function() {
    const originalRender = window.dtRenderActions;
    if (originalRender) {
        window.dtRenderActions = function(row) {
            let html = '';
            if (row._approve_url) {
                html += `<button onclick="quickApprove('${row._approve_url}')" class="btn btn-success btn-sm" title="Approve">✅</button> `;
            }
            if (row._reject_url) {
                html += `<button onclick="showRejectModal('${row._reject_url}')" class="btn btn-danger btn-sm" title="Reject">❌</button> `;
            }
            if (row._bill_url) {
                html += `<a href="${row._bill_url}" class="btn btn-info btn-sm" title="Create Bill">📄 Bill</a> `;
            }
            return html + originalRender(row);
        };
    }
});
</script>
