<?php

namespace Modules\Service\Services;

/**
 * Service Module Service
 * 
 * Provides module configuration and menu structure for auto-registration.
 */
class ServiceModuleService
{
    /**
     * Module configuration
     */
    public static function config(): array
    {
        return [
            'name' => 'Services',
            'alias' => 'service',
            'description' => 'Service Management - Manage services offered',
            'version' => '1.0.0',
            'is_core' => false,
            'sort_order' => 55,
        ];
    }

    /**
     * Menu configuration for auto-registration
     */
    public static function menus(): array
    {
        return [
            [
                'menu_name' => 'Services',
                'slug' => 'services',
                'icon' => 'cog',
                'route' => 'admin.service.index',
                'category' => 'core',
                'sort_order' => 55,
                'actions' => ['read', 'create', 'edit', 'delete', 'export', 'import'],
            ],
        ];
    }

    /**
     * Get module alias
     */
    public static function getAlias(): string
    {
        return self::config()['alias'];
    }

    /**
     * Get module name
     */
    public static function getName(): string
    {
        return self::config()['name'];
    }
}