<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Module Information
    |--------------------------------------------------------------------------
    */
    'name' => 'Support',
    'alias' => 'support',

    /*
    |--------------------------------------------------------------------------
    | Route Prefixes
    |--------------------------------------------------------------------------
    */
    'prefix' => [
        'admin' => 'admin/support',
        'client' => 'support',
    ],

    /*
    |--------------------------------------------------------------------------
    | Pagination Settings
    |--------------------------------------------------------------------------
    */
    'pagination' => [
        'tickets' => 25,
        'departments' => 15,
        'priorities' => 15,
        'statuses' => 15,
        'predefined_replies' => 20,
        'client_tickets' => 15,
    ],

    /*
    |--------------------------------------------------------------------------
    | Default Priority Levels
    |--------------------------------------------------------------------------
    */
    'default_priorities' => [
        ['name' => 'Low', 'color' => '#28a745', 'priority_order' => 1],
        ['name' => 'Medium', 'color' => '#ffc107', 'priority_order' => 2],
        ['name' => 'High', 'color' => '#dc3545', 'priority_order' => 3],
    ],

    /*
    |--------------------------------------------------------------------------
    | Default Status Options
    |--------------------------------------------------------------------------
    */
    'default_statuses' => [
        ['name' => 'Open', 'status_color' => '#ff2d42', 'status_order' => 1, 'is_default' => true, 'allow_client_change' => false],
        ['name' => 'In Progress', 'status_color' => '#84c529', 'status_order' => 2, 'is_default' => false, 'allow_client_change' => false],
        ['name' => 'Answered', 'status_color' => '#0000ff', 'status_order' => 3, 'is_default' => false, 'allow_client_change' => false],
        ['name' => 'On Hold', 'status_color' => '#c0c0c0', 'status_order' => 4, 'is_default' => false, 'allow_client_change' => false],
        ['name' => 'Closed', 'status_color' => '#03a9f4', 'status_order' => 5, 'is_default' => false, 'allow_client_change' => true],
    ],

    /*
    |--------------------------------------------------------------------------
    | Ticket Settings
    |--------------------------------------------------------------------------
    */
    'ticket' => [
        'auto_assign' => false, // Auto-assign to staff
        'allow_guest_tickets' => true, // Tickets without customer login
        'require_customer_selection' => false, // Force customer selection
        'ticket_key_length' => 32, // Unique key length
        'allow_client_status_change' => true, // Clients can change status
        'close_ticket_on_reply' => false, // Auto-close after admin reply
        'mark_read_on_view' => true, // Auto-mark as read when opened
    ],

    /*
    |--------------------------------------------------------------------------
    | File Upload Settings
    |--------------------------------------------------------------------------
    */
    'uploads' => [
        'max_size' => 10240, // KB (10MB)
        'max_files_per_ticket' => 10,
        'max_files_per_reply' => 5,
        'allowed_extensions' => [
            'pdf', 'doc', 'docx', 'xls', 'xlsx', 
            'txt', 'jpg', 'jpeg', 'png', 'gif', 
            'zip', 'rar', '7z'
        ],
        'allowed_mime_types' => [
            'application/pdf',
            'application/msword',
            'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
            'application/vnd.ms-excel',
            'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
            'text/plain',
            'image/jpeg',
            'image/png',
            'image/gif',
            'application/zip',
            'application/x-rar-compressed',
            'application/x-7z-compressed',
        ],
        'storage_disk' => 'public',
        'storage_path' => 'support_tickets',
    ],

    /*
    |--------------------------------------------------------------------------
    | Email Notifications
    |--------------------------------------------------------------------------
    */
    'emails' => [
        'enabled' => true,
        'notify_customer_on_ticket_creation' => true,
        'notify_customer_on_reply' => true,
        'notify_customer_on_status_change' => true,
        'notify_staff_on_new_ticket' => true,
        'notify_staff_on_reply' => true,
        'notify_assigned_staff' => true,
        'cc_department_email' => true, // CC department email
        'from_name' => env('MAIL_FROM_NAME', 'EchoPx Support'),
        'from_email' => env('MAIL_FROM_ADDRESS', 'support@echopx.com'),
    ],

    /*
    |--------------------------------------------------------------------------
    | Client Portal Settings
    |--------------------------------------------------------------------------
    */
    'client_portal' => [
        'enabled' => true,
        'show_ticket_key_in_url' => true, // Public URL access via ticket key
        'allow_ticket_creation' => true,
        'allow_reply' => true,
        'show_department' => true,
        'show_priority' => true,
        'show_assigned_staff' => false, // Hide staff info from clients
        'show_custom_fields' => true,
        'items_per_page' => 15,
    ],

    /*
    |--------------------------------------------------------------------------
    | Department Settings
    |--------------------------------------------------------------------------
    */
    'department' => [
        'require_selection' => true,
        'show_inactive_to_clients' => false,
        'auto_assign_by_department' => false, // Auto-assign based on dept
    ],

    /*
    |--------------------------------------------------------------------------
    | Priority Settings
    |--------------------------------------------------------------------------
    */
    'priority' => [
        'default_priority_id' => 2, // Medium priority by default
        'show_to_clients' => true,
        'allow_client_change' => false, // Clients cannot change priority
    ],

    /*
    |--------------------------------------------------------------------------
    | Status Settings
    |--------------------------------------------------------------------------
    */
    'status' => [
        'default_status_id' => 1, // Open status by default
        'auto_change_on_reply' => false, // Auto-change status on reply
        'closed_statuses' => ['Closed'], // Statuses considered as closed
    ],

    /*
    |--------------------------------------------------------------------------
    | Reply Settings
    |--------------------------------------------------------------------------
    */
    'reply' => [
        'enable_predefined_replies' => true,
        'show_staff_signature' => true,
        'allow_empty_reply' => false,
        'max_reply_length' => 10000, // Characters
        'enable_rich_text' => true,
    ],

    /*
    |--------------------------------------------------------------------------
    | Permissions
    |--------------------------------------------------------------------------
    */
    'permissions' => [
        'view_tickets' => 'View Tickets',
        'create_tickets' => 'Create Tickets',
        'edit_tickets' => 'Edit Tickets',
        'delete_tickets' => 'Delete Tickets',
        'reply_tickets' => 'Reply to Tickets',
        'assign_tickets' => 'Assign Tickets',
        'change_priority' => 'Change Priority',
        'change_status' => 'Change Status',
        'merge_tickets' => 'Merge Tickets',
        'manage_departments' => 'Manage Departments',
        'manage_priorities' => 'Manage Priorities',
        'manage_statuses' => 'Manage Statuses',
        'manage_predefined_replies' => 'Manage Predefined Replies',
        'view_all_tickets' => 'View All Tickets',
        'export_data' => 'Export Data',
    ],

    /*
    |--------------------------------------------------------------------------
    | Feature Flags
    |--------------------------------------------------------------------------
    */
    'features' => [
        'enable_attachments' => true,
        'enable_predefined_replies' => true,
        'enable_ticket_merge' => true,
        'enable_cc' => true,
        'enable_project_linking' => false, // Link tickets to projects
        'enable_service_linking' => false, // Link tickets to services
        'enable_custom_fields' => false, // Future: Custom fields support
        'enable_bulk_actions' => true,
        'enable_export' => true,
        'enable_public_url' => true, // Access via ticket key without login
    ],

    /*
    |--------------------------------------------------------------------------
    | Search Settings
    |--------------------------------------------------------------------------
    */
    'search' => [
        'min_characters' => 3,
        'max_results' => 50,
        'search_fields' => [
            'id',
            'ticket_key',
            'subject',
            'message',
            'name',
            'email',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Menu Settings
    |--------------------------------------------------------------------------
    */
    'menu' => [
        'icon' => 'life-ring', // or 'headset' or 'comment-dots'
        'position' => 25,
        'show_unread_count' => true,
        'show_open_count' => true,
    ],

    /*
    |--------------------------------------------------------------------------
    | Validation Rules
    |--------------------------------------------------------------------------
    */
    'validation' => [
        'subject_min' => 3,
        'subject_max' => 191,
        'message_min' => 10,
        'message_max' => 10000,
        'name_max' => 255,
        'email_max' => 255,
        'cc_max' => 191,
    ],

    /*
    |--------------------------------------------------------------------------
    | Cache Settings
    |--------------------------------------------------------------------------
    */
    'cache' => [
        'enabled' => true,
        'ttl' => 3600, // 1 hour in seconds
        'prefix' => 'support_',
        'tags' => ['tickets', 'departments', 'priorities', 'statuses', 'replies'],
    ],

    /*
    |--------------------------------------------------------------------------
    | Export Settings
    |--------------------------------------------------------------------------
    */
    'export' => [
        'max_rows' => 10000,
        'chunk_size' => 1000,
        'formats' => ['csv', 'excel'],
        'include_replies' => true,
        'include_attachments_info' => true,
    ],

    /*
    |--------------------------------------------------------------------------
    | Auto-Assignment Rules (Future)
    |--------------------------------------------------------------------------
    */
    'auto_assignment' => [
        'enabled' => false,
        'method' => 'round_robin', // round_robin, least_active, department_based
        'exclude_inactive_staff' => true,
    ],

    /*
    |--------------------------------------------------------------------------
    | SLA Settings (Future)
    |--------------------------------------------------------------------------
    */
    'sla' => [
        'enabled' => false,
        'response_time' => [
            'low' => 24, // hours
            'medium' => 12,
            'high' => 4,
        ],
        'resolution_time' => [
            'low' => 72, // hours
            'medium' => 48,
            'high' => 24,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Display Settings
    |--------------------------------------------------------------------------
    */
    'display' => [
        'date_format' => 'M d, Y',
        'time_format' => 'g:i A',
        'datetime_format' => 'M d, Y g:i A',
        'timezone' => 'Asia/Kolkata',
        'items_per_page' => 25,
    ],
];