<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('support_departments', function (Blueprint $table) {
            $table->id();
            
            // Department Information
            $table->string('name', 191);
            $table->text('description')->nullable();
            
            // Visibility
            $table->boolean('is_active')->default(true);
            $table->boolean('show_on_client_portal')->default(true);
            
            // Display Order
            $table->integer('department_order')->default(0);
            
            $table->timestamps();
            
            // Indexes
            $table->index('is_active');
            $table->index('show_on_client_portal');
            $table->index('department_order');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('support_departments');
    }
};