<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Create table
        Schema::create('support_priorities', function (Blueprint $table) {
            $table->id();
            
            // Priority Information
            $table->string('name', 50);
            
            // Display Settings
            $table->string('color', 7)->default('#84c529')
                  ->comment('Hex color code for priority badge');
            $table->integer('priority_order')->default(0);
            
            // Status
            $table->boolean('is_active')->default(true);
            
            $table->timestamps();
            
            // Indexes
            $table->index('is_active');
            $table->index('priority_order');
        });

        // Insert default priorities with beautiful colors
        DB::table('support_priorities')->insert([
            [
                'name' => 'Low',
                'color' => '#22c55e',  // Beautiful Green
                'priority_order' => 1,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Medium',
                'color' => '#f59e0b',  // Vibrant Amber/Orange
                'priority_order' => 2,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'High',
                'color' => '#ef4444',  // Bold Red
                'priority_order' => 3,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Urgent',
                'color' => '#dc2626',  // Deep Critical Red
                'priority_order' => 4,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('support_priorities');
    }
};