<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Create table
        Schema::create('support_statuses', function (Blueprint $table) {
            $table->id();
            
            // Status Information
            $table->string('name', 50);
            
            // Display Settings
            $table->string('status_color', 7)->nullable()
                  ->comment('Hex color code for status badge');
            $table->integer('status_order')->default(0);
            
            // Default Status Flag
            $table->boolean('is_default')->default(false)
                  ->comment('Default status for new tickets');
            
            // Client Portal Settings
            $table->boolean('allow_client_change')->default(false)
                  ->comment('Can clients change to this status?');
            
            // Status
            $table->boolean('is_active')->default(true);
            
            $table->timestamps();
            
            // Indexes
            $table->index('is_default');
            $table->index('is_active');
            $table->index('status_order');
            $table->index('allow_client_change');
        });

        // Insert EXACT data from your existing tbltickets_status table
        DB::table('support_statuses')->insert([
            [
                'name' => 'Open',
                'status_color' => '#ff2d42',  // Red from your DB
                'is_default' => true,
                'status_order' => 1,
                'allow_client_change' => false,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'In progress',
                'status_color' => '#84c529',  // Green from your DB
                'is_default' => false,
                'status_order' => 2,
                'allow_client_change' => false,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Answered',
                'status_color' => '#0000ff',  // Blue from your DB
                'is_default' => false,
                'status_order' => 3,
                'allow_client_change' => false,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'On Hold',
                'status_color' => '#c0c0c0',  // Silver/Gray from your DB
                'is_default' => false,
                'status_order' => 4,
                'allow_client_change' => false,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Closed',
                'status_color' => '#03a9f4',  // Light Blue from your DB
                'is_default' => false,
                'status_order' => 5,
                'allow_client_change' => true,  // Clients can close tickets
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('support_statuses');
    }
};