<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('support_predefined_replies', function (Blueprint $table) {
            $table->id();
            
            // Reply Template Information
            $table->string('name', 191)
                  ->comment('Template name for quick selection');
            $table->text('message')
                  ->comment('Pre-written reply content');
            
            // Department Association (Optional)
            $table->foreignId('department_id')->nullable()
                  ->constrained('support_departments')
                  ->nullOnDelete();
            
            // Status
            $table->boolean('is_active')->default(true);
            
            $table->timestamps();
            
            // Indexes
            $table->index('is_active');
            $table->index('department_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('support_predefined_replies');
    }
};