<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('support_ticket_replies', function (Blueprint $table) {
            $table->id();
            
            // Parent Ticket
            $table->foreignId('ticket_id')
                  ->constrained('support_tickets')
                  ->cascadeOnDelete();
            
            // Reply Content
            $table->text('message')->nullable();
            
            // Replier Information - Customer
            $table->foreignId('customer_id')->nullable()
                  ->comment('Customer who replied (NULL if staff replied)')
                  ->constrained('customers')
                  ->nullOnDelete();
            
            $table->integer('contact_id')->default(0)
                  ->comment('Contact person ID if customer has multiple contacts');
            
            // Manual Entry (when not from customer table)
            $table->string('name', 255)->nullable()
                  ->comment('Replier name - auto-filled from customer or manual');
            $table->string('email', 255)->nullable()
                  ->comment('Replier email - auto-filled from customer or manual');
            
            // Replier Information - Staff (From staffs table - Image 1)
            $table->foreignId('staff_id')->nullable()
                  ->comment('Staff who replied (NULL if customer replied)')
                  ->constrained('staffs')
                  ->nullOnDelete();
            
            // Attachment Flag
            $table->boolean('has_attachment')->default(false)
                  ->comment('Quick flag to check if reply has attachments');
            
            $table->timestamp('replied_at')->useCurrent();
            $table->timestamps();
            
            // Indexes
            $table->index('ticket_id');
            $table->index('customer_id');
            $table->index('staff_id');
            $table->index('contact_id');
            $table->index('replied_at');
            $table->index(['ticket_id', 'replied_at']); // Composite for chronological replies
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('support_ticket_replies');
    }
};